/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-08 10:33:03 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=889 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=508 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "2", "FAISONS CONNAÎTRE NOTRE MARCHÉ | Court Circuit en Corbières", "", "http://court-circuit.local/faisons-connaitre-notre-marche/", "127.0.0.1", "2025-11-10 16:30:38", "2025-11-10 15:30:38", "[&#8230;] CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Robert Nagel (champignons) ou le télécharger ici [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.8.3", "pingback", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "108", "Liste des produits vendus | Court Circuit en Corbières", "", "http://court-circuit.local/liste-des-produits-vendus/", "127.0.0.1", "2025-11-10 17:02:12", "2025-11-10 16:02:12", "[&#8230;] Fromages  de chèvre producteurs   [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.8.3", "pingback", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "court_circuit_admin", "02c24c6bec387df75099_20251208103151", "21", "2025-12-08 10:33:02", "courtcircuit", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-08 10:31:51\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:19:\"court_circuit_admin\";s:4:\"Hash\";s:35:\"02c24c6bec387df75099_20251208103151\";s:8:\"NameHash\";s:55:\"court_circuit_admin_02c24c6bec387df75099_20251208103151\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:65:\"court_circuit_admin_02c24c6bec387df75099_20251208103151_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:12:\"courtcircuit\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:67:\"court_circuit_admin_02c24c6bec387df75099_20251208103151_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:51:\"C:/Users/Aline/Local Sites/court-circuit/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:995;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5761;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-08 10:31:51\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"court_circuit_admin\";s:4:\"Hash\";s:35:\"02c24c6bec387df75099_20251208103151\";s:8:\"NameHash\";s:55:\"court_circuit_admin_02c24c6bec387df75099_20251208103151\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:73:\"court_circuit_admin_02c24c6bec387df75099_20251208103151_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:65:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:68:\"court_circuit_admin_02c24c6bec387df75099_20251208103151_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:152:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/backups-dup-lite/tmp/court_circuit_admin_02c24c6bec387df75099_20251208103151_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:60:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-admin\";i:1;s:63:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-includes\";i:2;s:72:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:51:\"C:/Users/Aline/Local Sites/court-circuit/app/public\";i:1;s:51:\"C:/Users/Aline/Local Sites/court-circuit/app/public\";i:2;s:62:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content\";i:3;s:70:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/uploads\";i:4;s:70:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/plugins\";i:5;s:73:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/mu-plugins\";i:6;s:69:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:83:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:12:{i:1765192986;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765207386;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765207517;a:3:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765207520;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765207577;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765210984;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765212784;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765214584;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765293786;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765803600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766160443;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://court-circuit.local", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://court-circuit.local", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "Le blog de l&#039;association et du marché du vendredi à Laroque de Fa", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "dev-email@wpengine.local", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "G\\hi", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "d F Y G\\hi", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:94:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:2:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:23:\"gutenberg/gutenberg.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:5:{i:0;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/style.css\";i:1;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/gutenberg.php\";i:3;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/post-content.php\";i:4;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/fonts/OFL.txt\";i:5;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/functions.php\";}", "off");
INSERT INTO `wp_options` VALUES("41", "template", "twentythirteen", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "twentythirteen", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "posts", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "Europe/Paris", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "0", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1766244184", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:10:{i:2;a:1:{s:7:\"content\";s:51:\"<!-- wp:search {\"placeholder\":\"L\'association\"} /-->\";}i:3;a:1:{s:7:\"content\";s:190:\"<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Articles récents</h2>\n<!-- /wp:heading -->\n\n<!-- wp:latest-posts /--></div>\n<!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:264:\"<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Commentaires récents</h2>\n<!-- /wp:heading -->\n\n<!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div>\n<!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:177:\"<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Archives</h2>\n<!-- /wp:heading -->\n\n<!-- wp:archives /--></div>\n<!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:439:\"<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Catégories</h2>\n<!-- /wp:heading -->\n\n<!-- wp:categories /-->\n\n<!-- wp:list -->\n<ul class=\"wp-block-list\"><!-- wp:list-item -->\n<li></li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:legacy-widget {\"idBase\":\"nav_menu\",\"instance\":{\"encoded\":\"YTowOnt9\",\"hash\":\"f1c31013b7ad79f10374747cb83bc3b5\",\"raw\":{}}} /--></div>\n<!-- /wp:group -->\";}i:8;a:1:{s:7:\"content\";s:87:\"<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\"></h5>\n<!-- /wp:heading -->\";}i:9;a:1:{s:7:\"content\";s:90:\"<!-- wp:image -->\n<figure class=\"wp-block-image\"><img alt=\"\"/></figure>\n<!-- /wp:image -->\";}i:10;a:1:{s:7:\"content\";s:23:\"<!-- wp:categories /-->\";}s:12:\"_multiwidget\";i:1;i:12;a:1:{s:7:\"content\";s:52:\"<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\";}}", "on");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:7:\"block-6\";}s:9:\"sidebar-1\";a:7:{i:0;s:7:\"block-2\";i:1;s:7:\"block-9\";i:2;s:8:\"block-10\";i:3;s:10:\"nav_menu-2\";i:4;s:7:\"block-3\";i:5;s:7:\"block-4\";i:6;s:7:\"block-8\";}s:9:\"sidebar-2\";a:0:{}s:13:\"array_version\";i:3;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:2:{i:2;a:1:{s:8:\"nav_menu\";i:6;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("127", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1750694899;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("128", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"4201c1f295ae7a854db2c52a831b8b83\";s:6:\"blocks\";a:12:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:18:\"core/term-template\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";s:32:\"b2510db5878d38fe57fddcc8c73332e3\";s:0:\"\";s:32:\"b5f94008df88debcf0fa76403e3a2805\";s:0:\"\";s:32:\"0f8d022836e94e793dccfd1473d9ab8a\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:32:\"28b31ffcc89e94bd6ba680807fe07473\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";s:32:\"3d591d80dd0a7b9b882542d5224bebc9\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:32:\"2df83a22a7159b7989598f570f30c532\";s:120:\":where(.wp-block-term-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-term-template.is-layout-grid){gap: 1.25em;}\";}}", "on");
INSERT INTO `wp_options` VALUES("155", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("166", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("167", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("176", "gutenberg_version_migration", "9.8.0", "auto");
INSERT INTO `wp_options` VALUES("183", "current_theme", "Twenty Thirteen", "auto");
INSERT INTO `wp_options` VALUES("184", "theme_mods_twentythirteen", "a:6:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:8;}s:18:\"custom_css_post_id\";i:88;s:12:\"header_image\";s:76:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:16;s:3:\"url\";s:76:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\";s:13:\"thumbnail_url\";s:76:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\";s:6:\"height\";i:230;s:5:\"width\";i:1600;}s:16:\"header_textcolor\";s:6:\"ededda\";}", "on");
INSERT INTO `wp_options` VALUES("185", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("208", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:1:{i:0;i:6;}}", "auto");
INSERT INTO `wp_options` VALUES("233", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":3,\"critical\":0}", "on");
INSERT INTO `wp_options` VALUES("253", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("327", "category_children", "a:6:{i:10;a:3:{i:0;i:11;i:1;i:12;i:2;i:13;}i:14;a:1:{i:0;i:15;}i:16;a:3:{i:0;i:17;i:1;i:18;i:2;i:19;}i:20;a:3:{i:0;i:21;i:1;i:22;i:2;i:23;}i:24;a:4:{i:0;i:26;i:1;i:27;i:2;i:28;i:3;i:29;}i:30;a:2:{i:0;i:31;i:1;i:32;}}", "auto");
INSERT INTO `wp_options` VALUES("357", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("368", "_transient_timeout_dirsize_cache", "2068634076", "off");
INSERT INTO `wp_options` VALUES("369", "_transient_dirsize_cache", "a:516:{s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/blue\";i:82449;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/coffee\";i:80361;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/ectoplasm\";i:83892;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/light\";i:83275;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/midnight\";i:84671;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/modern\";i:83520;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/ocean\";i:79467;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors/sunrise\";i:86121;s:71:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css/colors\";i:689979;s:64:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/css\";i:2623520;s:67:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/images\";i:427294;s:69:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/includes\";i:3089012;s:71:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/js/widgets\";i:139432;s:63:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/js\";i:1996678;s:66:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/maint\";i:7611;s:68:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/network\";i:126233;s:65:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin/user\";i:3758;s:60:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-admin\";i:9217669;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/languages/plugins\";i:517383;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/languages/themes\";i:38892;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/languages\";i:4755587;s:70:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/upgrade\";i:0;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/upgrade-temp-backup/plugins\";i:0;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/upgrade-temp-backup\";i:0;s:62:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content\";i:4755615;s:70:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/assets\";i:28376;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/block-bindings\";i:3610;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/block-patterns\";i:8951;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/block-supports\";i:132630;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/archives\";i:2233;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/audio\";i:3675;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/avatar\";i:2296;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/block\";i:587;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/button\";i:14327;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/buttons\";i:11544;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/calendar\";i:3804;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/categories\";i:4020;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/code\";i:2828;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/column\";i:1636;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/columns\";i:9193;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comment-author-name\";i:1677;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comment-content\";i:1838;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comment-date\";i:1562;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comment-edit-link\";i:1654;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comment-reply-link\";i:1447;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comment-template\";i:3037;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comments\";i:29695;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comments-pagination\";i:8917;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comments-pagination-next\";i:1011;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comments-pagination-numbers\";i:1833;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comments-pagination-previous\";i:1023;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/comments-title\";i:1745;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/cover\";i:87729;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/details\";i:2260;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/embed\";i:11420;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/file\";i:11820;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/footnotes\";i:2642;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/freeform\";i:41624;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/gallery\";i:78452;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/group\";i:8051;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/heading\";i:5866;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/home-link\";i:1130;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/html\";i:3770;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/image\";i:66363;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/latest-comments\";i:6816;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/latest-posts\";i:11447;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/legacy-widget\";i:556;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/list\";i:2338;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/list-item\";i:1471;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/loginout\";i:1474;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/media-text\";i:16904;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/missing\";i:617;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/more\";i:3770;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/navigation\";i:131175;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/navigation-link\";i:10406;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/navigation-submenu\";i:6204;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/nextpage\";i:3039;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/page-list\";i:8293;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/page-list-item\";i:1109;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/paragraph\";i:7421;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/pattern\";i:411;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-author\";i:3959;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-author-biography\";i:1507;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-author-name\";i:1673;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-comments-form\";i:10059;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-content\";i:1778;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-date\";i:1665;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-excerpt\";i:3285;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-featured-image\";i:29843;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-navigation-link\";i:4010;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-template\";i:7967;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-terms\";i:1981;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/post-title\";i:2849;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/preformatted\";i:1907;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/pullquote\";i:8859;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query\";i:12952;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-no-results\";i:901;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-pagination\";i:5775;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-pagination-next\";i:1039;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-pagination-numbers\";i:1942;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-pagination-previous\";i:1051;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-title\";i:1721;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/query-total\";i:1520;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/quote\";i:7166;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/read-more\";i:2428;s:74:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/rss\";i:4900;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/search\";i:19632;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/separator\";i:5126;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/shortcode\";i:2918;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/site-logo\";i:15709;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/site-tagline\";i:2149;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/site-title\";i:3051;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/social-link\";i:3510;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/social-links\";i:60255;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/spacer\";i:4737;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/table\";i:27384;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/tag-cloud\";i:4274;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/template-part\";i:6686;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/term-description\";i:2070;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/text-columns\";i:3054;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/verse\";i:2144;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/video\";i:8844;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks/widget-group\";i:400;s:70:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/blocks\";i:1535843;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/certificates\";i:226307;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/block-directory\";i:15464;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/block-editor\";i:620037;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/block-library\";i:804012;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/commands\";i:13442;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/components\";i:366079;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/customize-widgets\";i:25296;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/edit-post\";i:61540;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/edit-site\";i:590018;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/edit-widgets\";i:90952;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/editor\";i:243084;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/format-library\";i:5024;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/list-reusable-blocks\";i:17852;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/nux\";i:11874;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/patterns\";i:7442;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/preferences\";i:6314;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/reusable-blocks\";i:2290;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist/widgets\";i:23740;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css/dist\";i:2904460;s:67:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/css\";i:3551277;s:73:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/customize\";i:178173;s:69:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/fonts\";i:327011;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/html-api\";i:536362;s:67:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/ID3\";i:1160011;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/images/crystal\";i:15541;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/images/media\";i:5263;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/images/smilies\";i:10082;s:70:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/images\";i:102178;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/interactivity-api\";i:57534;s:67:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/IXR\";i:33910;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/codemirror\";i:1287141;s:71:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/crop\";i:20004;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/development\";i:179848;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/a11y\";i:5613;s:105:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library/file\";i:3826;s:105:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library/form\";i:2559;s:106:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library/image\";i:22849;s:111:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library/navigation\";i:11881;s:106:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library/query\";i:6276;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library/search\";i:5460;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/block-library\";i:52851;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/interactivity\";i:312802;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules/interactivity-router\";i:21116;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/script-modules\";i:392382;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist/vendor\";i:2701413;s:71:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/dist\";i:22295514;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/imgareaselect\";i:49553;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/jcrop\";i:24976;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/jquery/ui\";i:787634;s:73:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/jquery\";i:1304968;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/mediaelement/renderers\";i:18880;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/mediaelement\";i:721307;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/plupload\";i:490754;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/swfupload\";i:8715;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/thickbox\";i:31323;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/langs\";i:15529;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/charmap\";i:31811;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/colorpicker\";i:4910;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/compat3x/css\";i:8179;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/compat3x\";i:21758;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/directionality\";i:2749;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/fullscreen\";i:7779;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/hr\";i:1347;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/image\";i:55874;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/link\";i:32949;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/lists\";i:97383;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/media\";i:57914;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/paste\";i:113193;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/tabfocus\";i:5336;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/textcolor\";i:16237;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wordpress\";i:50553;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wpautoresize\";i:8332;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wpdialogs\";i:3761;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wpeditimage\";i:37709;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wpemoji\";i:5099;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wpgallery\";i:4806;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wplink\";i:26786;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wptextpattern\";i:11923;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins/wpview\";i:8985;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/plugins\";i:607194;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/skins/lightgray/fonts\";i:155760;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/skins/lightgray/img\";i:2856;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/skins/lightgray\";i:210254;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/skins/wordpress/images\";i:16653;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/skins/wordpress\";i:25413;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/skins\";i:235667;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/themes/inlite\";i:452642;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/themes/modern\";i:446221;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/themes\";i:898863;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce/utils\";i:18826;s:74:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js/tinymce\";i:2856553;s:66:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/js\";i:31513410;s:68:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/l10n\";i:31237;s:74:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/php-compat\";i:1253;s:73:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/PHPMailer\";i:233633;s:68:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/pomo\";i:57146;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/library\";i:261;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Auth\";i:2541;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Cookie\";i:4363;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Exception/Http\";i:16715;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Exception/Transport\";i:1397;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Exception\";i:22464;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Proxy\";i:4217;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Response\";i:3101;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Transport\";i:35470;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src/Utility\";i:7176;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests/src\";i:214849;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Requests\";i:215110;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/rest-api/endpoints\";i:870211;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/rest-api/fields\";i:22750;s:79:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/rest-api/search\";i:16916;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/rest-api\";i:1001440;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Cache\";i:15217;s:104:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Content/Type\";i:2482;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Content\";i:2482;s:103:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Decode/HTML\";i:23828;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Decode\";i:23828;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/HTTP\";i:2427;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Net\";i:2407;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/Parse\";i:2419;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/XML/Declaration\";i:2493;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie/XML\";i:2493;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library/SimplePie\";i:101578;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/library\";i:118803;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Cache\";i:68936;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Content/Type\";i:9290;s:85:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Content\";i:9290;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Decode/HTML\";i:17241;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Decode\";i:17241;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/HTTP\";i:14907;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Net\";i:8737;s:83:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/Parse\";i:26853;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/XML/Declaration\";i:9451;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src/XML\";i:9451;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie/src\";i:716234;s:73:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/SimplePie\";i:839047;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sitemaps/providers\";i:17599;s:72:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sitemaps\";i:47547;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/lib\";i:99005;s:102:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/namespaced/Core/ChaCha20\";i:224;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge\";i:602;s:104:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/namespaced/Core/Curve25519\";i:820;s:102:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/namespaced/Core/Poly1305\";i:112;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/namespaced/Core\";i:2444;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/namespaced\";i:2698;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/AEGIS\";i:14759;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/AES\";i:12651;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/Base64\";i:15456;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/ChaCha20\";i:5264;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/Curve25519/Ge\";i:10572;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/Curve25519\";i:124336;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/Poly1305\";i:12912;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core/SecretStream\";i:3624;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core\";i:499975;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core32/ChaCha20\";i:6407;s:102:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core32/Curve25519/Ge\";i:8177;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core32/Curve25519\";i:122690;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core32/Poly1305\";i:15965;s:101:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core32/SecretStream\";i:3656;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/Core32\";i:437041;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src/PHP52\";i:4116;s:81:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat/src\";i:1268866;s:77:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/sodium_compat\";i:1377044;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/style-engine\";i:48119;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Text/Diff/Engine\";i:31802;s:82:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Text/Diff/Renderer\";i:5528;s:73:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Text/Diff\";i:44136;s:68:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/Text\";i:57248;s:76:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/theme-compat\";i:15656;s:71:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes/widgets\";i:158198;s:63:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-includes\";i:50939930;s:51:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public\";i:65103408;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/css\";i:47359;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/fonts/bitter\";i:256148;s:106:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/fonts/source-sans-pro\";i:635667;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/fonts\";i:936732;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/genericons/font\";i:99552;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/genericons\";i:174221;s:106:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/images/block-patterns\";i:479877;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/images/headers\";i:84621;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/images\";i:566080;s:88:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/inc\";i:21908;s:87:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen/js\";i:7846;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes/twentythirteen\";i:2078107;s:69:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/themes\";i:2078135;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/a11y\";i:21641;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/annotations\";i:60009;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/api-fetch\";i:64117;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/autop\";i:43797;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/blob\";i:11430;s:102:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-directory\";i:211843;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-editor\";i:7949995;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/archives\";i:1808;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/audio\";i:2419;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/avatar\";i:1783;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/block\";i:587;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/button\";i:8503;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/buttons\";i:6392;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/calendar\";i:2367;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/categories\";i:2928;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/code\";i:2070;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/column\";i:1636;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/columns\";i:5387;s:129:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-author-avatar\";i:1219;s:127:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-author-name\";i:1563;s:123:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-content\";i:1554;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-date\";i:1462;s:125:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-edit-link\";i:1544;s:126:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-reply-link\";i:1335;s:124:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comment-template\";i:2048;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comments\";i:15057;s:127:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comments-pagination\";i:3791;s:132:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comments-pagination-next\";i:1011;s:135:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comments-pagination-numbers\";i:1374;s:136:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comments-pagination-previous\";i:1023;s:122:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/comments-title\";i:1623;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/cover\";i:44656;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/details\";i:1996;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/embed\";i:5994;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/file\";i:4690;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/footnotes\";i:1987;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/form\";i:1348;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/form-input\";i:5130;s:136:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/form-submission-notification\";i:2230;s:126:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/form-submit-button\";i:558;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/freeform\";i:20219;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/gallery\";i:39300;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/group\";i:4979;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/heading\";i:3814;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/home-link\";i:1130;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/html\";i:2107;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/image\";i:21612;s:123:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/latest-comments\";i:3989;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/latest-posts\";i:6725;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/list\";i:2071;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/list-item\";i:1471;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/loginout\";i:1382;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/media-text\";i:9410;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/missing\";i:617;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/more\";i:2120;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/navigation\";i:59476;s:123:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/navigation-link\";i:5853;s:126:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/navigation-submenu\";i:3799;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/nextpage\";i:1693;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/page-list\";i:4901;s:122:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/page-list-item\";i:1109;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/paragraph\";i:4431;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/pattern\";i:411;s:119:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-author\";i:2561;s:129:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-author-biography\";i:1389;s:124:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-author-name\";i:1565;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-comment\";i:699;s:127:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-comments-count\";i:1217;s:126:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-comments-form\";i:5546;s:126:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-comments-link\";i:1372;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-content\";i:1686;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-date\";i:1571;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-excerpt\";i:2383;s:127:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-featured-image\";i:15781;s:128:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-navigation-link\";i:2650;s:121:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-template\";i:4613;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-terms\";i:1769;s:125:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-time-to-read\";i:1307;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/post-title\";i:2257;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/preformatted\";i:1607;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/pullquote\";i:5169;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query\";i:3776;s:124:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-no-results\";i:901;s:124:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-pagination\";i:3611;s:129:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-pagination-next\";i:1039;s:132:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-pagination-numbers\";i:1501;s:133:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-pagination-previous\";i:1051;s:119:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-title\";i:1623;s:119:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/query-total\";i:1422;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/quote\";i:4582;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/read-more\";i:1848;s:111:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/rss\";i:3085;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/search\";i:7751;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/separator\";i:3024;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/shortcode\";i:1640;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/site-logo\";i:8328;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/site-tagline\";i:1897;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/site-title\";i:2375;s:119:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/social-link\";i:2076;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/social-links\";i:27604;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/spacer\";i:2629;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/table\";i:15672;s:125:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/table-of-contents\";i:1617;s:117:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/tag-cloud\";i:2639;s:121:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/template-part\";i:3602;s:124:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/term-description\";i:1636;s:120:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/text-columns\";i:1870;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/verse\";i:1912;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks/video\";i:5224;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library/blocks\";i:921792;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-library\";i:7331525;s:121:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-serialization-default-parser\";i:37222;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/block-serialization-spec-parser\";i:130478;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/blocks\";i:1495776;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/commands\";i:501094;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/components\";i:7742921;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/compose\";i:504434;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/core-commands\";i:67149;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/core-data\";i:2339354;s:104:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/customize-widgets\";i:284253;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/data\";i:375382;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/data-controls\";i:17086;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/date\";i:275643;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/deprecated\";i:9035;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/dom\";i:158580;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/dom-ready\";i:5626;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/edit-post\";i:360653;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/edit-site\";i:5378260;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/edit-widgets/blocks/widget-area\";i:534;s:106:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/edit-widgets/blocks\";i:534;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/edit-widgets\";i:520460;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/editor\";i:3500587;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/element\";i:160457;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/escape-html\";i:13685;s:101:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/format-library\";i:187244;s:92:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/hooks\";i:51097;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/html-entities\";i:8908;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/i18n\";i:97756;s:103:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/is-shallow-equal\";i:10619;s:105:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/keyboard-shortcuts\";i:55554;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/keycodes\";i:34938;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/list-reusable-blocks\";i:82669;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/media-utils\";i:90882;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/notices\";i:48205;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/nux\";i:38686;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/patterns\";i:179634;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/plugins\";i:47330;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/preferences\";i:67707;s:110:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/preferences-persistence\";i:75253;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/primitives\";i:15850;s:101:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/priority-queue\";i:36426;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/private-apis\";i:20842;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/react-i18n\";i:13909;s:106:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/react-refresh-entry\";i:65951;s:108:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/react-refresh-runtime\";i:24241;s:100:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/redux-routine\";i:70154;s:102:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/reusable-blocks\";i:54447;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/rich-text\";i:321860;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/router\";i:122607;s:105:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/server-side-render\";i:39849;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/shortcode\";i:37141;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/style-engine\";i:151767;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/token-list\";i:15665;s:90:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/url\";i:91911;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/vendors\";i:489200;s:95:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/viewport\";i:24776;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/vips\";i:13277245;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/warning\";i:5387;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/widgets/blocks/legacy-widget\";i:556;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/widgets/blocks/widget-group\";i:400;s:101:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/widgets/blocks\";i:7573;s:94:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/widgets\";i:165643;s:96:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build/wordcount\";i:35658;s:86:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build\";i:55729503;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/a11y\";i:11474;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library/file\";i:8102;s:112:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library/form\";i:5812;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library/image\";i:48671;s:118:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library/navigation\";i:24894;s:113:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library/query\";i:12732;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library/search\";i:11199;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/block-library\";i:111410;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/interactivity\";i:907963;s:114:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module/interactivity-router\";i:186298;s:93:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/build-module\";i:1218961;s:99:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/block-supports\";i:138182;s:98:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/compat/plugin\";i:2931;s:105:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/compat/wordpress-6.8\";i:31763;s:105:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/compat/wordpress-6.9\";i:5718;s:91:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/compat\";i:40412;s:104:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/assets\";i:307;s:116:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/font-face/bc-layer\";i:32694;s:107:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/font-face\";i:32694;s:115:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/interactivity-api\";i:2121;s:103:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/media\";i:23176;s:103:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/posts\";i:2830;s:102:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental/sync\";i:21323;s:97:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib/experimental\";i:151665;s:84:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/lib\";i:709973;s:124:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/packages/block-serialization-default-parser\";i:16347;s:89:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg/packages\";i:16347;s:80:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins/gutenberg\";i:61491338;s:70:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/plugins\";i:61491366;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/uploads/2025/06\";i:3607804;s:78:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/uploads/2025/07\";i:0;s:75:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/uploads/2025\";i:3607804;s:70:\"C:\\Users\\Aline\\Local Sites\\court-circuit\\app\\public/wp-content/uploads\";i:3607804;}", "off");
INSERT INTO `wp_options` VALUES("490", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"dev-email@wpengine.local\";s:7:\"version\";s:3:\"6.9\";s:9:\"timestamp\";i:1765189329;}", "off");
INSERT INTO `wp_options` VALUES("495", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1765232313", "off");
INSERT INTO `wp_options` VALUES("496", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("570", "active_templates", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("605", "auto_update_plugins", "a:1:{i:0;s:23:\"gutenberg/gutenberg.php\";}", "off");
INSERT INTO `wp_options` VALUES("651", "_site_transient_timeout_g_url_details_response_475049870b08d570ed4f14eed2dcafd1", "1762792588", "off");
INSERT INTO `wp_options` VALUES("716", "riverbank_install", "1762962147", "auto");
INSERT INTO `wp_options` VALUES("727", "theme_mods_riverbank", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "auto");
INSERT INTO `wp_options` VALUES("735", "theme_mods_creative-blog-writer", "a:35:{s:18:\"custom_css_post_id\";i:-1;s:12:\"header_image\";s:74:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:114;s:3:\"url\";s:74:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\";s:13:\"thumbnail_url\";s:74:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\";s:6:\"height\";i:236;s:5:\"width\";i:1045;}s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:8;}s:31:\"creative_blog_writer_logo_width\";i:5;s:39:\"creative_blog_writer_site_title_setting\";b:0;s:36:\"creative_blog_writer_tagline_setting\";b:1;s:11:\"custom_logo\";s:0:\"\";s:27:\"creative_blog_writer_slider\";b:1;s:44:\"creative_blog_writer_slider_section_category\";s:6:\"select\";s:34:\"creative_blog_writer_reviewer_name\";s:0:\"\";s:51:\"creative_blog_writer_our_products_show_hide_section\";b:0;s:44:\"creative_blog_writer_archive_sidebar_setting\";b:1;s:42:\"creative_blog_writer_index_sidebar_setting\";b:1;s:42:\"creative_blog_writer_paged_sidebar_setting\";b:0;s:50:\"creative_blog_writer_search_result_sidebar_setting\";b:0;s:48:\"creative_blog_writer_single_post_sidebar_setting\";b:0;s:48:\"creative_blog_writer_single_page_sidebar_setting\";b:0;s:37:\"creative_blog_writer_sidebar_position\";s:4:\"left\";s:34:\"creative_blog_writer_hs_breadcrumb\";b:1;s:39:\"creative_blog_writer_preloader_bg_color\";s:7:\"#bf6f74\";s:30:\"creative_blog_writer_body_text\";s:0:\"\";s:16:\"background_image\";s:0:\"\";s:42:\"creative_blog_writer_post_heading_settings\";b:1;s:42:\"creative_blog_writer_post_content_settings\";b:1;s:49:\"creative_blog_writer_post_featured_image_settings\";b:1;s:39:\"creative_blog_writer_post_date_settings\";b:1;s:43:\"creative_blog_writer_post_comments_settings\";b:0;s:41:\"creative_blog_writer_post_author_settings\";b:0;s:41:\"creative_blog_writer_post_timing_settings\";b:0;s:56:\"creative_blog_writer_single_post_featured_image_settings\";b:1;s:33:\"creative_blog_writer_customer_img\";s:94:\"http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose-e1762962632778.jpg\";s:34:\"creative_blog_writer_sticky_header\";b:0;s:16:\"background_color\";s:6:\"f7ebd6\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1763374392;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:7:\"block-6\";}s:9:\"sidebar-1\";a:7:{i:0;s:7:\"block-2\";i:1;s:7:\"block-9\";i:2;s:8:\"block-10\";i:3;s:10:\"nav_menu-2\";i:4;s:7:\"block-3\";i:5;s:7:\"block-4\";i:6;s:7:\"block-8\";}s:9:\"sidebar-2\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("751", "theme_switch_menu_locations", "a:1:{s:7:\"primary\";i:8;}", "on");
INSERT INTO `wp_options` VALUES("752", "theme_switched_via_customizer", "", "auto");
INSERT INTO `wp_options` VALUES("753", "customize_stashed_theme_mods", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("759", "creative_blog_writer_notice_dismissed", "1", "auto");
INSERT INTO `wp_options` VALUES("812", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1765232314", "off");
INSERT INTO `wp_options` VALUES("813", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1765189114", "off");
INSERT INTO `wp_options` VALUES("816", "_transient_timeout_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1765232315", "off");
INSERT INTO `wp_options` VALUES("817", "_transient_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1765189115", "off");
INSERT INTO `wp_options` VALUES("836", "_transient_is_multi_author", "0", "on");
INSERT INTO `wp_options` VALUES("843", "_site_transient_timeout_available_translations", "1765199898", "off");
INSERT INTO `wp_options` VALUES("844", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-01 16:41:58\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-03 08:22:12\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 20:45:59\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-24 16:59:37\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 22:31:45\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 12:02:03\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-28 08:16:02\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-28 08:18:46\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-03 18:37:16\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-03 18:36:56\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-04 22:35:01\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 14:37:33\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 23:02:24\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 00:57:20\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-16 01:23:24\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-02 18:51:27\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 13:01:35\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 01:52:15\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-14 01:36:14\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 18:29:35\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-16 22:30:28\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 19:36:59\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-25 05:20:17\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-14 09:25:54\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 09:34:11\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-29 04:27:18\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-16 11:08:38\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-18 06:36:37\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 03:46:40\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-21 12:08:40\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 12:44:54\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 09:28:17\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-29 19:46:21\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-03 12:27:28\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-10 20:09:25\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-15 12:39:47\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 19:01:02\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-26 17:30:52\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 20:17:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-07 08:26:32\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 09:30:06\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-28 09:41:10\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 09:58:40\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-19 09:37:43\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:01:51\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-01 23:51:55\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-03 18:01:39\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-06 20:49:19\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 11:14:51\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-12 13:17:51\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-29 11:19:02\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-21 20:51:39\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-23 11:49:16\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-27 15:18:37\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-08 12:32:25\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 17:38:55\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-19 07:21:47\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-03 17:40:55\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-11-13 16:26:14\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-12-02 01:03:18\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp_options` VALUES("845", "_site_transient_timeout_theme_roots", "1765190905", "off");
INSERT INTO `wp_options` VALUES("846", "_site_transient_theme_roots", "a:3:{s:20:\"creative-blog-writer\";s:7:\"/themes\";s:9:\"riverbank\";s:7:\"/themes\";s:14:\"twentythirteen\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("847", "_site_transient_timeout_browser_1a33f877cff2dd924c68e7262ad03d3f", "1765793907", "off");
INSERT INTO `wp_options` VALUES("848", "_site_transient_browser_1a33f877cff2dd924c68e7262ad03d3f", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"145.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("849", "_site_transient_timeout_php_check_617fc4d260191bf0de418d0d961f5a43", "1765793908", "off");
INSERT INTO `wp_options` VALUES("850", "_site_transient_php_check_617fc4d260191bf0de418d0d961f5a43", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("851", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1765232314", "off");
INSERT INTO `wp_options` VALUES("852", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 21:58:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61359\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.9 « Gene »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://fr.wordpress.org/2025/12/02/wordpress-6-9-gene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 20:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3411\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:350:\"Chaque version de WordPress rend hommage à un artiste ayant laissé une marque indélébile dans le monde la musique. Le nom de code de WordPress 6.9 est «&#160;Gene&#160;», en l&#8217;honneur du jazzman américain Gene Harris. Ce pianiste autodidacte dès l&#8217;âge de 6 ans a infusé le jazz populaire de soul de blues et de gospel, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:77715:\"\n<figure class=\"wp-block-image size-full\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1.png\" alt=\"\" class=\"wp-image-3413\" srcset=\"https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1.png 1024w, https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1-300x157.png 300w, https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1-768x401.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Chaque version de WordPress rend hommage à un artiste ayant laissé une marque indélébile dans le monde la musique. Le nom de code de WordPress 6.9 est «&nbsp;Gene&nbsp;», en l&rsquo;honneur du jazzman américain Gene Harris.</p>\n\n\n\n<p>Ce pianiste autodidacte dès l&rsquo;âge de 6 ans a infusé le jazz populaire de soul de blues et de gospel, apportant une chaleur et une signature iconique. L&rsquo;approche «&nbsp;<bdo lang=\"en\" dir=\"ltr\">bluesy</bdo>&nbsp;» du jazz de Gene Harris vivait à l&rsquo;intersection de deux mondes musicaux, apportant un paysage riche de textures et un supplément d&rsquo;âme qui restera à jamais.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.9</h2>\n\n\n\n<p>WordPress 6.9 apporte des changements majeurs concernant le travail collaboratif sur vos contenus éditoriaux.</p>\n\n\n\n<p>La nouvelle fonctionnalité «&nbsp;Notes&nbsp;» permet d&rsquo;ajouter des commentaires au niveau des blocs lors de la rédaction de publications, simplifiant ainsi la relecture et la validation du contenu.</p>\n\n\n\n<p>La palette de commandes étendue offre une navigation plus rapide dans votre administration.</p>\n\n\n\n<p>La nouvelle API «&nbsp;<bdo lang=\"en\" dir=\"ltr\">Abilities</bdo>&nbsp;» fournit un système de déclaration de fonctionnalités standardisé et lisible par machine, ouvrant la voie à des flux de travail automatisés et basés sur les nouvelles générations d&rsquo;outils IA.</p>\n\n\n\n<p>Cette version améliore également les performances de vos sites, notamment la vitesse de chargement des pages, et ajoute de nombreux nouveaux blocs éditoriaux, ainsi qu&rsquo;une interface de glisser-déposer plus intuitive, pour vous aider à concevoir du contenu riche et dynamique plus efficacement.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Télécharger WordPress 6.9 «&nbsp;Gene&nbsp;»</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les Notes, un nouveau système collaboratif</h2>\n\n\n\n<p><strong>Faites vos retours directement là où vous travaillez.</strong><br>Avec les notes liées directement aux blocs, votre équipe peut rester en phase, suivre les modifications, et transformer les retours en actions, tout au même endroit. Que vous travailliez sur l’écriture des textes ou sur l’affinage de la mise en page, la collaboration se fait avec fluidité directement dans le canevas de l’éditeur.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-notes.png\" alt=\"\" class=\"wp-image-19410\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Une palette de commandes disponible partout</h2>\n\n\n\n<p><strong>Vos outils sont toujours à portée de main.</strong><br>Accédez à la Palette de commandes depuis n’importe quelle partie de votre site, que vous soyez en train de rédiger votre dernier article, de travailler en profondeur sur le design du site dans l’Éditeur de site, ou de parcourir vos extensions. Tout ce dont vous avez besoin est maintenant à portée de clic.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-command-palette-everywhere.png\" alt=\"\" class=\"wp-image-19412\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Adapter le texte à son conteneur</h2>\n\n\n\n<p><strong>Un contenu qui s’adapte.</strong><br>Une nouvelle option de typographie pour les blocs de texte, à commencer par les blocs Paragraphe et Titre, qui ajuste automatiquement la taille de la police pour remplir parfaitement son conteneur. Idéal pour les bannières, les encadrés ou les éléments qui doivent se démarquer dans votre design. Aucun réglage manuel n’est nécessaire, vous obtenez instantanément un rendu propre.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-fit-text.png\" alt=\"\" class=\"wp-image-19413\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Une nouvelle API «&nbsp;Abilities&nbsp;»</h2>\n\n\n\n<p><strong>Un gestionnaire de fonctionnalités au cœur de WordPress</strong>.</p>\n\n\n\n<p>WordPress 6.9 pose les bases de l&rsquo;automatisation de demain grâce à l&rsquo;API «&nbsp;Abilities&nbsp;» unifiée. En créant un registre standardisé des fonctionnalités des sites, les développeurs peuvent désormais enregistrer, valider et exécuter des actions de manière cohérente dans tous les contextes (des points de terminaison PHP et REST aux agents IA), ouvrant ainsi la voie à des expériences WordPress plus intelligentes et connectées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Amélioration de l’accessibilité</h2>\n\n\n\n<p>Plus de 30 corrections et améliorations en matière d’accessibilité, centrées sur les principales zones de l’expérience d’administration de WordPress. Cela va de la suppression complète du contenu généré par le CSS pour les technologies d’assistance, à l’amélioration des annonces des lecteurs d’écran, en passant par la correction de la position du curseur et le maintien du focus de saisie lors du clic sur les éléments de suggestion automatique.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Amélioration des performances</h2>\n\n\n\n<p>WordPress 6.9 comprend un vaste ensemble d’améliorations de performances. De meilleurs résultats sur la métrique&nbsp;LCP&nbsp;(<bdo lang=\"en\" dir=\"ltr\">Largest Contentful Paint</bdo>) sont obtenus grâce à un chargement amélioré des feuilles de style conditionnelles et en ligne, et grâce au chargement des scripts avec prise en charge de l’attribut <code>fetchpriority</code> et à des optimisations du cœur complémentaires. Les avancées de l’éditeur comprennent des correctifs pour les modifications de mise en page causés par le bloc Vidéo et un chargement plus rapide du sélecteur de termes.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une liste complète des nouvelles fonctionnalités, lisez <a href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\" data-type=\"post\" data-id=\"3383\">notre guide technique à destination des développeurs et des développeuses (en français)</a>, ou consultez le <a href=\"https://wordpress.org/download/releases/6-9\">site dédié à WordPress 6.9 (en anglais)</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.9</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\"></a><a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\"></a><a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\"></a><a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>La mission de WordPress est de <a href=\"https://fr.wordpress.org/about/\">démocratiser la publication de contenu</a> et ce projet <a href=\"https://opensource.org/osd-annotated\">embrasse les libertés fondamentales de l&rsquo;open-source (en anglais)</a>. Une communauté mondiale et diversifiée supporte cet effort.</p>\n\n\n\n<p>WordPress 6.9 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 67 pays différents</strong>.</p>\n\n\n\n<p>Ce travail collaboratif a abouti à plus de 340 améliorations et correctifs, ce qui donne une nouvelle version majeure stable et efficace – un vrai témoignage de la vivacité de l&rsquo;écosystème open-source de notre CMS.</p>\n\n\n\n<div class=\"wp-block-group alignwide is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-extra-small-font-size\"><a href=\"https://profiles.wordpress.org/o-o/\">2046</a> · <a href=\"https://profiles.wordpress.org/aakashverma1/\">Aakash Verma</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aarti1318/\">Aarti Chauhan</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/aatospaja/\">aatospaja</a> · <a href=\"https://profiles.wordpress.org/abduremon/\">Abdur Rahman Emon</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/b1ink0/\">Aditya Dhade</a> · <a href=\"https://profiles.wordpress.org/adityashah2411/\">aditya shah</a> · <a href=\"https://profiles.wordpress.org/iamadisingh/\">Aditya Singh</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/agulbra/\">agulbra</a> · <a href=\"https://profiles.wordpress.org/elazzabi/\">Ahmed</a> · <a href=\"https://profiles.wordpress.org/ajaxstardust/\">ajaxStardust</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/akeda/\">Akeda Bagus</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alejandrogonzalvo/\">alejandrogonzalvo</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexclassroom/\">Alex Lion (阿力獅)</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexius08/\">Alexis Pandaan</a> · <a href=\"https://profiles.wordpress.org/alordiel/\">alordiel</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/theaminuldev/\">Aminul Islam</a> · <a href=\"https://profiles.wordpress.org/aialvi/\">Aminul Islam Alvi</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anatolbroder/\">Anatol Broder</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhoyer/\">Andrew Hoyer</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/mymothersdaughter/\">Anita C</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/fliespl/\">Arkadiusz Rzadkowolski</a> · <a href=\"https://profiles.wordpress.org/armandovias/\">Armando</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/asdofindia/\">asdofindia</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/akashdev/\">Ashraful Haque Akash</a> · <a href=\"https://profiles.wordpress.org/askapache/\">askapache</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/aut0poietic/\">aut0poietic</a> · <a href=\"https://profiles.wordpress.org/aksl95/\">Axel DUCORON</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bartnv/\">bartnv</a> · <a href=\"https://profiles.wordpress.org/bchecketts/\">bchecketts</a> · <a href=\"https://profiles.wordpress.org/beee/\">Beee</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/bvl/\">Benny</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/bhattaganesh/\">bhattaganesh</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bidbmak/\">BiDbMAK</a> · <a href=\"https://profiles.wordpress.org/mbigul/\">Bigul Malayi</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/burlesonbrad/\">Brad Griffin</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradshawtm/\">bradshawtm</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/heybran/\">Brandon Zhang</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/brhodes/\">brhodes</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brumack/\">brumack</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/bshuchter/\">bshuchter</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/byteninjaa0/\">byteninjaa0</a> · <a href=\"https://profiles.wordpress.org/cedche99/\">Cédric Chevillard</a> · <a href=\"https://profiles.wordpress.org/callumbw95/\">Callum Bridgford-Whittick</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/carlsteffen/\">CarlSteffen</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/corazondejaguar/\">Carolina Romo</a> · <a href=\"https://profiles.wordpress.org/ciobanucatalin/\">Catalin Ciobanu</a> · <a href=\"https://profiles.wordpress.org/catgofire/\">catgofire</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/ccharel/\">ccharel</a> · <a href=\"https://profiles.wordpress.org/cbutlerjr/\">Chad Butler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/cherrygot/\">Chakrapani Gautam</a> · <a href=\"https://profiles.wordpress.org/chihsuan/\">Chi-Hsuan Huang</a> · <a href=\"https://profiles.wordpress.org/chillifish/\">Chillifish</a> · <a href=\"https://profiles.wordpress.org/chloed/\">ChloeD</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/chrismattix/\">chrismattix</a> · <a href=\"https://profiles.wordpress.org/christinecooper/\">christinecooper</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/cikrimcin/\">cikrimcin</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian Popescu</a> · <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom/\">cjhaas</a> · <a href=\"https://profiles.wordpress.org/ckoerner/\">ckoerner</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebuddy/\">codebuddy</a> · <a href=\"https://profiles.wordpress.org/coleatkinson1/\">coleatkinson1</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/ogrecooper/\">Cooper Dalrymple</a> · <a href=\"https://profiles.wordpress.org/coralietixeront/\">Coralie Tixeront</a> · <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cornwell/\">Cornwell</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cucocreative/\">cucocreative</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cyrille37/\">Cyrille37</a> · <a href=\"https://profiles.wordpress.org/daanvandenbergh/\">Daan van den Bergh</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/damchtlv/\">damchtlv</a> · <a href=\"https://profiles.wordpress.org/damir-webthemer/\">Damir</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dancameron/\">Dan Cameron</a> · <a href=\"https://profiles.wordpress.org/danielpw/\">Dan Waldschmidt</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/daniellacatus/\">daniellacatus</a> · <a href=\"https://profiles.wordpress.org/danielmorell/\">danielmorell</a> · <a href=\"https://profiles.wordpress.org/dscqbus/\">Danny Schmarsel</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">Dave Ryan</a> · <a href=\"https://profiles.wordpress.org/daveguitaruno/\">daveguitaruno</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/djivad/\">David Riviera</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidb/\">DavidB</a> · <a href=\"https://profiles.wordpress.org/dawidadach/\">dawidadach</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/derekherman/\">derekherman</a> · <a href=\"https://profiles.wordpress.org/devasheeshkaul/\">Devasheesh Kaul</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diebombe/\">diebombe</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divinenephron/\">divinenephron</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dominiquepijnenburg/\">dominiquepijnenburg</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/dougmelvin/\">DougMelvin</a> · <a href=\"https://profiles.wordpress.org/drawcard/\">drawcard</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dustintechsmith/\">dustintechsmith</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/ehti/\">Ehti</a> · <a href=\"https://profiles.wordpress.org/elialum/\">elialum</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Peña</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/elvismdev/\">Elvis Morales</a> · <a href=\"https://profiles.wordpress.org/emaildano/\">emaildano</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/emranahmed/\">Emran Ahmed</a> · <a href=\"https://profiles.wordpress.org/enaanfarhan/\">Enaan Farhan</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/epeicher/\">epeicher</a> · <a href=\"https://profiles.wordpress.org/ekazda/\">Eric</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/ejoling/\">Erik Joling</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/ethanscorey/\">ethanscorey</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fakhriaz/\">fakhriaz</a> · <a href=\"https://profiles.wordpress.org/falgunihdesai/\">Falguni Desai</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frogdesk/\">FrogDesk Strategy</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Fumiki Takahashi</a> · <a href=\"https://profiles.wordpress.org/gaeldenysiak/\">Gael Denysiak</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/guddu1315/\">Gaurang Dabhi</a> · <a href=\"https://profiles.wordpress.org/gautam23/\">Gautam Mehta</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/stoyanovgs/\">Georgi Stoyanov</a> · <a href=\"https://profiles.wordpress.org/gernberg/\">gernberg</a> · <a href=\"https://profiles.wordpress.org/giuliorubelli/\">giuliorubelli</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/adrock42/\">H. Adam Lenz</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/hanimbarek/\">hanimbarek</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/harshbhonsle08/\">harshbhonsle08</a> · <a href=\"https://profiles.wordpress.org/harshdeepgill/\">harshdeepgill</a> · <a href=\"https://profiles.wordpress.org/haruncpi/\">Harun</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">Hidenori ISHIKAWA</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hiroshisato/\">Hiroshi Sato</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/hozefasmile/\">Hozefa Saleh</a> · <a href=\"https://profiles.wordpress.org/hrohh/\">Hrohh</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/hugosolar/\">hugosolar</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a> · <a href=\"https://profiles.wordpress.org/ikriv/\">ikriv</a> · <a href=\"https://profiles.wordpress.org/imokweb/\">imokweb</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/iqbal1hossain/\">Iqbal Hossain</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishikaatxecurify/\">Ishika Bansal</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jabe/\">Jabe</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jaiminp/\">Jaimin Prajapati</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamestitus299/\">James Titus</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">Jamie Burchell</a> · <a href=\"https://profiles.wordpress.org/jamesmarsland/\">Jamie Marsland</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/jasalt/\">Jarkko Saltiola</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jonmcpartland/\">Jay McPartland</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremiahbratton/\">Jeremiah Bratton</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jkmassel/\">Jeremy Massel</a> · <a href=\"https://profiles.wordpress.org/slimndap/\">Jeroen Schmit</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jikamens/\">jikamens</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jojo256/\">Joan Namunina</a> · <a href=\"https://profiles.wordpress.org/jobata/\">JoAnne Obata</a> · <a href=\"https://profiles.wordpress.org/jochent/\">JochenT</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/brandbrilliance/\">John Brand</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/mindctrl/\">John Parris</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnvieth/\">JohnVieth</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jrmd/\">jrmd</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juampick/\">Juan Cook</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juliengardair/\">juliengardair</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/itsroy69/\">Jyotirmoy Roy</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/kakomap/\">Kakoma</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/karinchristen/\">Karin Christen</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/codebykat/\">Kat Hagan</a> · <a href=\"https://profiles.wordpress.org/katinthehatsite/\">Kateryna K. a11n</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/katrinadtl/\">Katrina Massey</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/khushdoms/\">Kaushik Domadiya</a> · <a href=\"https://profiles.wordpress.org/onlykawshar/\">Kawshar Ahmed</a> · <a href=\"https://profiles.wordpress.org/kaygee79/\">kaygee79</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">Kazuto Takeshita</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/kerfred/\">Kerfred</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kesselb/\">kesselb</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/kgagne/\">kgagne</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khushipatel15/\">Khushi Patel</a> · <a href=\"https://profiles.wordpress.org/killerbishop/\">killerbishop</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/kleor/\">Kleor</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kpapazov/\">kpapazov</a> · <a href=\"https://profiles.wordpress.org/kprocyszyn/\">kprocyszyn</a> · <a href=\"https://profiles.wordpress.org/krishaamer/\">krishaamer</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/kshaner/\">kshaner</a> · <a href=\"https://profiles.wordpress.org/kub1x/\">kub1x</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/kunalpuri123/\">kunalpuri123</a> · <a href=\"https://profiles.wordpress.org/kushsharma/\">Kush Sharma</a> · <a href=\"https://profiles.wordpress.org/kush123/\">Kushagra Goyal</a> · <a href=\"https://profiles.wordpress.org/lgadzhev/\">Lachezar Gadzhev</a> · <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a> · <a href=\"https://profiles.wordpress.org/lakshyajeet/\">Lakshyajeet Singh Goyal</a> · <a href=\"https://profiles.wordpress.org/lalitkumawat/\">Lalit Kumawat</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurisaarni/\">Lauri Saarni</a> · <a href=\"https://profiles.wordpress.org/ldanielgiuliani/\">ldanielgiuliani</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a> · <a href=\"https://profiles.wordpress.org/levinbaria/\">Levin Baria</a> · <a href=\"https://profiles.wordpress.org/lgseo/\">lgseo</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/logiclink/\">logiclink</a> · <a href=\"https://profiles.wordpress.org/logicrays/\">LogicRays Technologies</a> · <a href=\"https://profiles.wordpress.org/lordandy1984/\">lordandy1984</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasms/\">Lucas Martins</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasfritzedev/\">LukasFritzeDev</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maccyd/\">maccyd</a> · <a href=\"https://profiles.wordpress.org/madhavishah01/\">Madhavi Shah</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maikuolan/\">Maikuolan</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manhatthien98/\">manhatthien98</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">Manuel Camargo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/maorb/\">maorb</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Marcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/leadclown/\">Marcus</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/mariohamann/\">mariohamann</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/bozzmedia/\">Marty</a> · <a href=\"https://profiles.wordpress.org/martythornley/\">MartyThornley</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/mathiscode/\">mathiscode</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/maxschmeling/\">Max Schmeling</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/mabfahad/\">Md Abdullah Al Fahad</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/ismail0071/\">MD ISMAIL</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/masummollaalhaz/\">Md Masum Molla Alhaz</a> · <a href=\"https://profiles.wordpress.org/obiplabon/\">Md Obidullah (obiPlabon)</a> · <a href=\"https://profiles.wordpress.org/wprashed/\">Md Rashed Hossain</a> · <a href=\"https://profiles.wordpress.org/sabbir20/\">Md Sabbir Hossain</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdmoreau/\">mdmoreau</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michaelkeck/\">Michael Keck</a> · <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a> · <a href=\"https://profiles.wordpress.org/xmic/\">Michael Sumner</a> · <a href=\"https://profiles.wordpress.org/michaelreetz/\">michaelreetz</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mobius5150/\">Mike</a> · <a href=\"https://profiles.wordpress.org/mikefitzman/\">Mike Fitzpatrick</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/firestar300/\">Milan Ricoul</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/369work/\">Miroku</a> · <a href=\"https://profiles.wordpress.org/missveronicatv/\">missveronica</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mkeck/\">mkeck</a> · <a href=\"https://profiles.wordpress.org/mlaetitia1986/\">mlaetitia1986</a> · <a href=\"https://profiles.wordpress.org/mleray/\">mleray</a> · <a href=\"https://profiles.wordpress.org/mleraygp/\">mleraygp</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mohkatz/\">Mohammed Kateregga</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtg169/\">mtg169</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/sedmikrasky/\">Núria Nadal i Rovira</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/vyasnaman/\">Naman Vyas</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/naveendwivedi/\">Naveen Dwivedi</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/bugnumber9/\">Nazar Hotsa</a> · <a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/nexbridge/\">nexbridge</a> · <a href=\"https://profiles.wordpress.org/nextendweb/\">Nextendweb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nickchomey/\">Nick</a> · <a href=\"https://profiles.wordpress.org/nickstarkloff/\">Nick</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nickbrazilian/\">nickbrazilian</a> · <a href=\"https://profiles.wordpress.org/nickjbedford/\">nickjbedford</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nigelnelles/\">nigelnelles</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/nimeshatxecurify/\">Nimesh</a> · <a href=\"https://profiles.wordpress.org/ninomiho/\">Nino Mihovilic</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/oferlaor/\">oferlaor</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/yasunocco/\">Okawa Yasuno</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Ophelia Rose</a> · <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a> · <a href=\"https://profiles.wordpress.org/owi/\">owi</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/palak678/\">Palak Patel</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/techpartho/\">Partho Hore</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/patpiwo/\">Patrick Piwowarczyk</a> · <a href=\"https://profiles.wordpress.org/pryley/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulbonneau/\">Paul Bonneau</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/paulstanos/\">paulstanos</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedrofigueroa1989/\">Pedro Figueroa</a> · <a href=\"https://profiles.wordpress.org/peroks/\">Per Egil Roksvaag</a> · <a href=\"https://profiles.wordpress.org/peteringersoll/\">Peter Ingersoll</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philipjohn/\">Philip John</a> · <a href=\"https://profiles.wordpress.org/philsola/\">Philip Sola</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/piskvorky/\">piskvorky</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/poojapadamad/\">poojapadamad</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/prab18hat/\">prab18hat</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranjalpratapsingh/\">Pranjal Pratap Singh</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prasadgupte/\">prasadgupte</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/puggan/\">puggan</a> · <a href=\"https://profiles.wordpress.org/quentinr64600/\">quentinr64600</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">Raluca</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravichudasama01/\">Ravi Chudasama</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcrdortiz/\">rcrdortiz</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves</a> · <a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/rezwanshiblu1952/\">Rezwan Shiblu</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riadev/\">riadev</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishabhwp/\">Rishabh Gupta</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/ristojovanovic/\">Risto Jovanovic</a> · <a href=\"https://profiles.wordpress.org/devrito/\">Ritoban</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O’Rourke</a> · <a href=\"https://profiles.wordpress.org/robmcclel/\">Robmcclel</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/roelof/\">roelof</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">Rolly Bueno</a> · <a href=\"https://profiles.wordpress.org/ronak44/\">Ronak prajapati</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/rutvikbhambhi2004/\">Rutvik Bhambhi</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/devsabbirahmed/\">Sabbir Sam</a> · <a href=\"https://profiles.wordpress.org/sachinrajcp123/\">SACHINRAJ CP</a> · <a href=\"https://profiles.wordpress.org/sahiljadhav1617/\">Sahil Jadhav</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmoon/\">sakibmoon</a> · <a href=\"https://profiles.wordpress.org/samueljseay/\">Sam</a> · <a href=\"https://profiles.wordpress.org/sam_a/\">sam_a</a> · <a href=\"https://profiles.wordpress.org/samirmalpande/\">Samir Malpande</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/sjapaget/\">Samuel Paget</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandeepdahiya/\">Sandeep Dahiya</a> · <a href=\"https://profiles.wordpress.org/sandipsinh007/\">Sandip Sinh</a> · <a href=\"https://profiles.wordpress.org/ourvalley/\">Sandy McFadden</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shsajalchowdhury/\">SH Sajal Chowdhury</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/iamshashank/\">Shashank Jain</a> · <a href=\"https://profiles.wordpress.org/shekh0109/\">Shashank Shekhar</a> · <a href=\"https://profiles.wordpress.org/sajib1223/\">Shazzad Hossain Khan</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreya0shrivastava/\">Shreya Shrivastava</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> · <a href=\"https://profiles.wordpress.org/sidharthpandita/\">sidharthpandita</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/shilpaashokan94/\">Silpa TA</a> · <a href=\"https://profiles.wordpress.org/simonefontana/\">simonefontana</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/maia12345/\">Sophie Dimitrov</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar01/\">Soyeb Salar</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spstrap/\">spstrap</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stankea/\">stankea</a> · <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/hubersen/\">Stefan Pasch</a> · <a href=\"https://profiles.wordpress.org/stefanvelthuys/\">Stefan Velthuys</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sujansarkar/\">Sujan Sarkar</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunnykasera/\">sunnykasera</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/supernovia/\">supernovia</a> · <a href=\"https://profiles.wordpress.org/suzukube/\">SuzuKube</a> · <a href=\"https://profiles.wordpress.org/svedish/\">svedish</a> · <a href=\"https://profiles.wordpress.org/lordspace/\">Svetoslav Marinov</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/syhussaini/\">syhussaini</a> · <a href=\"https://profiles.wordpress.org/schwipps/\">T4ng</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tatof/\">tatof</a> · <a href=\"https://profiles.wordpress.org/tecnogaming/\">tecnogaming</a> · <a href=\"https://profiles.wordpress.org/mecaota/\">Tetsuro Higuchi</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/tsquez/\">ThemeAWESOME</a> · <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timotheemoulin/\">Timothée Moulin</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/traxus/\">traxus</a> · <a href=\"https://profiles.wordpress.org/sllimrovert/\">Trevor Mills</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tsteel/\">tsteel</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharbharti/\">Tushar Bharti</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tussendoor/\">Tussendoor B.V.</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshnevase/\">Umesh Nevase</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavladani/\">Utsav Ladani</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentingrenier/\">Valentin Grenier</a> · <a href=\"https://profiles.wordpress.org/tsimshatsui/\">Vape tsimshatsui</a> · <a href=\"https://profiles.wordpress.org/vbbp/\">vbbp</a> · <a href=\"https://profiles.wordpress.org/sheldorofazeroth/\">Vedansh Mishra</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vidugupta/\">vidugupta</a> · <a href=\"https://profiles.wordpress.org/vijendrajat/\">Vijendra Jat</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/walterebert/\">Walter Ebert</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/websupporter/\">websupporter</a> · <a href=\"https://profiles.wordpress.org/webwrotter/\">webwrotter</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/widhy980/\">widhy980</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xerpa43/\">xerpa43</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a> · <a href=\"https://profiles.wordpress.org/yashyadav247/\">Yash</a> · <a href=\"https://profiles.wordpress.org/getsyash/\">Yash B</a> · <a href=\"https://profiles.wordpress.org/yashjawale/\">Yash Jawale</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yogieanamcara/\">YogieAnamCara</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">Zeel Thakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/lstraczynski/\">Łukasz Strączyński</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.9 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.9 est déjà complètement disponible dans plus de 30 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.9 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a>, <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a>, <a href=\"https://profiles.wordpress.org/barnemax/\">Maxime ETCHEBARNE</a>, <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a>, <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/emillet/\">Elisabeth</a> et <a href=\"https://profiles.wordpress.org/bishoya/\">Bishoy.A</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à&nbsp;<a href=\"https://profiles.wordpress.org/wolforg/\">Didier Demory</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/nlegagneur/\">xxx</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3411\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Nov 2025 12:31:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3383\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"Temps de lecture estimé&#160;:&#160; WordPress 6.9 comprend la résolution de plus de&#160;400 tickets sur Trac, dont&#160;125 améliorations et nouvelles fonctionnalités,&#160;plus de 250 corrections de bogues. Cette version comprend 35 tickets focalisés sur l’éditeur, 15 tickets focalisés sur l’admin WP et 45 sur les performances. Les modifications de la version 6.9 concernent&#160;55 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://make.wordpress.org/core/files/2025/10/drag-3.mp4\";s:6:\"length\";s:7:\"4330080\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://make.wordpress.org/test/files/2025/10/Hide-Block.mov\";s:6:\"length\";s:8:\"23505066\";s:4:\"type\";s:15:\"video/quicktime\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://make.wordpress.org/core/files/2025/10/drag-2.mp4\";s:6:\"length\";s:7:\"5447134\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:60265:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png\"><img decoding=\"async\" width=\"1804\" height=\"962\" src=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3384\" srcset=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png 1804w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-300x160.png 300w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-1024x546.png 1024w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-768x410.png 768w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-1536x819.png 1536w\" sizes=\"(max-width: 1804px) 100vw, 1804px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">12–17 minutes</div></div>\n\n\n\n<p>WordPress 6.9 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=priority&amp;order=priority&amp;max=500\">400 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.9&amp;group=component&amp;max=200&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">125 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.9&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 250 corrections de bogues</a>. Cette version comprend <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;component=Editor&amp;milestone=6.9&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">35 tickets focalisés sur l’éditeur</a>, <a href=\"https://core.trac.wordpress.org/query?component=Administration&amp;milestone=6.9&amp;or&amp;focuses=~administration&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">15 tickets focalisés sur l’admin WP</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.9&amp;or&amp;status=closed&amp;component=Script+Loader&amp;milestone=6.9&amp;or&amp;status=closed&amp;component=Query&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">45 sur les performances</a>. Les modifications de la version 6.9 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">55 composants du cœur du CMS</a>, dont deux nouveaux composants (AI et Notes).</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=(label%3A%22%5BType%5D%20Enhancement%22%20AND%20is%3Aclosed)%20AND%20(milestone%3A%22Gutenberg%2020.4%22%20OR%20milestone%3A%22Gutenberg%2020.5%22%20OR%20milestone%3A%22Gutenberg%2020.6%22%20OR%20milestone%3A%22Gutenberg%2020.7%22%20OR%20milestone%3A%22Gutenberg%2020.8%22%20OR%20milestone%3A%22Gutenberg%2020.9%22%20OR%20milestone%3A%22Gutenberg%2021.0%22%20OR%20milestone%3A%22Gutenberg%2021.1%22%20OR%20milestone%3A%22Gutenberg%2021.2%22%20OR%20milestone%3A%22Gutenberg%2021.3%22%20OR%20milestone%3A%22Gutenberg%2021.4%22%20OR%20milestone%3A%22Gutenberg%2021.5%22%20OR%20milestone%3A%22Gutenberg%2021.6%22%20OR%20milestone%3A%22Gutenberg%2021.7%22%20OR%20milestone%3A%22Gutenberg%2021.8%22%20OR%20milestone%3A%22Gutenberg%2021.9%22%20OR%20milestone%3A%22Gutenberg%2022.0%22%20OR%20milestone%3A%22Gutenberg%2022.1%22)\">440 améliorations</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=(label%3A%22%5BType%5D%20Bug%22%20AND%20is%3Aclosed)%20AND%20(milestone%3A%22Gutenberg%2020.4%22%20OR%20milestone%3A%22Gutenberg%2020.5%22%20OR%20milestone%3A%22Gutenberg%2020.6%22%20OR%20milestone%3A%22Gutenberg%2020.7%22%20OR%20milestone%3A%22Gutenberg%2020.8%22%20OR%20milestone%3A%22Gutenberg%2020.9%22%20OR%20milestone%3A%22Gutenberg%2021.0%22%20OR%20milestone%3A%22Gutenberg%2021.1%22%20OR%20milestone%3A%22Gutenberg%2021.2%22%20OR%20milestone%3A%22Gutenberg%2021.3%22%20OR%20milestone%3A%22Gutenberg%2021.4%22%20OR%20milestone%3A%22Gutenberg%2021.5%22%20OR%20milestone%3A%22Gutenberg%2021.6%22%20OR%20milestone%3A%22Gutenberg%2021.7%22%20OR%20milestone%3A%22Gutenberg%2021.8%22%20OR%20milestone%3A%22Gutenberg%2021.9%22%20OR%20milestone%3A%22Gutenberg%2022.0%22%20OR%20milestone%3A%22Gutenberg%2022.1%22)\">570 corrections de bogues</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-light-grey-2-color has-text-color has-background has-link-color wp-elements-cad2a17e334a7de448f5bc24abac31cd\" style=\"background:linear-gradient(135deg,rgb(53,10,128) 67%,rgb(244,237,234) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.9, dont la sortie est prévue le 2 décembre 2025.</p>\n\n\n\n<p>Pour la première fois, cette version majeure sera rendue publique en <em>live</em> lors de l&rsquo;événement annuel <em>State of the Word</em> qui se tiendra cette année à San Francisco le 2 décembre.</p>\n\n\n\n<p class=\"has-purple-2-color has-text-color has-link-color wp-elements-414d58c89e9217ac699c7ae039abebf9\"><a href=\"https://make.wordpress.org/core/2025/11/26/6-9-release-day-timeline-shift-for-state-of-the-word/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.9</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Table des matières : </p>\n\n\n\n<nav aria-label=\"Table des matières\" class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#de-nouvelles-facons-de-collaborer\">De nouvelles façons de collaborer</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#les-notes-font-leur-entree\">Les Notes font leur entrée</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updates-to-field-api-dataviews-and-dataforms-components\">Mise à jour de l’API « Field » et des composants « DataViews » et « DataForms »</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-editing-tools-and-architecture\">Amélioration des outils d’édition</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#direct-drag-and-drop\">Glisser-déposer en direct</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#ability-to-hide-blocks-1\">Possibilité de masquer des blocs</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#iframe-integration-in-post-editor-1\">Intégration iframe de l’éditeur de contenu</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#streaming-block-parser\">Un nouvel outil pour traiter les blocs</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#new-blocks-and-block-improvements\">Nouveau blocs et améliorations des blocs existants</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#perform-calculations-using-π-in-the-math-block\">Un bloc d&rsquo;affichage des formules mathématiques</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#accordion-block-now-supports-anchors\">Du contenu repliable avec le bloc Accordéon</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#heading-block-css-specificity-fix\">Correction de la spécificité CSS du bloc Titre</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#new-improved-apis\">Nouvelles API et modifications des API existantes</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#meet-the-abilities-api\">Découvrez l’API « Abilities »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updates-to-interactivity-api\">Mise à jour de l’API « Interactivity »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#html-api-updatesimproved-blocks-binding-api\">Mise à jour de l’API « HTML »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-block-binding-api\">Amélioration de l’API « Block Binding »</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#optimized-performance\">Optimisations des performances</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#modernizing-utf-8-support\">Modernisation du support d’UTF-8</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updated-query-cache-handling\">Mise à jour de la gestion du cache des requêtes</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#remove-support-for-loading-assets-conditionally-for-ie\">Suppression du support du chargement conditionnel des ressources pour Internet Explorer</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#accessibility-updates\">Accessibilité</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#php-8-5-support\">Support de PHP 8.5</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#miscellaneous-developer-changes\">Autres changements techniques</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#miscellaneous-editor-changes\">Changements divers concernant l&rsquo;éditeur</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updated-admin-menu-search-query\">Modification des requêtes de recherche du menu d&rsquo;administration</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#additional-support-for-https-in-url-escaping-functions\">Un support complémentaire de HTTPS dans les fonctions d&rsquo;échappement d&rsquo;URL</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-email-handling-and-inline-image-support\">Amélioration de la gestion des e-mails et du support des images en ligne</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#travaux-lies-a-l-implementation-des-outils-ia-dans-wp-6-9\">Travaux liés à l&rsquo;implémentation des outils IA dans WP 6.9</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#php-ai-client\">Client PHP pour l&rsquo;implémentation d&rsquo;outils IA</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#mcp-adapter\">Adaptateur MCP</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#but-wait-there-is-more\">Attendez, ce n’est pas fini !</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</a></li></ol></nav>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"de-nouvelles-facons-de-collaborer\">De nouvelles façons de collaborer</h2>\n\n\n\n<p>Créer et gérer du contenu avec WordPress 6.9 sera encore plus efficace grâce à de nouveaux outils et fonctionnalités qui encouragent la collaboration et simplifient l&rsquo;utilisation. Vous pouvez désormais ajouter des notes aux blocs et profiter de vues de données optimisées ainsi que d&rsquo;une palette de commandes intégrée à l’admin WP.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"les-notes-font-leur-entree\">Les Notes font leur entrée</h3>\n\n\n\n<p>Dans WordPress 6.9, les rédacteur·ices peuvent rédiger des notes et répondre directement aux notes ajoutées par d’autres au niveau de chaque bloc, ce qui permet aux équipes de collaborer, de suivre les modifications et de donner leur avis pendant le processus d&rsquo;édition. Les notes peuvent être résolues, modifiées et supprimées. Une notification par e-mail est envoyée à l&rsquo;auteur·ice de l&rsquo;article lorsqu&rsquo;une nouvelle note est ajoutée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"s60Ci2rnYH\"><a href=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/\">Notes feature in WordPress 6.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Notes feature in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/embed/#?secret=DP6kJwS0eP#?secret=s60Ci2rnYH\" data-secret=\"s60Ci2rnYH\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updates-to-field-api-dataviews-and-dataforms-components\">Mise à jour de l’API «&nbsp;Field&nbsp;» et des composants «&nbsp;DataViews&nbsp;» et «&nbsp;DataForms&nbsp;»</h3>\n\n\n\n<p>Cette version propose aussi une mise à jour de l’API «&nbsp;Field&nbsp;» et des composants «&nbsp;DataViews&nbsp;» et «&nbsp;DataForms&nbsp;»</p>\n\n\n\n<p>Dans l’<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#field-api\">API Field (champs)</a>,&nbsp;le&nbsp;paramètre <code>type</code>&nbsp;permet désormais d&rsquo;inclure 10 nouveaux types de champs, 11 contrôleurs de type <code>edit</code> qui permettent d&rsquo;indiquer des types de validation, plus de 16 opérateurs de filtrage, une option <code>readOnly</code> pour désactiver l&rsquo;édition des champs, et bien plus encore.</p>\n\n\n\n<p>Les modifications des fonctions du composant&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#dataviews\">DataViews (vues de données)</a>&nbsp;concernent des améliorations des modales et des actions basées sur l&rsquo;utilisation du texte, un défilement infini et la possibilité de construire des mises en page utilisant la fonctionnalité <code>children</code> pour tirer profit de la gestion interne des états des vues de données et de la logique de gestion des données. Les vues de données sont maintenant persistantes et sont gérées via le paquet&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#dataviews-persistence\"><code>@wordpress/views</code></a>. Le panneau de gestion des <code>DataForms</code> (formulaires de données) a été amélioré et d&rsquo;autres éléments ont été améliorés comme les mises en page <code>card</code> et <code>row</code> ainsi que la gestion des validations.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"0aGWCGMOJD\"><a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/\">DataViews, DataForm, et al. in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;DataViews, DataForm, et al. in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/embed/#?secret=XkaN1RVWhq#?secret=0aGWCGMOJD\" data-secret=\"0aGWCGMOJD\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"improved-editing-tools-and-architecture\">Amélioration des outils d’édition</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"direct-drag-and-drop\">Glisser-déposer en direct</h3>\n\n\n\n<p>Le <a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/#direct-drag-and-drop\">glisser-déposer</a>&nbsp;a été amélioré, avec la possibilité de <a href=\"https://github.com/WordPress/gutenberg/pull/67470\">directement déplacer des blocs à l&rsquo;intérieur de l&rsquo;éditeur</a> au lieu de devoir sélectionner le contrôleur de glisser-déposer.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/core/files/2025/10/drag-3.mp4\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du glisser-déposer dans l&rsquo;éditeur.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"ability-to-hide-blocks-1\">Possibilité de masquer des blocs</h3>\n\n\n\n<p>WordPress 6.9 permet de masquer et afficher des blocs d&rsquo;un simple clic.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/test/files/2025/10/Hide-Block.mov\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du masquage de blocs dans l&rsquo;éditeur.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"iframe-integration-in-post-editor-1\">Intégration iframe de l’éditeur de contenu</h3>\n\n\n\n<p>Il y a&nbsp;une <a href=\"https://make.wordpress.org/core/2021/06/29/blocks-in-an-iframed-template-editor/\">initiative en cours</a>&nbsp;pour placer l&rsquo;éditeur de contenu au sein d&rsquo;une&nbsp;<code>iframe</code>, et plusieurs modifications servent à préparer cette future implémentation&nbsp;:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Le&nbsp;<a href=\"https://github.com/WordPress/gutenberg/blob/trunk/schemas/json/block.json\">schéma <code>block.json</code></a>&nbsp;ne permet plus que d&rsquo;utiliser l’<code>apiVersion</code>&nbsp;<code>3</code>&nbsp;pour les nouveaux blocs ou les blocs modifiés</li>\n\n\n\n<li>Un avertissement sera affiché dans la console du navigateur lorsqu&rsquo;un bloc utilise les <code>apiVersion</code>&nbsp;<code>1</code>&nbsp;ou&nbsp;<code>2</code></li>\n</ol>\n\n\n\n<p>Ces modifications visent à aider les développeur·euses à migrer leurs blocs vers <code>apiVersion</code>&nbsp;3. L&rsquo;objectif est de complètement déplacer l’éditeur dans une <code>iframe</code> à partir de WordPress 7.0. Même si cette grosse modification est déjà prête, nous laissons donc un peu de temps aux personnes qui proposent des extensions WP pour mettre à niveau leurs développements.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"t6qkBt4uZq\"><a href=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/\">Preparing the Post Editor for Full iframe Integration</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparing the Post Editor for Full iframe Integration&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/embed/#?secret=iVv6lZOGtJ#?secret=t6qkBt4uZq\" data-secret=\"t6qkBt4uZq\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"streaming-block-parser\">Un nouvel outil pour traiter les blocs</h3>\n\n\n\n<p>WordPress 6.9 comprend un nouvel outil&nbsp;<code>WP_Block_Processor</code>&nbsp;pour scanner les structures des blocs contenus dans des documents HTML. Cette nouvelle classe permet de parcourir un document HTML pour analyser et ajuster les structures de ses blocs sans affecter le texte, de convertir des documents en un tableau imbriqué d&rsquo;informations concernant les blocs utilisés et d&rsquo;obtenir des tableaux JSON d&rsquo;attributs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dlxl4wHiYQ\"><a href=\"https://make.wordpress.org/core/2025/11/19/introducing-the-streaming-block-parser-in-wordpress-6-9/\">Introducing the streaming block parser in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the streaming block parser in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/introducing-the-streaming-block-parser-in-wordpress-6-9/embed/#?secret=dbr2Knuzma#?secret=dlxl4wHiYQ\" data-secret=\"dlxl4wHiYQ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-blocks-and-block-improvements\">Nouveau blocs et améliorations des blocs existants</h2>\n\n\n\n<p>La bibliothèque de blocs natifs a été enrichie de plusieurs nouveaux blocs&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Un bloc d&rsquo;affichage de formules mathématiques</li>\n\n\n\n<li>Un <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">bloc de requête portant sur les termes de taxonomies</a></li>\n\n\n\n<li>Un bloc de lien vers les commentaires</li>\n\n\n\n<li>Un bloc servant à afficher un compteur des commentaires d&rsquo;un article</li>\n\n\n\n<li>Des améliorations des blocs Titre et Temps de lecture</li>\n</ul>\n\n\n\n<p>WP 6.9 contient aussi de nouvelles fonctionnalités d&rsquo;édition de texte comme le support de <code>fitText</code> qui permet de définir automatiquement la taille du texte en fonction des limites du conteneur dans lequel il s&rsquo;inscrit.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"perform-calculations-using-π-in-the-math-block\">Un bloc d&rsquo;affichage des formules mathématiques</h3>\n\n\n\n<p>Le&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/72182\">nouveau bloc Math</a>&nbsp;ajoute le support du standard MathML et du rendu LaTeX pour l&rsquo;affichage de formules mathématiques, soit en tant que bloc indépendant, soit dans du texte en ligne pouvant être ajouté dans n&rsquo;importe quel champs de texte enrichi comme les tableaux, les titres ou encore les listes.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/core/files/2025/10/drag-2.mp4\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du bloc de d&rsquo;affichage des formules mathématiques.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"accordion-block-now-supports-anchors\">Du contenu repliable avec le bloc Accordéon</h3>\n\n\n\n<p>Le <a href=\"https://github.com/WordPress/gutenberg/issues/21584\">nouveau bloc Accordéon</a>&nbsp;de WP 6.9 peut être personnalisé à volonté. Un article dédié explique&nbsp;<a href=\"https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/\">comment mettre en forme le bloc Accordéon</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://developer.wordpress.org/news/files/2025/10/accordion-toggle-styled-1536x795.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"heading-block-css-specificity-fix\">Correction de la spécificité CSS du bloc Titre</h3>\n\n\n\n<p>WP 6.9 comprend une&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9\">modification du sélecteur CSS utilisé pour les marges internes (<code>padding</code>) sur les titres avec arrière-plan</a>, qui est dorénavant ciblé avec les deux classes <code><strong>.</strong>wp-block-heading</code>&nbsp;et <code>.has-background</code>&nbsp;pour garantir que les personnalisations des marges n&rsquo;affectent que le bloc souhaité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4s3vlJO0cL\"><a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/\">Heading Block CSS Specificity Fix in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Heading Block CSS Specificity Fix in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/embed/#?secret=zG5lJIgvUv#?secret=4s3vlJO0cL\" data-secret=\"4s3vlJO0cL\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-improved-apis\">Nouvelles API et modifications des API existantes</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"meet-the-abilities-api\">Découvrez l’API «&nbsp;Abilities&nbsp;»</h3>\n\n\n\n<p>L’API «&nbsp;Abilities&nbsp;» permet au cœur de WordPress mais aussi aux développeur·euses de thèmes et d&rsquo;extensions d&rsquo;enregistrer leur fonctionnalités de façon unifiée, standardisée et dans un format programmatiquement lisible. L’API «&nbsp;Abilities&nbsp;» fait partie de l&rsquo;initiative plus large visant à&nbsp;<a href=\"https://make.wordpress.org/ai/2025/07/17/ai-building-blocks\">permettre la construction de blocs en passant par l’IA</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOUP8yZWH0\"><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\">Abilities API in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Abilities API in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/embed/#?secret=5HIq07RelF#?secret=TOUP8yZWH0\" data-secret=\"TOUP8yZWH0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updates-to-interactivity-api\">Mise à jour de l’API «&nbsp;Interactivity&nbsp;»</h3>\n\n\n\n<p>Dans WordPress 6.9, l’API de gestion des interactions offre désormais une manière standard d&rsquo;assigner des identifiants uniques aux directives de l’API, ce qui permet aux éléments du site de disposer de multiples directives similaires sans conflit.</p>\n\n\n\n<p>Les fonctions <code>getServerState(</code>) et&nbsp;<code>getServerContext()</code>&nbsp;ont été mises à jour et un nouvel algorithme optimise la gestion des scripts et des styles, offre une meilleure prise en charge des régions de routage dans les éléments interactifs, et ajoute un nouveau paramètre <code>attachTo</code>&nbsp;property qui agit comme un sélecteur CSS pointant sur l&rsquo;élément parent pour le rendu.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HncJjhFChJ\"><a href=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/\">Changes to the Interactivity API in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the Interactivity API in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/embed/#?secret=Y7kVvTbuT1#?secret=HncJjhFChJ\" data-secret=\"HncJjhFChJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"html-api-updatesimproved-blocks-binding-api\">Mise à jour de l’API «&nbsp;HTML&nbsp;»</h3>\n\n\n\n<p>L’API HTML a été fignolée, avec plusieurs corrections de bogues et améliorations. La méthode&nbsp;<code>WP_HTML_Processor::serialize_token()</code>est désormais publique, ce qui étend la sécurité de l’API au delà de la seule modification de code et la combinaison de code HTML, tandis que&nbsp;<code>set_modifiable_text()</code>&nbsp;rejette désormais les contenus des éléments <code>SCRIPT</code> qui pourraient compromettre sa fermeture normale.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"plqVJwX0cB\"><a href=\"https://make.wordpress.org/core/2025/11/21/updates-to-the-html-api-in-6-9/\">Updates to the HTML API in 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/21/updates-to-the-html-api-in-6-9/embed/#?secret=0EQBKJN8hF#?secret=plqVJwX0cB\" data-secret=\"plqVJwX0cB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"improved-block-binding-api\">Amélioration de l’API «&nbsp;Block Binding&nbsp;»</h3>\n\n\n\n<p>L’interface de l’API Block Bindings a été rendue plus simple d&rsquo;utilisation avec la possibilité nouvelle de basculer entre les sources, et de rattacher ou détacher des attributs d&rsquo;un simple clic. Le nouveau filtre <code>block_bindings_supported_attributes_{$block_type}</code> facilite quant à lui la personnalisation de la manière dont les attributs des blocs se connectent à une source liée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7HOG5iwH71\"><a href=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/\">Block Bindings improvements in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings improvements in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/embed/#?secret=Shct73Aisv#?secret=7HOG5iwH71\" data-secret=\"7HOG5iwH71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"optimized-performance\">Optimisations des performances</h2>\n\n\n\n<p>WordPress 6.9 offre des améliorations significatives en termes de performances, ce qui optimise l&rsquo;expérience de chargement des sites pour les internautes. L&rsquo;amélioration du LCP (<em>Largest Contentful Paint</em>) est obtenue grâce à la mise en place des styles de blocs à la demande pour les thèmes classiques, la minification des styles de blocs et l&rsquo;augmentation de la limite des styles en ligne, réduisant ainsi le blocage du rendu. Le chemin de rendu critique («&nbsp;critical path&nbsp;») est décongestionné par la dépriorisation des scripts non critiques (par exemple, ceux des blocs interactifs ou de la détection des émojis) qui entraient en conflit avec le chargement de ressources comme l&rsquo;image de l&rsquo;élément considéré comme étant l&rsquo;élément LCP. La stabilité des pages est également améliorée en empêchant le bloc Vidéo de provoquer des décalages de mise en page (ce qui améliore la métrique CLS).</p>\n\n\n\n<p>Beaucoup d&rsquo;autres améliorations ont été faites, par exemple sur les requêtes en base de données, la gestion du cache, une meilleure gestion du CRON WP et des améliorations du tampon de rendu des modèles qui ouvre la porte à de nombreuses améliorations de performances qui étaient auparavant impossibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ijQE6fAipJ\"><a href=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/\">WordPress 6.9 Frontend Performance Field Guide</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.9 Frontend Performance Field Guide&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/embed/#?secret=1athSDczWJ#?secret=ijQE6fAipJ\" data-secret=\"ijQE6fAipJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"modernizing-utf-8-support\">Modernisation du support d’UTF-8</h3>\n\n\n\n<p>Un nouveau tunnel de repli écrit en PHP permet à WordPress 6.9 de traiter l’encodage du texte et la gestion d&rsquo;UTF-8 indépendamment de l&rsquo;environnement sur lequel tourne le site, ce qui apporte plus de cohérence entre les différents environnements sur lesquels votre site peut être installé, ce qui est notamment utile aux thèmes et extensions qui travaillent avec du contenu internationnalisé, ou avec les émojis.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ikru7pjb4g\"><a href=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\">Modernizing UTF-8 support in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Modernizing UTF-8 support in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/embed/#?secret=ggNMEISTIZ#?secret=ikru7pjb4g\" data-secret=\"ikru7pjb4g\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updated-query-cache-handling\">Mise à jour de la gestion du cache des requêtes</h3>\n\n\n\n<p>La version 6.9 modifie la façon dont les clés de cache sont créées lorsque les requêtes mises en cache sont traitées dans <code>WP_Query</code>. Le cache objet persistant ne devrait pas être affecté, mais les développeurs et développeuses ainsi que les entreprises fournissant des services d&rsquo;hébergements sont invités à prendre en compte les modifications décrites dans cette note de développement, et à tirer parti des 4 nouvelles fonctions disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hbBdeytkdI\"><a href=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/\">Consistent Cache Keys for Query Groups in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Consistent Cache Keys for Query Groups in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/embed/#?secret=CGHgD2wunF#?secret=hbBdeytkdI\" data-secret=\"hbBdeytkdI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"remove-support-for-loading-assets-conditionally-for-ie\">Suppression du support du chargement conditionnel des ressources pour Internet Explorer</h3>\n\n\n\n<p>WordPress 6.9 supprime le support du <a href=\"https://core.trac.wordpress.org/ticket/63821\">chargement conditionnel des scripts et styles pour IE avec les anciennes structures conditionnelles</a>. Tous les restes de cette ancienne manière de faire <a href=\"https://core.trac.wordpress.org/ticket/58836\">ont été supprimés du code des thèmes natifs</a>. Le code lié à <a href=\"https://core.trac.wordpress.org/ticket/62128\">Genericons a aussi été modifié</a>&nbsp;sur les thèmes qui utilisent cette police web.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HBt3XMYVWY\"><a href=\"https://make.wordpress.org/core/2025/11/19/legacy-internet-explorer-code-removed/\">Legacy Internet Explorer Code Removed</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Legacy Internet Explorer Code Removed&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/legacy-internet-explorer-code-removed/embed/#?secret=sxUtkYszkF#?secret=HBt3XMYVWY\" data-secret=\"HBt3XMYVWY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility-updates\">Accessibilité</h2>\n\n\n\n<p>WordPress 6.9 comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?focuses=~accessibility&amp;milestone=6.9&amp;group=type&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">10 améliorations et 23 corrections de bogues</a>&nbsp;focalisées sur l&rsquo;accessibilité. Il y a par exemple des améliorations des notifications destinées aux technologies d&rsquo;assistance, des améliorations de la sémantique du code et de la gestion du focus clavier, et une mise à niveau du contenu généré via CSS pour éviter que du contenu non pertinent ne soit interprété par les outils d&rsquo;assistance.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"oVjH0GCizX\"><a href=\"https://make.wordpress.org/core/2025/11/19/accessibility-improvements-in-wordpress-6-9/\">Accessibility Improvements in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/accessibility-improvements-in-wordpress-6-9/embed/#?secret=446JdlkqcD#?secret=oVjH0GCizX\" data-secret=\"oVjH0GCizX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"php-8-5-support\">Support de PHP 8.5</h2>\n\n\n\n<p>WordPress 6.9 propose un support en version beta de PHP 8.5. Toutes les incompatibilités connues, les avertissements et notifications ont été corrigées. Le support des anciennes versions (pour l&rsquo;instant jusqu&rsquo;à PHP 7.2) a été maintenu. Pour rappel, lorsque nous parlons de support en version beta, nous parlons des <a href=\"https://make.wordpress.org/core/2025/07/07/proposal-remove-the-beta-support-label-from-php-8-3-for-wordpress-6-8/\">versions de PHP qui sont utilisées par moins de 10% des sites web</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HHsVP4QXlf\"><a href=\"https://make.wordpress.org/core/2025/11/21/php-8-5-support-in-wordpress-6-9/\">PHP 8.5 support in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;PHP 8.5 support in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/21/php-8-5-support-in-wordpress-6-9/embed/#?secret=S9UuaRYhKT#?secret=HHsVP4QXlf\" data-secret=\"HHsVP4QXlf\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>D&rsquo;autres modifications concernent différentes facettes du cœur du CMS, comme les médias, la gestion multisite, de nouveaux crochets et filtres, etc.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"1N55zTf5W3\"><a href=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/\">Miscellaneous Developer-focused Changes in 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Developer-focused Changes in 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/embed/#?secret=ArJDoGk5Vd#?secret=1N55zTf5W3\" data-secret=\"1N55zTf5W3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-editor-changes\">Changements divers concernant l&rsquo;éditeur</h3>\n\n\n\n<p>WP 6.9 apporte aussi un grand nombre de petites modifications de l&rsquo;éditeur de blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"nHqf9JJVdo\"><a href=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/\">Miscellaneous Editor Changes in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor Changes in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/embed/#?secret=sSj6Lr777I#?secret=nHqf9JJVdo\" data-secret=\"nHqf9JJVdo\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updated-admin-menu-search-query\">Modification des requêtes de recherche du menu d&rsquo;administration</h3>\n\n\n\n<p>Avec WordPress 6.9, la requête de recherche proposée par le menu d&rsquo;administration a changé, passant de&nbsp;<code>$_SERVER[\'QUERY_STRING\']</code>&nbsp;à&nbsp;<code>$_GET</code>. Cela rend le comportement de recherche plus prévisible et évite les problèmes liés à certaines chaines de requêtes. Les extensions qui surchargent cette recherche devront revoir leur façon de fonctionner pour prendre en compte ces changements.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DC2ukqUl8S\"><a href=\"https://make.wordpress.org/core/2025/11/19/admin-menu-search-query-changed/\">Admin menu search query changed</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Admin menu search query changed&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/admin-menu-search-query-changed/embed/#?secret=yuPvIQjESb#?secret=DC2ukqUl8S\" data-secret=\"DC2ukqUl8S\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"additional-support-for-https-in-url-escaping-functions\">Un support complémentaire de HTTPS&nbsp;dans les fonctions d&rsquo;échappement d&rsquo;URL</h3>\n\n\n\n<p>Les fonctions&nbsp;<code>esc_url()</code>,&nbsp;<code>esc_url_raw()</code>&nbsp;et&nbsp;<code>sanitize_url()</code>&nbsp;peuvent maintenant être configurées pour préfixer par <code>https://</code>&nbsp;les URL qui ne proposent pas de schéma par défaut, lorsque le paramètre&nbsp;<code>$protocols</code>&nbsp;contient&nbsp;<code>\'https\'</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"0MhD0ifthp\"><a href=\"https://make.wordpress.org/core/2025/11/19/url-escaping-functions-can-support-https-as-the-default-protocol-in-wordpress-6-9/\">URL-escaping functions can support HTTPS as the default protocol in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;URL-escaping functions can support HTTPS as the default protocol in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/url-escaping-functions-can-support-https-as-the-default-protocol-in-wordpress-6-9/embed/#?secret=jGf9jBhCeM#?secret=0MhD0ifthp\" data-secret=\"0MhD0ifthp\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"improved-email-handling-and-inline-image-support\">Amélioration de la gestion des e-mails et du support des images en ligne</h3>\n\n\n\n<p>WordPress 6.9 introduit plusieurs modifications rendant le système d&rsquo;envoi d&rsquo;e-mails plus fiable et flexible. La fonction&nbsp;<code>wp_mail()</code>&nbsp;met maintenant en place l&rsquo;adresse d&rsquo;expédition de manière extensible, les en-têtes sont mieux protégés et l&rsquo;ensemble se repose davantage sur PHPMailer pour la prise en charge des types de contenus. De nombreux autres petits soucis présents depuis quelques temps ont aussi été résolus.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"xd0Bpq88VA\"><a href=\"https://make.wordpress.org/core/2025/11/18/more-reliable-email-in-wordpress-6-9/\">More-reliable email in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More-reliable email in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/more-reliable-email-in-wordpress-6-9/embed/#?secret=y21eGjb1ze#?secret=xd0Bpq88VA\" data-secret=\"xd0Bpq88VA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Cette version ajoute aussi la prise en charge des images en ligne et embarquées dans les e-mails HTML, ce qui permet d&rsquo;envoyer des messages enrichis de médias sans avoir à utiliser des URL de sources externes. Les contenus e-mail qui utilisent des références basées sur <code>cid:</code>&nbsp;peuvent désormais afficher des images directement dans le corps de l&rsquo;e-mail.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wZZMOBpIHQ\"><a href=\"https://make.wordpress.org/core/2025/09/04/prettier-emails-supporting-inline-embedded-images/\">Prettier Emails: Supporting Inline Embedded Images</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Prettier Emails: Supporting Inline Embedded Images&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/09/04/prettier-emails-supporting-inline-embedded-images/embed/#?secret=n7ruDqZVQJ#?secret=wZZMOBpIHQ\" data-secret=\"wZZMOBpIHQ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"travaux-lies-a-l-implementation-des-outils-ia-dans-wp-6-9\">Travaux liés à l&rsquo;implémentation des outils IA dans WP 6.9</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"php-ai-client\">Client PHP pour l&rsquo;implémentation d&rsquo;outils IA</h3>\n\n\n\n<p>Le <a href=\"https://github.com/WordPress/php-ai-client\">nouveau SDK client PHP destiné aux outils IA</a> facilite l&rsquo;intégration d&rsquo;IA dans les extensions WordPress et les projets PHP. L&rsquo;interface fonctionne avec tous les fournisseurs d&rsquo;IA et les développeurs et développeuses peuvent spécifier les fonctionnalités IA à inclure, leur fournisseur et le modèle à utiliser. Les identifiants sont centralisés et fonctionnent avec toutes les extensions compatibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-wordpress-ai wp-block-embed-wordpress-ai\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e4MhX2H9Gt\"><a href=\"https://make.wordpress.org/ai/2025/07/17/php-ai-api/\">PHP AI Client</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;PHP AI Client&#8221; &#8212; WordPress AI\" src=\"https://make.wordpress.org/ai/2025/07/17/php-ai-api/embed/#?secret=n4QeTroMUh#?secret=e4MhX2H9Gt\" data-secret=\"e4MhX2H9Gt\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"mcp-adapter\">Adaptateur MCP</h3>\n\n\n\n<p>Le nouvel&nbsp;<a href=\"https://github.com/WordPress/mcp-adapter\">adaptateur MCP</a>&nbsp;utilise le&nbsp;<a href=\"https://modelcontextprotocol.io/\">Model Context Protocol</a>&nbsp;(MCP) pour standardiser les interactions de l&rsquo;applicatif WP avec les LLM, pour exposer les fonctionnalités de WordPress aux assistants IA et pour se connecter à d&rsquo;autres serveurs MCP. Cela permet à WordPress d&rsquo;agir à la fois comme serveur et comme client, en enregistrant ses fonctionnalités à travers l&rsquo;API «&nbsp;Abilities&nbsp;» ce qui permet aux assistants IA de les comprendre et de les utiliser, tout en intégrant cela avec d&rsquo;autres serveurs MCP ce qui rend possible de tirer parti d&rsquo;autres outils IA dans WordPress.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-wordpress-ai wp-block-embed-wordpress-ai\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e6borTD1aD\"><a href=\"https://make.wordpress.org/ai/2025/07/17/mcp-adapter/\">MCP Adapter</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;MCP Adapter&#8221; &#8212; WordPress AI\" src=\"https://make.wordpress.org/ai/2025/07/17/mcp-adapter/embed/#?secret=CmJsm2zJFL#?secret=e6borTD1aD\" data-secret=\"e6borTD1aD\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>6.9 apporte bien plus encore&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">250 bogues ont été corrigés</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">123 améliorations et nouvelles fonctionnalités ont été implémentées</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">22 tâches diverses</a>&nbsp;ont été <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">marquées comme résolues dans WP 6.9</a>.</p>\n\n\n\n<p>Mentionnons notamment les tickets suivants&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>API «&nbsp;Abilities&nbsp;» : feuille de route pour WP 6.9 (<a href=\"https://github.com/WordPress/abilities-api/issues/83\">AI-83</a>)</li>\n\n\n\n<li>Accessibilité : correction du comportement des sous menus du bloc navigation (<a href=\"https://github.com/WordPress/gutenberg/issues/69834\">GB-69834</a>)</li>\n\n\n\n<li>Éditeur : bloc bouton &#8211; ajout de la section Élément HTML dans les réglages avancés (<a href=\"https://github.com/WordPress/gutenberg/pull/70139\">GB-70139</a>)</li>\n\n\n\n<li>Éditeur : activation de la Palette de Commandes partout sur le tableau de bord (<a href=\"https://github.com/WordPress/gutenberg/issues/58218\">GB-58218</a>)</li>\n\n\n\n<li>Éditeur : nouveaux blocs ajoutés dans la bibliothèque de blocs (<a href=\"https://github.com/WordPress/gutenberg/issues/71026\">GB-71026</a>)</li>\n\n\n\n<li>Éditeur : barre d&rsquo;outils &#8211;  ajustement des couleurs pour la prise en charge du mode sombre (<a href=\"https://github.com/WordPress/gutenberg/issues/66454\">GB-66454</a>)</li>\n\n\n\n<li>Accessibilité : remplacement des règles CSS dépréciées <code>speak</code>&nbsp;et&nbsp;<code>aural</code>&nbsp;(<a href=\"https://github.com/WordPress/gutenberg/pull/63603\">GB-63603</a>)</li>\n\n\n\n<li>Styles globaux : déplacement du bouton&nbsp;<code>Couleurs aléatoires</code>&nbsp;dans le panneau d&rsquo;édition de la palette de couleurs (<a href=\"https://github.com/WordPress/gutenberg/issues/66169\">GB-66169</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que la version 6.9 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.9.0/\">https://developer.wordpress.org/reference/since/6.9.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-light-grey-2-color has-text-color has-background has-link-color wp-elements-e19b82be4e2290f9a4720996c21421a5 is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(53,10,128) 67%,rgb(244,237,234) 100%);padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)\">\n<p class=\"is-style-serif has-light-grey-2-color has-text-color has-link-color wp-elements-bdd3ef48864355ea6c49d0c39359deba\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.9</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide/\">Field Guide&nbsp;de WP 6.9 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3383\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Arrêt des mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://fr.wordpress.org/2025/07/11/arret-des-mises-a-jour-de-securite-pour-les-versions-4-1-a-4-6-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"À compter de mi-juillet 2025, l&#8217;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress. Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1368:\"\n<p>À compter de mi-juillet 2025, l&rsquo;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress.</p>\n\n\n\n<p>Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que cela affecte votre site est très faible.</p>\n\n\n\n<p>Pour vérifier que votre version de WordPress est à jour, connectez-vous au tableau de bord de votre site. Si votre version n&rsquo;est pas à jour, vous devriez voir un message proposant sa mise à jour. La version que vous utilisez est indiquée dans le widget « D&rsquo;un coup d&rsquo;œil » présent sur le tableau de bord.</p>\n\n\n\n<p>Pour rappel, <strong>la seule version de WordPress activement maintenue est la version majeure la plus récente</strong>. Les correctifs de sécurité ne sont portés vers les anciennes branches que par « courtoisie », les anciennes versions ne faisant pas l&rsquo;objet de corrections autres que de sécurité.</p>\n\n\n\n<p>Le blog « <bdo lang=\"en\" dir=\"ltr\">Make WordPress Security</bdo> » fournit plus de détails sur la <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">procédure de fin de support de ces versions (en anglais)</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3375\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Rendez-vous à Bâle pour le WordCamp Europe 2025 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://fr.wordpress.org/2025/04/28/rendez-vous-a-bale-pour-le-wordcamp-europe-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2025 08:39:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3362\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier ! Venez découvrir de nouvelles perspectives, engagez [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6355:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg\" alt=\"\" class=\"wp-image-3363\" srcset=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg 1024w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-300x158.jpg 300w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-768x403.jpg 768w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1536x806.jpg 1536w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg 1800w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier !</p>\n\n\n\n<p>Venez découvrir de nouvelles perspectives, engagez des conversations avec les membres de la communauté WordPress, les entreprises et acteurs économiques innovants de notre écosystème au cours de trois jours de conférences, de réseautage et de contribution à WordPress.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Les places sont limitées : réservez la vôtre dès aujourd&rsquo;hui !</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Réservez votre place (en anglais)</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Conférences et tables rondes</h2>\n\n\n\n<p>Cet évènement qui se tiendra les 6 et 7 juin 2025 proposera une <a href=\"https://europe.wordcamp.org/2025/schedule/\">série de conférences (en anglais)</a> qui porteront notamment sur des états des lieux de la stratégie des entreprise de l&rsquo;écosystème WordPress, le développement des nouvelles fonctionnalités du CMS, la défense du logiciel libre, l&rsquo;accessibilité, et bien plus encore.</p>\n\n\n\n<p>Pour celles et ceux qui souhaitent perfectionner leurs compétences, les présentations aborderont en profondeur des sujets tels que le SEO pour WordPress, l&rsquo;optimisation des performances, ou encore la conception et la production de sites assistée par l&rsquo;IA.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Séance de questions-réponses avec la direction du projet WordPress</h2>\n\n\n\n<p>Vous pourrez retrouver Mary Hubbard, directrice exécutive du projet WordPress, et Matt Mullenweg, co-fondateur de WordPress le 7 juin pour discuter de WordPress et de sa communauté.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Découvrez Bâle</h2>\n\n\n\n<p>Bâle est la troisième plus grande ville de Suisse. Elle est <a href=\"https://europe.wordcamp.org/2025/location/\">remplie de monuments historiques et culturels à découvrir (en anglais)</a>. Vous pouvez vous déplacer à Bâle et en faire l&rsquo;expérience par vous-même grâce à votre «&nbsp;<bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo>&nbsp;», qui vous permet de monter dans tous les transports en commun de la ville. L&rsquo;équipe d&rsquo;organisation du WordCamp vous recommande fortement d’en profiter pour vous promener le long du Rhin&nbsp;!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Trouver des logements à Bâle (en anglais)<br></a><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> En savoir plus sur la « <bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo> » (en anglais)</a><br><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Organisez votre WordCamp Europe !</strong> Découvrez le <a href=\"https://europe.wordcamp.org/2025/schedule/\">programme complet (en anglais)</a> et organisez votre séjour à Bâle !<br><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Assurez-vous de réserver votre <a href=\"https://europe.wordcamp.org/2025/tickets/\">ticket pour le WordCamp Europe 2025</a></strong> si vous ne l&rsquo;avez pas déjà fait !</p>\n\n\n\n<p>Suivez l&rsquo;actualité du WordCamp Europe sur <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>  et <a href=\"https://twitter.com/WordPress\">X/Twitter</a> pour avoir des nouvelles en temps réel&nbsp;!</p>\n\n\n\n<p>N&rsquo;hésitez pas à relayer le message sur vos réseaux sociaux favoris : que vous soyez là le jour-J à Bâle ou que vous nous suiviez en ligne, partagez vos expériences avec les mots-dièse #WCEU et #WordPress sur tous les réseaux sociaux !</p>\n\n\n\n<p>Rendez-vous à Bâle pour le WordCamp Europe 2025&nbsp;! <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.8 « Cecil »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://fr.wordpress.org/2025/04/15/wordpress-6-8-cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:02:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3335\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&#160;Cecil&#160;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor. De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80564:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png\" alt=\"\" class=\"wp-image-3338\" srcset=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png 1024w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-300x157.png 300w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-768x401.png 768w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1536x803.png 1536w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&nbsp;Cecil&nbsp;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor.</p>\n\n\n\n<p>De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la polyphonie et associant différents rythmes pour créer un son à la fois chaotique et précis. Sa musique a été révolutionnaire, formant de l&rsquo;ordre dans le désordre et de l&rsquo;harmonie dans la dissonance.</p>\n\n\n\n<p>Cet esprit anime WordPress 6.8. Adoptez ses nouvelles fonctionnalités audacieuses avec la même curiosité et la même expérimentation qui ont défini la création musicale de Cecil.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.8&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 peaufine et optimise les outils que vous utilisez au quotidien, ce qui rend votre site plus rapide, plus sécurisé et plus facile à gérer. Le guide de styles propose désormais une mise en page structurée et fonctionne avec les thèmes classiques, vous offrant ainsi un meilleur contrôle sur les styles globaux. Le chargement spéculatif accélère la navigation en préchargeant les liens avant même que les internautes n&rsquo;y accèdent, tandis que le hachage <code>bcrypt</code> renforce automatiquement la sécurité des mots de passe. En coulisses, les optimisations de la base de données améliorent les performances, et un nouveau système d&rsquo;alerte de sécurité permet de prévenir les vulnérabilités avant qu&rsquo;elles ne deviennent problématiques.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.8 «&nbsp;Cecil&nbsp;» en français (ZIP – 20 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Une version peaufinée à la perfection</h2>\n\n\n\n<p>WordPress 6.8 améliore et affine les outils que vous utilisez tous les jours, rendant votre site plus rapide, plus sûr et plus facile à gérer.</p>\n\n\n\n<p>Le guide de styles a maintenant une mise en page structurée et fonctionne désormais avec les thèmes classiques, ce qui vous apporte plus de contrôle sur les styles globaux de votre site.</p>\n\n\n\n<p>Le chargement spéculatif accélère la navigation en préchargeant les liens avant que les internautes ne naviguent vers ceux-ci, tandis que le hachage via bcrypt renforce automatiquement la sécurité des mots de passe.</p>\n\n\n\n<p>Parallèlement, des optimisations de la base de données améliorent les performances, et un nouveau système d’avertissement de sécurité aide à prévenir les vulnérabilités avant qu’elles ne deviennent un problème.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Le guide de style fait peau neuve et s’enrichit de quelques nouvelles fonctionnalités</h3>\n\n\n\n<p>Le guide de styles présente une nouvelle mise en page structurée et des libellés plus clairs, pour faciliter encore plus la modification des couleurs, de la typographie et de presque tous les styles de votre site, en un seul endroit.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-01.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png\" alt=\"\" class=\"wp-image-3339\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-01-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-01-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-01.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de l’éditeur</h3>\n\n\n\n<p>Visualisez plus facilement vos options dans les vues de données et excluez les publications épinglées de la boucle de requête. De plus, l’éditeur propose de nombreuses améliorations qui simplifient la création de contenu.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-02.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png\" alt=\"\" class=\"wp-image-3340\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-02-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-02-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-02.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Chargement quasi instantané des pages, grâce au chargement spéculatif</h3>\n\n\n\n<p>Dans WordPress 6.8, les pages se chargent plus rapidement que jamais. Lorsque vous ou tout internaute survolez ou cliquez sur un lien, WordPress peut précharger la page suivante pour une expérience plus fluide et quasi instantanée. Le système équilibre vitesse et efficacité, et vous pouvez contrôler son fonctionnement avec une extension ou votre propre code. Cette fonctionnalité fonctionne uniquement dans les navigateurs modernes&nbsp;; les anciens l’ignoreront simplement sans aucun impact.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-03.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png\" alt=\"\" class=\"wp-image-3341\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-03-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-03-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-03.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité renforcée des mots de passe avec bcrypt</h3>\n\n\n\n<p>Les mots de passe sont désormais plus difficiles à déchiffrer grâce au hachage bcrypt, qui nécessite beaucoup plus de puissance de calcul pour être cassé. Cela renforce la sécurité globale, tout comme d‘autres améliorations de chiffrement dans WordPress. Vous n’avez rien à faire&nbsp;: tout se met à jour automatiquement.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-04.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png\" alt=\"\" class=\"wp-image-3342\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-04-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-04-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-04.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 100 correctifs et améliorations en matière d’accessibilité touchent un large champ de l’expérience WordPress. Cette version inclut des correctifs pour chaque thème natif, des améliorations de la gestion des menus de navigation, de l’outil de personnalisation, et un étiquetage simplifié. L’éditeur de blocs bénéficie de plus de 70 améliorations concernant les blocs, les vues de données, et l’expérience globale des utilisateurs et utilisatrices.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Allégement de la base de données</h3>\n\n\n\n<p>Le travail se poursuit sur l‘optimisation de la génération des clés de cache dans la classe&nbsp;<code>WP_Query</code>. L‘objectif est, comme toujours, d‘améliorer les performances de votre site, dans ce cas en réduisant davantage la charge de votre base de données. Cela est particulièrement utile si vous avez beaucoup de trafic.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress&nbsp;6.8 propose de nombreuses corrections et améliorations de performances pour accélérer l’ensemble de votre site, de l’administration aux temps de chargement ressentis par les personnes qui visitent votre site. Au-delà du chargement spéculatif désormais intégré nativement, WordPress&nbsp;6.8 accorde une attention particulière à l’éditeur de blocs, à l’enregistrement des types de blocs et à la mise en cache des requêtes. N’attendez jamais plus de 50&nbsp;millisecondes entre chaque interaction. Dans WordPress&nbsp;6.8, l’API de gestion de l’interactivité constitue un premier pas vers cet objectif.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.8</h2>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.8, vous pouvez <a href=\"https://wordpress.org/download/releases/6-8/\">consulter le site de démonstration des fonctionnalités (en anglais)</a>.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em><bdo lang=\"en\" dir=\"ltr\">Learn WordPress</bdo></em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Learn</bdo></em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;évènements interactifs&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Notes de version de WordPress 6.8</h4>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-8/\">Lisez les notes de version de WordPress 6.8</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Guide technique de WordPress 6.8 en français</h4>\n\n\n\n<p><a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">Explorez le guide des changements techniques de WordPress 6.8</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.8</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Responsable des performances :&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.8 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 70 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 250 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.8 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div class=\"wp-block-group alignwide is-style-default is-content-justification-left is-nowrap is-layout-flex wp-container-core-group-is-layout-fc9f69e7 wp-block-group-is-layout-flex\">\n<p class=\"has-dark-blueberry-color has-lemon-3-background-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-70a077000b3aff2481eb0decd1e70b5e\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Atsé</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lysý</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">Mário Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/rseigel/\">rseigel</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">Ty</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria – a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.8 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.8 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.8 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/fxbenard\">FX Benard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mumuu000\">mumuu000</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rodrigoq\">rodrigoq</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/translationsbyautomattic\">Translations by Automattic</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> et <a href=\'https://profiles.wordpress.org/nlegagneur/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nlegagneur</a> pour leur relecture.</p>\n\n\n\n<p><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/03/28/guide-des-changements-techniques-de-wordpress-6-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Mar 2025 07:53:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Découvrez les changements techniques qui arrivent le 15 avril 2025 avec la version 6.8 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:35094:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"2156\" height=\"1084\" src=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3312\" srcset=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png 2156w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-2048x1030.png 2048w\" sizes=\"auto, (max-width: 2156px) 100vw, 2156px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">6–9 minutes</div></div>\n\n\n\n<p>WordPress 6.8 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 170 corrections de bogues</a>. Cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">34 sur l’accessibilité</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">16 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de la version 6.8 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">43 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">387 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">525 corrections de bogues</a>&nbsp;et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">70 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-37003aee4fdc33a177f14a048ba187af\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.8, dont la sortie est prévue le 15 avril 2025.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-pomegrade-1-color has-text-color has-link-color wp-elements-25a8d26d528a99d7724a8a001a372b5a\"><a href=\"https://make.wordpress.org/core/6-8/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.8</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>Une vaste gamme d&rsquo;améliorations concerne les performances, l&rsquo;expérience de développement et l’interface d&rsquo;édition générale. Cette version introduit de nouveaux outils comme le filtre <code>should_load_block_assets_on_demand</code> pour optimiser le chargement des ressources, un système d&rsquo;avertissement utilisable lorsque vous employez <code>useSelect</code>, et un système d&rsquo;enregistrement des blocs plus efficace. Elle contient aussi une mise à jour des outils de design disponibles pour chaque bloc, affine les composants de l&rsquo;interface et propose une série de changements divers qui améliorent la cohérence et l&rsquo;extensibilité de l&rsquo;éditeur. Ces changements contribuent à un flux de travail de développement plus fluide et à un environnement d&rsquo;édition plus adaptatif.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performances et chargement des ressources</h3>\n\n\n\n<p>De nouveaux outils aident les développeuses et les développeurs à créer des expériences d&rsquo;utilisation des blocs plus performantes. Un avertissement dans le crochet <code>useSelect</code> alerte lorsque les sélecteurs sont définis en ligne, un problème courant qui peut entraîner un recalcul du rendu inutile. Le filtre <code>should_load_block_assets_on_demand</code> offre un contrôle précis sur le fait que les ressources de bloc soient mises en file d&rsquo;attente globalement ou uniquement en cas de besoin, ce qui permet de réduire le CSS et le JavaScript inutilisés sur l&rsquo;interface <em>front</em>. Tous ces changements favorisent des flux de travail de développement plus efficaces et optimisés.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fhFlkFOCIl\"><a href=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/\">Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/embed/#?secret=450zF7Nret#?secret=fhFlkFOCIl\" data-secret=\"fhFlkFOCIl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hB2FZegD7B\"><a href=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/\">New filter should_load_block_assets_on_demand in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New filter &lt;code&gt;should_load_block_assets_on_demand&lt;/code&gt; in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/embed/#?secret=YjASEVzB2H#?secret=hB2FZegD7B\" data-secret=\"hB2FZegD7B\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-and-design-tool-registration\">Gestion des blocs et outils de personnalisation disponibles pour chaque bloc</h3>\n\n\n\n<p>Les améliorations apportées à l&rsquo;enregistrement des blocs et à la visibilité des outils de conception simplifient le développement pour l&rsquo;éditeur de blocs. Une approche plus efficace de l&rsquo;enregistrement des types de blocs réduit la surcharge liée au chargement des métadonnées des blocs, en particulier dans les environnements comportant de nombreux blocs personnalisés. En complément, nous avons sorti une nouvelle version de la liste des outils de personnalisation disponibles pour chaque bloc afin d’indiquer&nbsp;<strong>pour chaque outil de personnalisation les blocs qui le prennent en charge</strong>, offrant ainsi aux développeur·euses une vision plus claire des options disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"a3N8ljSVe9\"><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More efficient block type registration in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/embed/#?secret=QzNxSOMj2W#?secret=a3N8ljSVe9\" data-secret=\"a3N8ljSVe9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DOAiQNo1bl\"><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.8 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/embed/#?secret=dsWOhWCruy#?secret=DOAiQNo1bl\" data-secret=\"DOAiQNo1bl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"editor-ui-and-component-updates\">Interface de l’éditeur et mise à jour des composants</h3>\n\n\n\n<p>Des modifications apportées à l&rsquo;interface de l&rsquo;éditeur améliorent la cohérence, la convivialité et l&rsquo;ergonomie des différents éléments qui le composent. Les mises à jour des composants d&rsquo;interface d&rsquo;utilisation de base, tels que les boutons et les principes de mise en page, alignent le style et les comportements sur la base du nouveau système de design de WordPress. D&rsquo;autres changements concernent une meilleure cohérence du balisage dans le bloc Navigation, une prévisualisation de contenu améliorée pour le bloc Groupe et une meilleure accessibilité pour les éléments d&rsquo;interface. Ces modifications contribuent à une expérience d&rsquo;édition plus soignée et prévisible.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hCtw3Sfz1F\"><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/embed/#?secret=wgcNFOWlm3#?secret=hCtw3Sfz1F\" data-secret=\"hCtw3Sfz1F\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KihoQxj7Gw\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/\">Miscellaneous Block Editor Changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/embed/#?secret=H0oRlXN4zs#?secret=KihoQxj7Gw\" data-secret=\"KihoQxj7Gw\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility\">Accessibilité</h2>\n\n\n\n<p>Un large éventail d&rsquo;améliorations de l&rsquo;accessibilité de WordPress arrive avec la version&nbsp;6.8&nbsp;: amélioration de la navigation, de la clarté du balisage et de la prise en charge des lecteurs d&rsquo;écran dans l&rsquo;ensemble de l&rsquo;éditeur de blocs&nbsp;; amélioration de la classe <code>.screen-reader-text</code> qui offre désormais un comportement de focus plus cohérent entre les composants&nbsp;; tandis que des dizaines d&rsquo;autres améliorations concernent les structures de menu, les libellés des blocs, les infobulles et la sémantique de l&rsquo;interface. Ces changements créent une expérience d’utilisation plus inclusive et rapprochent WordPress des meilleures pratiques en matière d&rsquo;accessibilité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"lLtdPQgH11\"><a href=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/\">Accessibility Improvements in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/embed/#?secret=ByVi2u33L9#?secret=lLtdPQgH11\" data-secret=\"lLtdPQgH11\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MY8vUHKQ6W\"><a href=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/\">Changes to the .screen-reader-text class in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the .screen-reader-text class in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/embed/#?secret=ip8giZeKP4#?secret=MY8vUHKQ6W\" data-secret=\"MY8vUHKQ6W\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"internationalization\">Internationalisation</h2>\n\n\n\n<p>Plusieurs améliorations ont été apportées aux outils et à l&rsquo;infrastructure d&rsquo;internationalisation afin d&rsquo;améliorer l&rsquo;expérience de traduction et de localisation. Les mises à jour comprennent l&rsquo;arrivée de nouvelles fonctions de traduction, des corrections de cohérence et une meilleure prise en charge des formes plurielles, ce qui facilite la création d&rsquo;extensions, de thèmes et d&rsquo;interfaces entièrement traduisibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NqvcibLyGF\"><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/embed/#?secret=NBUGYYmhDo#?secret=NqvcibLyGF\" data-secret=\"NqvcibLyGF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>De nouveaux outils et des conseils aident les développeurs et développeuses à créer des interfaces plus rapides. La fonctionnalité de chargement spéculatif utilise l&rsquo;API <code>Speculation Rules</code> pour précharger ou pré-afficher les cibles des liens de navigation, améliorant ainsi la performance perçue par les utilisateurs finaux lors du clic sur un lien. De plus, des modifications de l&rsquo;API <code>Interactivity</code> permettront d&rsquo;écrire du code <em>front-end</em> plus efficace et plus évolutif.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HRsy4J27Eb\"><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Speculative Loading in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/embed/#?secret=d8v7ZXJwkZ#?secret=HRsy4J27Eb\" data-secret=\"HRsy4J27Eb\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"49PtIbJHVl\"><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API best practices in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/embed/#?secret=CslBN8jmlU#?secret=49PtIbJHVl\" data-secret=\"49PtIbJHVl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"rest-api\">API REST</h2>\n\n\n\n<p>Les améliorations apportées à l&rsquo;API REST étendent sa flexibilité et son utilité pour les applications WordPress <em>headless</em> et découplées. Un nouveau filtre, <code>rest_menu_read_access</code>, permet aux développeur·euses de contrôler l&rsquo;accès public aux menus de navigation, aux éléments de menu et aux emplacements de menu via l&rsquo;API REST. Ce changement permet un contrôle plus précis des données de menu exposées via l&rsquo;API, ce qui permet de prendre en charge une gamme plus large de cas d&rsquo;utilisation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eCrEpoAbgB\"><a href=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/\">New REST API Filter for Exposing Menus Publicly in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New REST API Filter for Exposing Menus Publicly in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/embed/#?secret=TmRv4OhCL7#?secret=eCrEpoAbgB\" data-secret=\"eCrEpoAbgB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"security\">Sécurité</h2>\n\n\n\n<p>La sécurité des mots de passe a été renforcée grâce à l&rsquo;introduction de <code>bcrypt</code> comme nouvel algorithme de hachage par défaut. Ce changement modernise le stockage des mots de passe de WordPress, offrant une meilleure résistance aux attaques par force brute et s&rsquo;alignant sur les meilleures pratiques actuelles de l&rsquo;industrie. Les mots de passe existants restent valides et seront re-hachés avec <code>bcrypt</code> lors de la prochaine connexion réussie de l&rsquo;utilisateur·ice.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qVqP1W6BMg\"><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.8 will use bcrypt for password hashing&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/embed/#?secret=avMfXAbxDn#?secret=qVqP1W6BMg\" data-secret=\"qVqP1W6BMg\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>Un ensemble de modifications plus petites améliore la cohérence, l&rsquo;extensibilité et l&rsquo;expérience de développement générale. Ces changements couvrent divers domaines du cœur WordPress, notamment la gestion des médias, le rendu de certains codes courts (<em>shortcodes</em>), l&rsquo;enregistrement des types de publications, la gestion des thèmes. Bien qu&rsquo;individuellement mineures, ces modifications reflètent les efforts continus pour moderniser notre CMS.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6yMViHGi0o\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/\">Miscellaneous developer changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/embed/#?secret=8nTjG46eRo#?secret=6yMViHGi0o\" data-secret=\"6yMViHGi0o\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 offre encore bien davantage&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">170 bogues</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">21 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">clôturés dans WordPress 6.8</a>.&nbsp; Cette version va par exemple permettre d&rsquo;afficher les nouveaux emojis de la version 15.1 de la bibliothèque Twemoji pour les internautes qui ne peuvent pas les afficher nativement dans leur navigateur (exemple de nouvel emoji&nbsp;: <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f426-200d-1f525.png\" alt=\"🐦‍🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />).</p>\n\n\n\n<p>Voici quelques modifications notables&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remplacement des chaînes « Add New {Item} » par « Add {Item} » partout sur l&rsquo;administration (<a href=\"https://core.trac.wordpress.org/ticket/61219\">ticket #61219</a>)</li>\n\n\n\n<li>Amélioration des chaînes traduisibles sur le thème Twenty Twenty-Five (<a href=\"https://core.trac.wordpress.org/ticket/62482\">ticket #62482</a>)</li>\n\n\n\n<li>Thèmes natifs&nbsp;: amélioration de l&rsquo;accessibilité du lien du titre du site (<a href=\"https://core.trac.wordpress.org/ticket/62895\">ticket #62895</a>)</li>\n\n\n\n<li>Gestion des dates&nbsp;: les réglages des dates obtiennent deux nouvelles options, <code>j.n.Y</code> et <code>d.m.Y</code> (<a href=\"https://core.trac.wordpress.org/ticket/55685\">#55685</a>)</li>\n\n\n\n<li>Contenus embarqués&nbsp;: ajout de Canva en tant que fournisseur oEmbed (<a href=\"https://core.trac.wordpress.org/ticket/58840\">ticket #58840</a>)</li>\n\n\n\n<li>API des métadonnées&nbsp;: renommage de l’action <code>setted_transient</code>&nbsp;en&nbsp;<code>set_transient</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/62849\">ticket #62849</a>)</li>\n\n\n\n<li>API REST&nbsp;: gestion des barres obliques de fin de chaînes dans&nbsp;<code>rest_preload_api_request</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/57048\">ticket #57048</a>)</li>\n\n\n\n<li>Sécurité&nbsp;: assurance explicite du caractère requis du module PHP&nbsp;<code>hash</code>&nbsp;et ajout de vérifications des prérequis lors de l&rsquo;installation et de la mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/56017\">ticket #56017</a>)</li>\n\n\n\n<li>Mises à jour&nbsp;: suppression d&rsquo;une vérification inutile lors de la vérification des mises à jour lorsque la donnée est à jour (<a href=\"https://core.trac.wordpress.org/ticket/44118\">ticket #44118</a>)</li>\n\n\n\n<li>Widgets&nbsp;: ajout de la prise en charge des types de publications dans la fonction&nbsp;<code>get_calendar()</code>. Ces modifications introduisent également un nouveau filtre&nbsp;<code>get_calendar_args</code> (<a href=\"https://core.trac.wordpress.org/ticket/34093\">ticket #34093</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.8 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.8.0/\">https://developer.wordpress.org/reference/since/6.8.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-b65007937b1cf3a6c667456985c6a68f is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%);padding-top:1em;padding-bottom:1em\">\n<p class=\"is-style-serif has-black-color has-text-color has-link-color wp-elements-acf16339b7757858691a26a725321228\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.8</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">Field Guide&nbsp;de WP 6.8 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci <a href=\'https://profiles.wordpress.org/clementpolito/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clementpolito</a>, <a href=\'https://profiles.wordpress.org/rainbowgeek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rainbowgeek</a>, <a href=\'https://profiles.wordpress.org/reskatorfr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>reskatorfr</a>, <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28154:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"UyWJ3kHEmz\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=tSMGBJfYjQ#?secret=UyWJ3kHEmz\" data-secret=\"UyWJ3kHEmz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jF8mPpPXlS\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=LyXnzsvvCL#?secret=jF8mPpPXlS\" data-secret=\"jF8mPpPXlS\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"G8lRmWqAor\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=J4XDYs3pSJ#?secret=G8lRmWqAor\" data-secret=\"G8lRmWqAor\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h00792iEep\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=TCajqUjanO#?secret=h00792iEep\" data-secret=\"h00792iEep\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"obfs4hTFIv\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=3D3EUMW9w6#?secret=obfs4hTFIv\" data-secret=\"obfs4hTFIv\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Mh1YE1VTiU\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ViTZEpwoUq#?secret=Mh1YE1VTiU\" data-secret=\"Mh1YE1VTiU\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5T9ubgS9pA\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=45jLTa4za3#?secret=5T9ubgS9pA\" data-secret=\"5T9ubgS9pA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"N7suow7aP5\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=XXyFFljgkB#?secret=N7suow7aP5\" data-secret=\"N7suow7aP5\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"64ynOvr7Ew\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=6Cxd5rFVoy#?secret=64ynOvr7Ew\" data-secret=\"64ynOvr7Ew\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kbJtxPGfqW\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=34UZ0w1coA#?secret=kbJtxPGfqW\" data-secret=\"kbJtxPGfqW\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hQXSqWJGem\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=eFPqVd4tTO#?secret=hQXSqWJGem\" data-secret=\"hQXSqWJGem\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8oQC5S3C02\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=XzjPRUchA9#?secret=8oQC5S3C02\" data-secret=\"8oQC5S3C02\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7r05WrUm18\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=wpQMBPVn0N#?secret=7r05WrUm18\" data-secret=\"7r05WrUm18\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fmwVz6LB0l\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=rHnFsEBoL1#?secret=fmwVz6LB0l\" data-secret=\"fmwVz6LB0l\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zeZlu13TM1\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=9ECwfO9e5P#?secret=zeZlu13TM1\" data-secret=\"zeZlu13TM1\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.6 « Dorsey »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:40:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3181\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:68957:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/dorsey.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"680\" src=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png\" alt=\"\" class=\"wp-image-3199\" srcset=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang=\"en\" dir=\"ltr\">leader</bdo> de <bdo lang=\"en\" dir=\"ltr\">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang=\"en\" dir=\"ltr\">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/color-palettes.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Aperçu rapide des pages</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/page-previews.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/feature-rollbacks.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Surcharges</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/overrides.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href=\"https://fr.wordpress.org/download/releases/6-6/\">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-6/\">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.6</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;</li>\n\n\n\n<li>Responsables de la documentation&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction artistique : <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Responsable des performances&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n\n\n\n<li>Responsables des tests&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.6 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>630 personnes provenant d’au moins 50 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 150 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.6 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p style=\"font-size:10px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h1 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress 6.6 en français</h1>\n\n\n\n<p>WordPress est un projet international et la version 6.6 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.6 en français :</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">laeti972</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/nlangle\">Nicolas Langle</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/valer1e\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>, et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 08 Dec 2025 10:18:33 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 02 Dec 2025 21:58:55 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1765232314;s:23:\"__cache_expiration_time\";i:1765232314;}", "off");
INSERT INTO `wp_options` VALUES("853", "_transient_timeout_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "1765232315", "off");
INSERT INTO `wp_options` VALUES("854", "_transient_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://fluxplanet.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://fluxplanet.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2025-12-08T10:18:15+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wpfr.net/wpfr-lance-ses-permanences-associatives-mensuelles/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPFR lance ses permanences associatives mensuelles\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:68:\"https://wpfr.net/wpfr-lance-ses-permanences-associatives-mensuelles/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-02T15:45:50.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-02T15:45:50.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"Tu fais partie de l’association WordPress Francophone, mais tu ne sais pas trop ce qui s’y passe concrètement ? Tu n’es pas seul·e ! La communication est l’un de nos chantiers et pour la développer, on se lance avec cette première initiative que l’on nommera sobrement : les permanences associatives mensuelles de WPFR. Comment çaLire la suite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:2667:\"\n        \n<p>Tu fais partie de l&rsquo;association WordPress Francophone, mais tu ne sais pas trop ce qui s&rsquo;y passe concrètement ? Tu n&rsquo;es pas seul·e !</p>\n\n\n\n<p>La communication est l&rsquo;un de nos chantiers et pour la développer, on se lance avec cette première initiative que l&rsquo;on nommera sobrement : <strong>les permanences associatives mensuelles de WPFR.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"comment-ca-marche\">Comment ça marche ?</h2>\n\n\n\n<p>C&rsquo;est un rendez-vous convivial ouvert à toutes les personnes membres, qu&rsquo;elles soient adhérentes depuis des années ou nouvellement arrivées.</p>\n\n\n\n<p>L&rsquo;idée ? D&rsquo;un côté, plusieurs membres actifs viennent expliquer ce que l&rsquo;on fait (projets en cours, besoins, urgences du moment, idées). De l&rsquo;autre, on laisse la parole aux membres pour mieux découvrir leur asso : libre à toi de poser tes questions, partager tes idées ou des retours au sujet de WordPress Francophone.</p>\n\n\n\n<p><strong>Côté format, on reste simple :</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Rapide tour de table pour celles et ceux qui le souhaitent</li>\n\n\n\n<li>Point sur l&rsquo;actualité de l&rsquo;asso</li>\n\n\n\n<li>Focus sur un groupe de travail ou un projet</li>\n\n\n\n<li>Échanges libres et questions</li>\n</ul>\n\n\n\n<p>Pas besoin d&rsquo;être technique ou expert·e pour participer ! Une synthèse sera partagée après chaque session sur notre Slack communautaire.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"on-commence-le-lundi-8-decembre\">On commence le lundi 8 décembre !</h2>\n\n\n\n<p>La première permanence aura lieu <strong>lundi 8 décembre</strong> à 13h pour 1 heure.</p>\n\n\n\n<p><strong>Pas dispo lundi prochain, pas de soucis ce sera tous les mois : tu peux déjà noter l’échéance du 12 janvier 2026 (toujours à 13h) dans ton calendriers.</strong></p>\n\n\n\n<p>On te communiquera le lien de visio par email et sur Slack. Viens faire un tour, même juste pour écouter sans intervenir. On a hâte d&rsquo;échanger avec tout le monde ! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f64c.png\" alt=\"🙌\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p>\n\n\n\n<p class=\"has-pale-cyan-blue-background-color has-background\"><em><strong>Pour les membres de l&rsquo;asso : une question ? <s>3615 WPFR</s> On en parle sur le Slack de l&rsquo;association dans le canal #accueil-membres.</strong></em></p>\n\n\n\n<p><em>Si tu n&rsquo;es pas encore membre de l&rsquo;association : il est toujours temps de nous rejoindre <a href=\"https://wpfr.net/devenir-adherent/\">en adhérant à l&rsquo;association sur cette page</a> !</em></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jason Rouet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpfr.net/actualites/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wpmarmite.com/briefly-unavailable-for-scheduled-maintenance-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Comment corriger l’erreur WordPress « Briefly unavailable for scheduled maintenance. Check back in a minute. »\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:78:\"https://wpmarmite.com/briefly-unavailable-for-scheduled-maintenance-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-02T08:00:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-02T08:00:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:447:\"Un fond gris. Un encadré blanc. Et à l’intérieur, ce message mystérieux : « Briefly unavailable for scheduled maintenance. Check back in a minute. » Voilà qui s’affiche sur votre écran après avoir lancé une mise à jour sur votre...\nComment corriger l’erreur WordPress « Briefly unavailable for scheduled maintenance. Check back in a minute. » est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:795:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2025/04/erreurs-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Erreur WordPress\" //></p>\n<p>Un fond gris. Un encadré blanc. Et à l’intérieur, ce message mystérieux : « Briefly unavailable for scheduled maintenance. Check back in a minute. » Voilà qui s’affiche sur votre écran après avoir lancé une mise à jour sur votre...</p>\n<p><a href=\"https://wpmarmite.com/briefly-unavailable-for-scheduled-maintenance-wordpress/\">Comment corriger l’erreur WordPress « Briefly unavailable for scheduled maintenance. Check back in a minute. »</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Équipe WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://blog.o2switch.fr/sortie-wordpress-6-9-nouveautes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Sortie de WordPress 6.9 : les nouveautés à connaître avant la mise à jour\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:57:\"https://blog.o2switch.fr/sortie-wordpress-6-9-nouveautes/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-24T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-24T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"WordPress 6.9 apporte un éditeur plus clair, de nouveaux blocs natifs et plusieurs améliorations techniques. Voici l’essentiel à connaître avant la mise à jour.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:181:\"\n        WordPress 6.9 apporte un éditeur plus clair, de nouveaux blocs natifs et plusieurs améliorations techniques. Voici l’essentiel à connaître avant la mise à jour.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://yesweblog.fr/10-usages-concrets-et-strategiques-pour-maitriser-wordpress-avec-lintelligence-artificielle/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"10 Usages Concrets et Stratégiques pour Maîtriser WordPress avec l’intelligence Artificielle\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:113:\"https://yesweblog.fr/10-usages-concrets-et-strategiques-pour-maitriser-wordpress-avec-lintelligence-artificielle/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-22T07:05:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-22T07:05:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:486:\"Nouvel Article\nLe paysage numérique évolue à une vitesse fulgurante. L’intégration de l’Intelligence Artificielle (IA) dans nos outils quotidiens n’est plus une perspective futuriste, mais une réalité qui touche le cœur même des plateformes de gestion de contenu. Pour les utilisateurs de WordPress, le CMS qui propulse plus de 43% du Web, cette intégration représente un levier […]\n- Yes We Blog ! - Webmaster WordPress - Griselidis Gaillet - Conceptrice de sites web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:573:\"\n        <p>Nouvel Article</p>\n<p>Le paysage numérique évolue à une vitesse fulgurante. L&#8217;intégration de l&#8217;Intelligence Artificielle (IA) dans nos outils quotidiens n&#8217;est plus une perspective futuriste, mais une réalité qui touche le cœur même des plateformes de gestion de contenu. Pour les utilisateurs de WordPress, le CMS qui propulse plus de 43% du Web, cette intégration représente un levier [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Webmaster WordPress - Griselidis Gaillet - Conceptrice de sites web</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Griselidis Gaillet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/benchmark-hosterra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Hosterra – Test de performance pour WordPress, Benchmark\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:40:\"https://holdmywp.com/benchmark-hosterra/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-20T11:09:32.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-20T11:09:32.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"Pour un avoir un aperçu clair des performances réelles d\'un hébergement Hosterra, j\'ai testé chaque offre avec l\'outil Hosting Benchmark Tools.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:16952:\"\n        \n<p>Hosterra est un hébergeur que j&rsquo;ai découvert au <a href=\"https://bretagne.wordcamp.org/2024/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Wordcamp Bretagne\">Wordcamp Bretagne</a> à Rennes en 2024, où j&rsquo;ai rencontré <a href=\"https://pierre.lannoy.fr/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Pierre Lannoy\">Pierre Lannoy</a> qui venait nous parler <a href=\"https://wordpress.tv/2024/11/02/dites-non-au-green-washing-hebergez-reellement-ecoresponsable/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"d\'hébergement écoresponsable\">d&rsquo;hébergement écoresponsable</a>. Aujourd&rsquo;hui, Hosterra est l&rsquo;hébergeur que je recommande à mes clients et avec lequel je travaille pour <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">mon service de maintenance et d&rsquo;hébergement WordPress</a>.</p>\n\n\n\n<p>Une seule offre d&rsquo;hébergement web testée ici pour le moment, celle que j&rsquo;utilise : l&rsquo;<strong>hébergement mutualisé Hosterra</strong>. Pour un avoir un aperçu clair des performances réelles, j&rsquo;ai testé l&rsquo;offre avec l&rsquo;outil <strong>Hosting Benchmark Tools</strong>. Comme pour les <a href=\"https://holdmywp.com/hebergement-wordpress/\" title=\"Hébergement WordPress\">autres benchmarks réalisés</a>, l&rsquo;instance WordPress testée est vierge avec le même thème, les mêmes extensions et seule sur son hébergement.</p>\n\n\n\n<p>La promesse : <a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"un hébergement performant et écoresponsable\"><em>un hébergement performant et tout en étant écoresponsable</em></a>. Voyons ça.</p>\n\n\n<h2 class=\"wp-block-heading\" id=\"approche-et-methodologie-devaluation-dun-hebergement-wordpress\">Approche et méthodologie d&rsquo;évaluation d&rsquo;un hébergement WordPress</h2>\n\n<h3 class=\"wp-block-heading\" id=\"objectif\">Objectif</h3>\n\n\n<p>Cette publication n&rsquo;est pas une énième copie des listes de caractéristiques longues comme le bras affichées sur les pages de vente des hébergeurs, mais un focus sur ce qui compte pour faire un <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">bon hébergement WordPress</a> : <strong>Performance</strong>, <strong>Efficience</strong>, <strong>Robustesse</strong>.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"unites-de-mesure\">Unités de mesure</h3>\n\n\n<p>Soyons honnêtes, quels que soient les hébergeurs, c&rsquo;est toujours la guerre des gros chiffres, quand on compare les offres, on jongle entre les Bytes, les Octets et les Bits (C&rsquo;est assez classique sur l&rsquo;affichage de la bande passante). Sur cette publication en français, <strong>je convertis les valeurs en Octets</strong> pour éviter les confusions.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"renouvellement\">Renouvellement</h3>\n\n\n<p>Les tarifs affichés reflètent le coût annuel en cas de renouvellement standard, sans tenir compte des promotions ponctuelles ou des réductions d’entrée. L&rsquo;objectif ici étant d’évaluer le coût réel de l’<strong>hébergement</strong> sur le moyen et long terme, après la première année. En optant pour un engagement pluriannuel (2, 3 ans ou plus), certains hébergeurs proposent des tarifs mensuels réduits, ce qui peut diminuer le coût global sur la durée. Le tarif annuel TTC indiqué, correspond dans cet article à un renouvellement effectué une fois par an.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"consommation-annoncee-efficacite-energetique\">Consommation annoncée / efficacité énergétique</h3>\n\n\n<p>Les hébergeurs web communiquent de plus en plus sur leurs <strong>démarches écologiques</strong>. Entre les promesses de compensation carbone, les datacenters « verts », les labels et touti quanti&#8230; on tombe vite dans le <strong>greenwashing</strong>. Les annonces se concentrent souvent sur l’empreinte carbone, l’utilisation d’énergies renouvelables ou l’optimisation des infrastructures, mais rarement sur l’impact réel d’un hébergement web au quotidien. <strong>Corréler les performances mesurées sur une instance WordPress avec sa consommation en eau et électricité</strong> (bien entendu, non produite par des énergies fossiles) me semble une bonne approche.</p>\n\n\n\n<div class=\"wp-block-group has-border-color has-yellow-border-color has-fg-2-color has-bg-1-background-color has-text-color has-background has-link-color has-small-font-size wp-elements-b292714650cbbe2c27f65af0a6b0ee6b has-global-padding is-layout-constrained wp-container-core-group-is-layout-52009084 wp-block-group-is-layout-constrained\" style=\"border-width:1px;border-radius:2px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><h4 class=\"wp-block-heading has-yellow-color has-text-color has-link-color wp-elements-1b6bd9551751042e5dbe4a9ce2cfa726\" id=\"a-propos-de-la-consommation-annoncee\"><strong>À propos de la consommation annoncée</strong></h4>\n\n\n<p class=\"has-link-color wp-elements-cdee002ef592420c9270a4ab43045d7a\">L&rsquo;hébergement étant mutualisé, les ressources sont partagées entre plusieurs instances. La consommation indiquée correspond à celle de l&rsquo;ensemble du serveur, qu&rsquo;elle soit utilisée seule ou partagée avec d&rsquo;autres comptes. En raison des ressources importantes du serveur, la consommation annuelle annoncée est plus élevée que <a href=\"https://hosterra.eu/fr/store/web-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"celle des VPS\">celle des VPS</a>. Il revient donc à Hosterra de gérer le nombre de comptes par serveur afin d&rsquo;optimiser l&rsquo;utilisation des ressources tout en maintenant de bonnes performances.</p>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"instance-wordpress-testee\">Instance WordPress testée</h3>\n\n\n<p>Un <strong>site WordPress</strong> sur une formule d&rsquo;hébergement web.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Thème installé actif : <a href=\"https://wordpress.org/themes/generatepress/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"GeneratePress\">GeneratePress</a>.</li>\n\n\n\n<li>Extensions actives : <a href=\"https://wordpress.org/plugins/wpbenchmark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Hosting Benchmark tool\">Hosting Benchmark tool</a> et <a href=\"https://wordpress.org/plugins/sqlite-object-cache/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"SQLite Object Cache\">SQLite Object Cache</a>.</li>\n\n\n\n<li>Cache objet testé : <a href=\"https://www.php.net/manual/fr/book.apcu.php\" target=\"_blank\" rel=\"noopener nofollow\" title=\"APCu\">APCu</a>.</li>\n\n\n\n<li>PHP : 8.3</li>\n</ul>\n\n\n<h2 class=\"wp-block-heading\" id=\"glossaire\">Glossaire</h2>\n\n\n<p>Petit <strong>glossaire</strong> de base du jargon des <strong>hébergeurs web</strong>.</p>\n\n\n\n<details id=\"glossaire\" class=\"wp-block-details relative has-border-color has-bg-2-border-color has-bg-0-color has-fg-0-background-color has-text-color has-background has-link-color has-medium-font-size wp-elements-6ed834d03b843f14565b81a28df5af88 is-layout-flow wp-container-core-details-is-layout-8a368f38 wp-block-details-is-layout-flow\" style=\"border-width:1px\" open><summary>Consulter le glossaire</summary>\n<div class=\"wp-block-group has-fg-1-color has-bg-1-background-color has-text-color has-background has-link-color has-small-font-size wp-elements-9c7e403135cbcea857d775f42012469b has-global-padding is-layout-constrained wp-container-core-group-is-layout-5bc31a47 wp-block-group-is-layout-constrained\" style=\"border-top-color:var(--wp--preset--color--bg-2);border-top-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--50)\">\n<ul class=\"wp-block-list\">\n<li><strong>RAM</strong> : Mémoire vive permettant de stocker temporairement les données utilisées par les applications pour un accès rapide.</li>\n\n\n\n<li><strong>CPU</strong> : Unité centrale de traitement, le cerveau du serveur qui exécute les instructions et traite les données.</li>\n\n\n\n<li><strong>vCPU</strong> : CPU virtuel, partie d’un processeur physique allouée à une machine virtuelle pour simuler un processeur dédié.</li>\n\n\n\n<li><strong>NVMe</strong> : Protocole de stockage haute performance pour les disques SSD, optimisé pour réduire la latence et augmenter le débit.</li>\n\n\n\n<li><strong>IO</strong> : Entrées/Sorties (Input/Output), mesure la capacité du serveur à lire/écrire des données sur le disque ou le réseau.</li>\n\n\n\n<li><strong>Bande passante</strong> : Volume maximal de données transférables entre le serveur et les utilisateurs sur une période donnée, souvent exprimé en Gbit/s ou Mo/s.</li>\n\n\n\n<li><strong>Hébergement mutualisé</strong> : Solution où plusieurs sites partagent les ressources d’un même serveur.</li>\n\n\n\n<li><strong>Hébergement VPS</strong> : Serveur privé virtuel offrant des ressources dédiées (CPU, RAM, stockage) au sein d’un serveur physique partagé.</li>\n</ul>\n</div>\n</details>\n\n\n<h2 class=\"wp-block-heading\" id=\"offre-dhebergement-testee\">Offre d&rsquo;hébergement testée</h2>\n\n<h3 class=\"wp-block-heading\" id=\"hosterra-one\">Hosterra One</h3>\n\n<h4 class=\"wp-block-heading\" id=\"informations-sur-loffre\">Informations sur l&rsquo;offre</h4>\n\n\n<ul class=\"wp-block-list\">\n<li>Type d&rsquo;hébergement : Mutualisé</li>\n\n\n\n<li>Tarif au renouvellement annuel (1 mois gratuit inclus) : 75,9€ HT | <strong> 91,08 € TTC</strong></li>\n\n\n\n<li>Consommation annuelle annoncée : <strong>⚡️Électricité &lt; 200 kWh/an</strong>, <strong>🫧Eau &lt; 6.5 l/an</strong></li>\n</ul>\n\n\n<h4 class=\"wp-block-heading\" id=\"ressources-annoncees\">Ressources annoncées</h4>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc\"><table class=\"has-fixed-layout is-stacked-on-mobile\"><thead><tr><th>CPU</th><th>Mémoire vive</th><th>Stockage</th><th>Lecture/écriture</th><th>Bande passante</th></tr></thead><tbody><tr><td>8 vCPU</td><td>32 Go RAM</td><td>10 Go sur NVMe</td><td>I/O 256 Mo/s</td><td>125 Mo/s</td></tr></tbody></table></figure>\n\n\n<h4 class=\"wp-block-heading\" id=\"performances-mesurees\">Performances mesurées</h4>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc is-scroll-on-mobile\"><table class=\"\"><thead><tr><th>Type</th><th>Fonction</th><th style=\"width:80px\">Score /10</th><th>Temps / Vitesse</th></tr></thead><tbody><tr><td rowspan=\"5\">CPU &amp; Memory</td><td>Operations with large text data</td><td style=\"background-color:#299c29;color:#ffffff\">10</td><td>2.2 sec</td></tr><tr><td>Random binary data operations</td><td style=\"background-color:#7dc516;color:#ffffff\">8.17</td><td>7.2 sec</td></tr><tr><td>Recursive mathematical calculations</td><td style=\"color:#ffffff;background-color:#f88d36\">4.71</td><td>10.9 sec</td></tr><tr><td>Iterative mathematical calculations</td><td style=\"background-color:#299c29;color:#ffffff\">9.34</td><td>1.8 sec</td></tr><tr><td>Floating point operations</td><td style=\"color:#ffffff;background-color:#c3d519\">6.37</td><td>3.6 sec</td></tr><tr><td rowspan=\"3\">Filesystem</td><td>Filesystem write ability</td><td style=\"color:#ffffff;background-color:#81d519\">7.1</td><td>2.9 sec<br>~351 Mo/s</td></tr><tr><td>Local file copy and access speed</td><td style=\"color:#ffffff;background-color:#81d519\">7.79</td><td>2.9 sec<br>~350 Mo/s</td></tr><tr><td>Small file IO test</td><td style=\"color:#ffffff;background-color:#299c29\">9.82</td><td>0.2 sec<br>~473 Mo/s</td></tr><tr><td rowspan=\"3\">Database</td><td>Importing large amount of data to database</td><td style=\"color:#ffffff;background-color:#7dc516\">8.23</td><td>2.4 sec</td></tr><tr><td>Simple queries on single table</td><td style=\"color:#ffffff;background-color:#299c29\">9.54</td><td>0.9 sec</td></tr><tr><td>Complex database queries on multiple tables</td><td style=\"background-color:#81d519;color:#ffffff\">7.59</td><td>3.4 sec</td></tr><tr><td rowspan=\"4\">Object cache</td><td>Persistent object cache enabled</td><td style=\"background-color:#299c29;color:#ffffff\">10</td><td>0 sec</td></tr><tr><td>Persistent object cache write</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>0.5 sec</td></tr><tr><td>Persistent object cache read</td><td style=\"background-color:#81d519;color:#ffffff\">7.82</td><td>9.2 sec</td></tr><tr><td>Persistent object cache mixed usage</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>1.3 sec</td></tr><tr><td rowspan=\"8\">WordPress core</td><td>Shortcode processing</td><td style=\"color:#ffffff;background-color:#81d519\">7.28</td><td>3.7 sec</td></tr><tr><td>WordPress Hooks</td><td style=\"color:#ffffff;background-color:#7dc516\">8.05</td><td>4.9 sec</td></tr><tr><td>WordPress option manipulation</td><td style=\"color:#ffffff;background-color:#299c29\">9.44</td><td>1.6 sec</td></tr><tr><td>REGEX string processing</td><td style=\"color:#ffffff;background-color:#7dc516\">8.2</td><td>4.6 sec</td></tr><tr><td>Taxonomy benchmark</td><td style=\"color:#ffffff;background-color:#81d519\">7.33</td><td>2.7 sec</td></tr><tr><td>Object capability benchmark</td><td style=\"color:#ffffff;background-color:#81d519\">7.03</td><td>3 sec</td></tr><tr><td>Content filtering</td><td style=\"color:#ffffff;background-color:#c3d519\">6.48</td><td>5 sec</td></tr><tr><td>JSON manipulations</td><td style=\"color:#ffffff;background-color:#7dc516\">8.71</td><td>2.1 sec</td></tr><tr><td>Network</td><td>Network download speed test</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>0.9 sec<br>~84 Mo/s</td></tr></tbody><tfoot><tr><td colspan=\"2\">Your server score</td><td colspan=\"2\" style=\"text-align:center;color:#ffffff;background-color:#7dc516\">8.2</td></tr></tfoot></table><figcaption style=\"padding:10px 0;text-align:center\">Tableau des performances mesurées sur l&rsquo;offre <a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Hosterra One\">Hosterra One</a> avec un cache objet APCu</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img width=\"1042\" height=\"1385\" src=\"https://holdmywp.com/wp-content/uploads/2025/11/benchmark-hosterra-one-min.webp\" alt=\"Capture d\'écran du test de mesure de performances sur l\'offre Hosterra One avec un cache objet APCu, le nom de domaine de l\'instance WordPress de test a été masqué.\" class=\"wp-image-6358\" //><figcaption class=\"wp-element-caption\">Capture d&rsquo;écran du test de mesure de performances sur l&rsquo;offre <strong>Hosterra One</strong> avec un cache objet <strong>APCu</strong>, le nom de domaine de l&rsquo;instance WordPress de test a été masqué.</figcaption></figure>\n\n\n<h2 class=\"wp-block-heading\" id=\"bilan-du-test\">Bilan du test</h2>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc is-scroll-on-mobile\"><table class=\"is-stacked-on-mobile\"><thead><tr><th>Offre</th><th>Type hébergement</th><th>Tarif annuel TTC</th><th>Consommation annuelle annoncée</th><th>Meilleur Score/10</th></tr></thead><tbody><tr><td>Hosterra One</td><td>Mutualisé</td><td>91,08 € TTC</td><td>⚡️&lt; 200 kWh/an<br>🫧&lt; 6.5 l/an</td><td style=\"background-color:#7dc516;color:#ffffff\">8.2</td></tr></tbody><tfoot><tr><td colspan=\"5\" style=\"text-align:center;font-size:14px\">Source des informations : Fournisseur d&rsquo;hébergement + résultats des tests ci-dessus.<br>Dernière mise à jour : novembre 2025.</td></tr></tfoot></table><figcaption style=\"text-align:center;padding-top:10px;padding-bottom:10px\">Tableau comparatif des offres<br>		d&rsquo;hébergement Hosterra : type d&rsquo;hébergement, Tarif annuel TTC, consommation annuelle annoncée,  Meilleur score obtenu sur 10</figcaption></figure>\n\n\n<h2 class=\"wp-block-heading\" id=\"sources\">Sources</h2>\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://hosterra.eu/fr/store/shared-hosting/</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/plugins/wpbenchmark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://wordpress.org/plugins/wpbenchmark/</a></li>\n\n\n\n<li><a href=\"https://wpbenchmark.io/improve-wordpress-speed/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://wpbenchmark.io/improve-wordpress-speed/</a></li>\n\n\n\n<li><a href=\"https://kinsta.com/fr/blog/hebergement-mutualise-vs-hebergement-dedie/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://kinsta.com/fr/blog/hebergement-mutualise-vs-hebergement-dedie/</a></li>\n\n\n\n<li><a href=\"https://datacampus.fr/2023/01/24/technologies-stockage-donnees/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://datacampus.fr/2023/01/24/technologies-stockage-donnees/</a></li>\n</ul>\n\n<p><a href=\"https://holdmywp.com/benchmark-hosterra/\">Source</a></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Quentin Le Duff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"HoldMyWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://kinsta.com/fr/blog/comment-gerer-pics-trafic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"3 façons de faire face à l’augmentation du trafic sans réduire ou mettre à niveau les plans d’accès\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:53:\"https://kinsta.com/fr/blog/comment-gerer-pics-trafic/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-18T12:34:04.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-18T12:34:04.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:317:\"Les pics de trafic ne sont pas réservés aux sites d’entreprise. Même une modeste boutique WooCommerce peut voir son trafic tripler à la suite d’une publicité, ...\nThe post 3 façons de faire face à l’augmentation du trafic sans réduire ou mettre à niveau les plans d’accès appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:466:\"\n        <p>Les pics de trafic ne sont pas réservés aux sites d&#8217;entreprise. Même une modeste boutique WooCommerce peut voir son trafic tripler à la suite d&#8217;une publicité, ...</p>\n<p>The post <a href=\"https://kinsta.com/fr/blog/comment-gerer-pics-trafic/\">3 façons de faire face à l&rsquo;augmentation du trafic sans réduire ou mettre à niveau les plans d&rsquo;accès</a> appeared first on <a href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joel Olawanle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://kinsta.com/fr/sujets/developpement-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://blog.o2switch.fr/ajouter-code-personnalise-wordpress-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Comment ajouter du code personnalisé dans WordPress (sans tout casser) en 2025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:66:\"https://blog.o2switch.fr/ajouter-code-personnalise-wordpress-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:264:\"Vous souhaitez ajouter un bout de code dans votre site WordPress sans risquer la fameuse page blanche ? Découvrez les bonnes pratiques pour personnaliser votre site en toute sécurité, avec les méthodes adaptées en 2025 : thème enfant, snippets et mu-plugins.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:278:\"\n        Vous souhaitez ajouter un bout de code dans votre site WordPress sans risquer la fameuse page blanche ? Découvrez les bonnes pratiques pour personnaliser votre site en toute sécurité, avec les méthodes adaptées en 2025 : thème enfant, snippets et mu-plugins.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://whodunit.consulting/des-contenus-plus-accessibles-avec-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Des contenus plus accessibles avec WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:73:\"https://whodunit.consulting/des-contenus-plus-accessibles-avec-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-30T08:28:27.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-30T08:28:27.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:316:\"Comment votre site pourrait être plus accessible que 95% des sites dans le monde ? Voilà cinq points sur lesquels vous améliorerez l’accessibilité de votre site en tirant parti de l’éditeur de WordPress.\nL’article Des contenus plus accessibles avec WordPress est apparu en premier sur Whodunit Consulting.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:20358:\"\n        <figure class=\"wp-block-post-featured-image\"><img width=\"1600\" height=\"960\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/contenus-accessibles-avec-wordpress.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover\" //></figure>\n\n\n<p class=\"is-style-text-chapo has-medium-font-size is-style-text-chapo--1\">L’accessibilité d’un site ne s’arrête pas à la livraison du code. Et publier un contenu accessible à tous et à toutes, c’est possible : voici quelques bonnes pratiques à adopter au moyen d’extensions ou de fonctionnalités déjà existantes dans l’éditeur de blocs de WordPress que vous ne connaissez peut-être pas encore.</p>\n\n\n\n<p class=\"is-style-text-chapo has-medium-font-size is-style-text-chapo--2\">Les critères du RGAA (Référentiel général d’amélioration de l’accessibilité) sont indiqués pour chacune des solutions proposées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Correctement indiquer les changements de langue au sein de votre contenu sur l&rsquo;éditeur Gutenberg</h2>\n\n\n\n<p>Il arrive très fréquemment qu’on emploie des termes en anglais ou issus d’une autre langue dans un texte. Ce changement de langue ne sera pas vocalisé correctement, ni même indiqué dans le code. Cela risque d’être incompréhensible pour les utilisateurs et utilisatrices de technologies d’assistance comme les lecteurs d’écran. Cette recommandation fait aussi l’objet d’une règle Opquast («&nbsp;<a href=\"https://checklists.opquast.com/fr/qualite-numerique/chaque-changement-de-langue-est-signale\">Règle n° 132 &#8211; Chaque changement de langue est signalé.</a>&nbsp;»)</p>\n\n\n\n<p><strong>Un exemple :</strong> l’<em><bdo lang=\"en\" dir=\"ltr\">European Accessibility Act</bdo></em> est entré en vigueur au mois de juin 2025.</p>\n\n\n\n<h3 class=\"wp-block-heading\">La solution</h3>\n\n\n\n<p>Pas de panique, aucun besoin de développer quoi que ce soit pour ça. C’est déjà intégré à WordPress, il n’y a pas besoin d’une extension ou de code personnalisé à ajouter. L’ajout de l’attribut lang dans le code <abbr title=\"HyperText Markup Language\">HTML</abbr> se fait dans l’éditeur de blocs tout simplement, via la barre d’outil en sélectionnant la portion de texte concernée.</p>\n\n\n\n<p><strong>Dans l’éditeur de blocs :</strong> barre d’outils de l’éditeur &gt; options de formatage (plus) «&nbsp;Langue&nbsp;».</p>\n\n\n\n<p><strong>Quelle destination</strong> : les personnes utilisant des lecteurs d’écrans et autres technologies d’assistance.</p>\n\n\n\n<p><strong>En détail :</strong> pour mieux comprendre un article très complet de Sylvie Duchateau et Flore Vannier, «&nbsp;<a href=\"https://access42.net/changements-langue-accessibilite-numerique/\">Comment gérer les changements de langue pour l’accessibilité numérique ?</a> », donne des exemples concrets. L’article date de 2024.</p>\n\n\n\n<p>L’article de Jean-Baptiste « <a href=\"https://whodunit.consulting/histoire-fonctionnalite-accessibilite-wordpress-bouton-formatage-langue/\">Histoire d’une fonctionnalité d’accessibilité</a> », à l’origine de cette amélioration dans WordPress, revient sur le chemin vers l’implémentation du bouton de formatage de langue.</p>\n\n\n\n<div class=\"wp-block-group has-base-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-0e4ecca0 wp-block-group-is-layout-constrained\" style=\"border-top-left-radius:10px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:10px;padding-top:1.5rem;padding-right:1.5rem;padding-bottom:1.5rem;padding-left:1.5rem\">\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"padding-top:0;padding-bottom:0;line-height:1\">Le critère du RGAA concerné</h3>\n\n\n\n<p><a href=\"https://accessibilite.numerique.gouv.fr/methode/criteres-et-tests/#8.7\">Critère 8.7 du RGAA</a>&nbsp;: Dans chaque page web, chaque changement de langue est-il indiqué dans le code source (hors cas particuliers) ?</p>\n</div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img width=\"1024\" height=\"554\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/langue-2025-10-29-at-16.52.02-1024x554.jpeg\" alt=\"\" class=\"wp-image-4783\" //><figcaption class=\"wp-element-caption\">Sélectionnez le texte concerné puis cliquez sur la flèche descendante indiquée «&nbsp;plus&nbsp;». Sélectionnez dans le menu déroulant «&nbsp;langue&nbsp;». Renseignez un attribut de langue valide, comme «&nbsp;en&nbsp;» ou «&nbsp;fr&nbsp;» dans le champ «&nbsp;Langue&nbsp;» de la fenêtre.</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Indiquer les changements de sens de lecture pour les pages présentant du contenu multilingue</h2>\n\n\n\n<p>C’est sûrement un cas de figure moins fréquent que d’avoir un changement de sens de langue de droite à gauche, pour un texte principal écrit en français (de gauche à droite) par exemple. En tout cas, il est nécessaire ici aussi de l’indiquer dans le code.</p>\n\n\n\n<h3 class=\"wp-block-heading\">La solution</h3>\n\n\n\n<p>Là encore c’est déjà intégré à WordPress, il n’y a pas besoin d’une extension ou de code à ajouter. L’ajout dans le code HTML se fait dans l’éditeur de blocs tout simplement, via la barre d’outil en sélectionnant la portion de texte concernée.</p>\n\n\n\n<p><strong>Dans l’éditeur de blocs :</strong> barre d’outils de l’éditeur &gt; options de formatage (plus) « Langue&nbsp;» &gt; «&nbsp;Direction du texte »</p>\n\n\n\n<div class=\"wp-block-group has-base-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-84807e65 wp-block-group-is-layout-constrained\" style=\"border-top-left-radius:10px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:10px;padding-top:1.5rem;padding-right:1.5rem;padding-bottom:1.5rem;padding-left:1.5rem\">\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"padding-top:0;padding-bottom:0;line-height:1\">Le critère du RGAA concerné</h3>\n\n\n\n<p><a href=\"https://accessibilite.numerique.gouv.fr/methode/criteres-et-tests/#8.10\">Critère 8.10 du RGAA</a>&nbsp;: Dans chaque page web, les changements du sens de lecture sont-ils signalés ?</p>\n</div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img width=\"1024\" height=\"760\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/sens-lecture-langue-2025-10-24-1024x760.jpeg\" alt=\"\" class=\"wp-image-4791\" //><figcaption class=\"wp-element-caption\">Sélectionnez le texte concerné puis cliquez sur la flèche descendante indiquée «&nbsp;plus&nbsp;». Sélectionnez dans le menu déroulant «&nbsp;langue&nbsp;». Renseignez un attribut de langue valide, ici «&nbsp;ja&nbsp;» dans le champ «&nbsp;Langue&nbsp;» de la fenêtre ainsi que la direction du texte, ici de droite à gauche.</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Utiliser une hiérarchie des titres pertinente avec l&rsquo;aide de l&rsquo;éditeur Gutenberg</h2>\n\n\n\n<p>Une hiérarchie cohérente des titres de la page permet d’améliorer la compréhension de la personne qui lit le contenu. Et accessoirement d’optimiser la page pour le référencement. La règle 234 d’Opquast, «&nbsp;<a href=\"https://checklists.opquast.com/fr/qualite-numerique/le-contenu-de-chaque-page-est-organise-selon-une-structure-de-titres-et-sous-titres-hierarchisee\">Le contenu de chaque page est organisé selon une structure de titres et sous-titres hiérarchisée.</a>&nbsp;» couvre cette recommandation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">La solution</h3>\n\n\n\n<p>La cohérence de la structure de votre contenu est vérifiable grâce au panneau <em>Structure</em> sur la gauche au sein de l’éditeur de blocs. Vous y trouverez sous forme de liste, les titres et leur niveaux respectifs. Et pourrez ainsi vous assurer qu’aucun titre <code>h4</code> par exemple, ne suit un titre <code>h2</code>. C’est indispensable pour les personnes naviguant à l’aide d’un clavier dans la page et lorsque les contenus sont lus par une synthèse vocale.</p>\n\n\n\n<p><strong>Dans l’éditeur de blocs :</strong> le panneau <em>Structure</em> sur la gauche dans l’éditeur de blocs est accessible via le bouton&nbsp;<em>Vue d&rsquo;ensemble du document</em>, situé dans la barre supérieure de l’éditeur. </p>\n\n\n\n<p><strong>Quelle destination ?</strong> Les personnes utilisant des lecteurs d’écrans et autres technologies d’assistance.</p>\n\n\n\n<div class=\"wp-block-group has-base-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-84807e65 wp-block-group-is-layout-constrained\" style=\"border-top-left-radius:10px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:10px;padding-top:1.5rem;padding-right:1.5rem;padding-bottom:1.5rem;padding-left:1.5rem\">\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"padding-top:0;padding-bottom:0;line-height:1\">Le critère du RGAA concerné</h3>\n\n\n\n<p><a href=\"https://accessibilite.numerique.gouv.fr/methode/criteres-et-tests/#9.1\">Critère 9.1 du RGAA</a>&nbsp;: Dans chaque page web, l’information est-elle structurée par l’utilisation appropriée de titres ?</p>\n</div>\n\n\n\n<figure class=\"wp-block-image size-large\"><img width=\"1024\" height=\"841\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/vue-structure-hierarchie-titres-1024x841.jpeg\" alt=\"\" class=\"wp-image-4772\" //><figcaption class=\"wp-element-caption\">Le panneau <em>Structure</em> sur la gauche dans l’éditeur de blocs donne accès à la hiérarchisation du contenu en listant chacun des titres présents dans la publication dans leur ordre d&rsquo;affichage. Le niveau de titre (h2, ou h3 par exemple) précède le libellé du titre.</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Baliser les citations dans un paragraphe pour une meilleure accessibilité</h2>\n\n\n\n<p>Les citations contenues dans un paragraphe (<bdo lang=\"en\" dir=\"ltr\">inline</bdo>) doivent être balisées en utilisant l’élément HTML <code>q</code> pour être conforme en termes d’accessibilité. Une extension de Jean-Baptiste Audras ajoutera cette fonctionnalité dans la barre d’outil de formatage de l’éditeur de blocs.</p>\n\n\n\n<p><strong>Un exemple :</strong> Comme le disait très justement Jules César <q>«&nbsp;qui veut la paix prépare la guerre&nbsp;»</q>.</p>\n\n\n\n<p>nb : le bloc de citation natif est déjà balisé avec <code>&lt;blockquote&gt;</code>, donc pas d’intervention nécessaire ici.</p>\n\n\n\n<h3 class=\"wp-block-heading\">La solution</h3>\n\n\n\n<p><strong>Dans l’éditeur de blocs :</strong> barre d’outils de l’éditeur &gt; options de formatage (plus) <q>«&nbsp;</q>Citation en ligne<q>&nbsp;»</q>.</p>\n\n\n\n<p><strong>Quelle destination ?</strong> Les personnes utilisant des lecteurs d’écrans et autres technologies d’assistance.</p>\n\n\n\n<p><strong>L’extension à installer : </strong><a href=\"https://fr.wordpress.org/plugins/who-inline-quote-format/\">Inline Quote Format Button for the Block Editor</a> ajoute un bouton de formatage HTML dans la barre d’outils de formatage de l’éditeur.</p>\n\n\n\n<p><strong>En détail :</strong> vous trouverez une explication fouillée de l’auteur de l’extension dans l’article «&nbsp;<a href=\"https://whodunit.consulting/rgaa-citations-en-ligne-accessible-editeur-gutenberg/\">Assurer l’accessibilité des citations sur l’éditeur Gutenberg</a>&nbsp;»<a href=\"https://whodunit.consulting/rgaa-citations-en-ligne-accessible-editeur-gutenberg/\">.</a></p>\n\n\n\n<div class=\"wp-block-group has-base-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-84807e65 wp-block-group-is-layout-constrained\" style=\"border-top-left-radius:10px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:10px;padding-top:1.5rem;padding-right:1.5rem;padding-bottom:1.5rem;padding-left:1.5rem\">\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"padding-top:0;padding-bottom:0;line-height:1\">Le critère du RGAA concerné</h3>\n\n\n\n<p><a href=\"https://accessibilite.numerique.gouv.fr/methode/criteres-et-tests/#9.4\">Critère 9.4 du RGAA</a> : dans chaque page web, chaque citation est-elle correctement indiquée ?</p>\n</div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img width=\"604\" height=\"128\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/citation-q-inspecteur-2025-10-28-at-15.18.35.jpeg\" alt=\"\" class=\"wp-image-4777\" //><figcaption class=\"wp-element-caption\">Le bouton <em>Citation en ligne</em> ajoute au texte sélectionné l’élément <code>q</code> dans le code HTML.</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">L&rsquo;accessibilité des abréviations dans WP</h2>\n\n\n\n<p>On utilise beaucoup d’abréviations ou d’initiales dans les articles avec des contenus rédactionnels techniques en particulier. Une bonne pratique est d’en donner le détail ou la définition sur la première occurence dans le contenu (<a href=\"https://checklists.opquast.com/fr/qualite-numerique/la-premiere-occurrence-dune-abreviation-ou-dun-acronyme-dans-le-corps-de-chaque-page-donne-acces-a-sa-signification\">règle n°5</a> de la checklist Opquast, Règle n° 5 &#8211; La première occurrence d&rsquo;une abréviation ou d&rsquo;un acronyme dans le corps de chaque page donne accès à sa signification.).</p>\n\n\n\n<p><strong>L’extension à installer : </strong><a href=\"https://fr.wordpress.org/plugins/abbreviation-button-for-the-block-editor/\"><bdo lang=\"en\" dir=\"ltr\">Abbreviation Button for the Block Editor</bdo></a> ajoute un nouveau bouton de formatage HTML <code>abbr</code> dans la barre d’outils de l’éditeur. Cet élément HTML permet de s’assurer que les abréviations soient comprises comme telles par les technologies d’assistance, en les informant que les caractères concernés constituent une abréviation et en fournissant la signification de celle-ci via l’attribut <code>title</code>.</p>\n\n\n\n<p><strong>Dans l’éditeur de blocs :</strong> barre d’outils de l’éditeur &gt; options de formatage (plus) <q>«&nbsp;</q>Abréviation<q>&nbsp;»</q> qui vous permet de donner une définition de l’abréviation. </p>\n\n\n\n<p><strong>Quelle destination ?</strong> Les personnes utilisant des lecteurs d’écrans et autres technologies d’assistance.</p>\n\n\n\n<p>Mais aussi :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Permet d’accéder rapidement à la signification d’un sigle.</li>\n\n\n\n<li>Permet l’exploitation du contenu par un robot (pour l’établissement d’un index des sigles).</li>\n\n\n\n<li>Favorise le référencement du contenu.</li>\n</ul>\n\n\n\n<div class=\"wp-block-group has-base-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-84807e65 wp-block-group-is-layout-constrained\" style=\"border-top-left-radius:10px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:10px;padding-top:1.5rem;padding-right:1.5rem;padding-bottom:1.5rem;padding-left:1.5rem\">\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"padding-top:0;padding-bottom:0;line-height:1\">Le critère des <abbr title=\"Web Content Accessibility Guidelines\"><bdo lang=\"en\" dir=\"ltr\">WCAG</bdo></abbr> concerné</h3>\n\n\n\n<p><a href=\"https://www.w3.org/WAI/WCAG21/Understanding/abbreviations.html\">Critère 3.1.4 WCAG</a> <bdo lang=\"en\" dir=\"ltr\">Abbreviations</bdo> (abréviations).</p>\n</div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img width=\"940\" height=\"412\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/CleanShot-2025-10-29-at-17.48.04.jpeg\" alt=\"\" class=\"wp-image-4801\" //><figcaption class=\"wp-element-caption\">Le bouton <em>Abréviation</em> ajoute à la description de l’abréviation renseignée, l’élément <code>abbr</code> dans le code HTML. La description fourni la signification de l’abréviation via l’attribut&nbsp;<code>title</code>.</figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\"><q>Sources et références</q></h2>\n\n\n\n<h3 class=\"wp-block-heading\">95% des sites dans le monde présentent des échecs de conformité</h3>\n\n\n\n<p>Ce chiffre est issu d’un rapport sur l’accessibilité publié par WebAIM (<bdo lang=\"en\" dir=\"ltr\">Web Accessibility In Mind</bdo>) «&nbsp;<a href=\"https://webaim.org/projects/million/\"><bdo lang=\"en\" dir=\"ltr\">The WebAIM Million</bdo></a>&nbsp;». Cette étude, conduite depuis 6 ans, analyse chaque année un échantillon de 1 million de pages d’accueil de sites en ligne. Le rapport 2025 conclut que 94.8% des pages auditées ne sont pas conformes aux directives sur l&rsquo;accessibilité des contenus en ligne.</p>\n\n\n\n<p class=\"has-small-font-size\">WebAIM est un organisme à but non lucratif basé à l&rsquo;université de l&rsquo;Utah aux États Unis. L&rsquo;organisation fournit des solutions en matière d&rsquo;accessibilité. Parmi ses outils les plus connus figure le WAVE (<bdo lang=\"en\" dir=\"ltr\">Web Accessibility Evaluation Tool</bdo>), un outil gratuit utilisable pour identifier les problèmes d&rsquo;accessibilité sur les sites.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Les <bdo lang=\"en\" dir=\"ltr\">Web Content Accessibility Guidelines</bdo></h3>\n\n\n\n<p>Les <bdo lang=\"en\" dir=\"ltr\"><em><a href=\"https://www.w3.org/WAI/WCAG22/quickref/?versions=2.1.\">Web Content Accessibility Guidelines</a></em></bdo> (WCAG)&nbsp;sont les directives pour l&rsquo;accessibilité des contenus web, soit un ensemble de recommandations publiées par le W3C (World Wide Web Consortium) pour rendre les contenus en ligne plus accessibles aux personnes handicapées.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Opquast&nbsp;: un projet qui nous tient à cœur&nbsp;!</h3>\n\n\n\n<p><a href=\"https://www.opquast.com/\">Opquast</a> est une entreprise à mission qui propose un référentiel, des formations et une certification de compétences dans le but de promouvoir et développer l’assurance qualité pour le numérique.</p>\n\n\n\n<p>L’acronyme Opquast signifie « <bdo lang=\"en\" dir=\"ltr\"><em>Open Quality Standards</em></bdo> », normes de qualité ouvertes.</p>\n\n\n\n<p>L&rsquo;agence Whodunit est très impliquée dans cet écosystème. Nous sommes <a href=\"https://directory.opquast.com/fr/whodunit/\">partenaires Opquast</a>, nous avons élaboré un outil pour <a href=\"https://whodunit.consulting/mise-a-jour-inventaire-opquast-wordpress-v5/\">générer un inventaire des règles d&rsquo;assurance qualité Opquast s&rsquo;appliquant à votre projet WordPress</a>, et nous <a href=\"https://whodunit.consulting/opquast-referentiel-assurance-qualite-web/\">portons les valeurs de ce projet auprès de nos clients</a>.</p>\n\n\n\n<div class=\"wp-block-group has-base-background-color has-background has-global-padding is-layout-constrained wp-container-core-group-is-layout-80fb368b wp-block-group-is-layout-constrained\" style=\"border-style:none;border-width:0px;border-top-left-radius:10px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:10px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">\n<p class=\"is-style-text-chapo is-style-text-chapo--3\"><strong>Pour résumer </strong></p>\n\n\n\n<p class=\"is-style-default\"><strong>Grâce à l’éditeur Gutenberg, il est possible&nbsp;:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>d’indiquer les changements de langue dans le texte,</li>\n\n\n\n<li>d’indiquer les changements de sens de lecture dans un contenu multilingue,</li>\n\n\n\n<li>de vérifier que la hiérarchie des titres est pertinente.</li>\n</ul>\n\n\n\n<p><strong>En ajoutant une extension à son site il est possible de&nbsp;:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>baliser une citation dans un paragraphe,</li>\n\n\n\n<li>baliser une abréviation et renseigner une description.</li>\n</ul>\n\n\n\n<p>Et ainsi vous assurer que le contenu est accessible à tous et à toutes.</p>\n</div>\n<p>L’article <a href=\"https://whodunit.consulting/des-contenus-plus-accessibles-avec-wordpress/\">Des contenus plus accessibles avec WordPress</a> est apparu en premier sur <a href=\"https://whodunit.consulting\">Whodunit Consulting</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Béryl de La Grandière\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://whodunit.consulting/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Whodunit Consulting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://beapi.fr/blog/les-hooks-dans-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Les hooks dans WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:47:\"https://beapi.fr/blog/les-hooks-dans-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-27T08:09:55.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-27T08:09:55.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:413:\"Qu’est-ce qu’un hook dans WordPress ? Les hooks (appelés crochets en français) est un concept central pour WordPress. Il est présent depuis le tout début, on les trouve déjà dans la version 0.71 qui est la première version officielle de WordPress. Ces hooks permettent aux développeurs de modifier le comportement par défaut de WordPress et […]\nThe post Les hooks dans WordPress appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:11624:\"\n        \n<h2 class=\"wp-block-heading\">Qu’est-ce qu’un hook dans WordPress ?</h2>\n\n\n\n<p>Les hooks (appelés crochets en français) est un concept central pour WordPress. Il est présent depuis le tout début, on les trouve déjà dans la version 0.71 qui est la première version officielle de WordPress.</p>\n\n\n\n<p>Ces hooks permettent aux développeurs de modifier le comportement par défaut de WordPress et d’ajouter de nouvelles fonctionnalités, le tout sans avoir à toucher aux fichiers du cœur. Ils représentent des “points d’accroches” sur lequel le développeur peut s’accrocher pour exécuter du code spécifique.</p>\n\n\n\n<p>Cette approche a plusieurs avantages :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Maintenabilité de WordPress : le cœur de WordPress n’est jamais modifié, il n’y a pas de risque de “perdre” des modifications lors de mises à jour,</li>\n\n\n\n<li>Maintenabilité du code : le code spécifique est découplé du code de WordPress. Il est placé dans les plugins ou le thème,</li>\n</ul>\n\n\n\n<p>Les hooks ne sont pas limités au cœur de WordPress ! La plupart de vos extensions et thèmes proposent les leurs. Ce sont donc un gros plus pour l&rsquo;écosystème WordPress en général.</p>\n\n\n\n<p>Ils sont découpés en deux grandes familles, les actions et les filtres. Quelle est la différence ?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Définition des hooks : actions vs filters</h3>\n\n\n\n<p>Avant de passer à la pratique et de voir concrètement comment profiter des hooks, il faut bien comprendre la différence entre les deux grandes catégories, les actions et les filtres.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Les actions</h4>\n\n\n\n<p>Les actions sont utilisées pour permettre aux développeurs <strong>d&rsquo;exécuter du code</strong> à des moments spécifiques du code du cœur de WordPress, d&rsquo;extensions etc.</p>\n\n\n\n<p>Ce sont des point d’entrée pour que les développeurs puissent “brancher” leur code personnalisé.</p>\n\n\n\n<p>Les deux fonctions associées sont :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>add_action</strong> : elle permet aux développeurs de s’accrocher à une action existante,</li>\n\n\n\n<li><strong>do_action</strong> : &nbsp; elle permet de déclencher une action et d’exécuter le code qui s’est accroché dessus.</li>\n</ul>\n\n\n\n<p>Elles ne permettent pas de modifier de la donnée, c’est le rôle des filtres.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Les filtres</h4>\n\n\n\n<p>Les filtres sont utilisés pour permettre aux développeurs <strong>de modifier de la donnée </strong>à des moments spécifiques du code du cœur de WordPress, d&rsquo;extensions etc.</p>\n\n\n\n<p>Les deux fonctions associées sont :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>add_filter</strong> : elle permet aux développeurs de s’accrocher à un filtre existant pour modifier la donnée associé,</li>\n\n\n\n<li><strong>apply_filters</strong> :&nbsp; elle permet d&rsquo;exécuter le filtre pour laisser le code qui s’est accroché dessus modifier la donnée.</li>\n</ul>\n\n\n\n<p>À la différence des actions, les filtres prennent de la donnée en entrée et doivent la renvoyer en sortie (sous peine de causer des bugs dans le projet).</p>\n\n\n\n<h3 class=\"wp-block-heading\">À quoi servent les hooks dans le cœur de WordPress?</h3>\n\n\n\n<p>Par exemple, WordPress fourni l’action “save_post”. Cette action est exécutée à chaque fois qu’un contenu est enregistré. Un développeur pourrait choisir d’utiliser cette action pour envoyer un email à l’administrateur pour l’avertir de ce changement.</p>\n\n\n\n<p>Pour reprendre l’exemple, WordPress fourni le filtre “wp_insert_post_data” qui permet de modifier les données d’un contenu avant qu’il soit enregistré en base de données. Un développeur pourrait utiliser ce filtre pour modifier le contenu.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Comment utiliser un hook dans le fichier functions.php ?</h2>\n\n\n\n<p>Pour utiliser un hook on passe par les fonctions “add_action” ou “add_filter”.</p>\n\n\n\n<p>La signature des deux fonctions est la même :</p>\n\n\n<div class=\"wp-block-wab-pastacode\">\n	<div class=\"code-embed-wrapper\"> <pre class=\"language-php code-embed-pre line-numbers\" data-start=\"1\" data-line-offset=\"0\"><code class=\"language-php code-embed-code\">add_action( {nom du hook}, {fonction}, {priorité}, {nombres d&#039;arguments} );</code></pre> <div class=\"code-embed-infos\"> <span class=\"code-embed-name\">add_action</span> </div> </div></div>\n\n\n\n<p>On indique en premier le nom du hook que l’on souhaite utiliser, et en deuxième une fonction qui sera appelée lorsque le hook est déclenché (en anglais on appel ça un callback).</p>\n\n\n<div class=\"wp-block-wab-pastacode\">\n	<div class=\"code-embed-wrapper\"> <pre class=\"language-php code-embed-pre line-numbers\" data-start=\"1\" data-line-offset=\"0\"><code class=\"language-php code-embed-code\">// Ce code peut être placé dans un plugin ou dans le fichier functions.php de votre thème<br //><br //>// Active le support des images à la une pour le thème<br //>function theme_support() {<br //>    add_theme_support( &#039;post-thumbnails&#039; );<br //>}<br //>add_action( &#039;after_setup_theme&#039;, &#039;theme_support&#039; );<br //><br //>// Préfixe le titre des contenus avec &quot;Découvrez le contenu : &quot;<br //>function prefix_post_title( $title ) {<br //>    return &quot;Découvrez le contenu : &quot; . $title;<br //>}<br //>add_filter( &#039;the_title&#039;,&#039;prefix_post_title&#039; );</code></pre> <div class=\"code-embed-infos\"> </div> </div></div>\n\n\n\n<h3 class=\"wp-block-heading\">Arguments</h3>\n\n\n\n<p>Les hooks peuvent fournir des arguments aux fonctions qui sont accrochés :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>dans le cas des actions, ces arguments permettent de donner du contexte au développeur pour qu’il puisse personnaliser le comportement de son code,</li>\n\n\n\n<li>dans le cas des filtres, le premier argument correspond à la valeur à modifier et le reste donne du contexte supplémentaire, toujours pour permettre de personnaliser le comportement du code</li>\n</ul>\n\n\n\n<p>On peut préciser le nombre d’arguments attendu dans la fonction accrochée si on doit en recevoir plus d’un.</p>\n\n\n<div class=\"wp-block-wab-pastacode\">\n	<div class=\"code-embed-wrapper\"> <pre class=\"language-php code-embed-pre line-numbers\" data-start=\"1\" data-line-offset=\"0\"><code class=\"language-php code-embed-code\">// Préfixe le titre des articles avec &quot;Découvrez l&#039;article : &quot;<br //>function modifier_titre_article( $title, $post_id ) {<br //>    // on modifie le titre uniquement pour les articles<br //>    if ( &#039;post&#039; === get_post_type( $post_id ) ) {<br //>        $title = &quot;Découvrez l&#039;article : &quot; . $title;<br //>    }<br //><br //>    return $title;<br //>}<br //><br //>// On veut recevoir les deux arguments du filtre the_title<br //>// apply_filters( &#039;the_title&#039;, $post_title, $post_id );<br //>add_filter( &#039;the_title&#039;, &#039;modifier_titre_article&#039;, 10, 2 );</code></pre> <div class=\"code-embed-infos\"> </div> </div></div>\n\n\n\n<h3 class=\"wp-block-heading\">Priorité</h3>\n\n\n\n<p>La priorité permet spécifier un ordre dans lequel les fonctions accrochés au hook sont exécutées. Les priorités les plus basses s&rsquo;exécutent en premier.</p>\n\n\n\n<p>La priorité par défaut est 10.</p>\n\n\n<div class=\"wp-block-wab-pastacode\">\n	<div class=\"code-embed-wrapper\"> <pre class=\"language-php code-embed-pre line-numbers\" data-start=\"1\" data-line-offset=\"0\"><code class=\"language-php code-embed-code\">add_action( &#039;wp_body_open&#039;, &#039;fonction_priorite_haute&#039;, 1 ); // 1ère<br //>add_action( &#039;wp_body_open&#039;, &#039;fonction_priorite_defaut&#039; ); // 2ème<br //>add_action( &#039;wp_body_open&#039;, &#039;fonction_priorite_basse&#039;, 25 ); // 3ème</code></pre> <div class=\"code-embed-infos\"> </div> </div></div>\n\n\n\n<p>La priorité est importante à garder en tête lorsque l’on utilise des filtres, car chaque filtre reçoit le résultat du filtre précédent. Si un filtre modifie la valeur originale, le filtre suivant recevra cette valeur modifiée.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Cas pratique : ajouter un message dans le pied de page</h2>\n\n\n\n<p>Pour illustrer concrètement l&rsquo;utilisation des hooks, nous allons intégrer la date du jour dans le footer de votre site WordPress. On va utiliser l&rsquo;action wp_footer qui est intégrer dans les thèmes.</p>\n\n\n<div class=\"wp-block-wab-pastacode\">\n	<div class=\"code-embed-wrapper\"> <pre class=\"language-php code-embed-pre line-numbers\" data-start=\"1\" data-line-offset=\"0\"><code class=\"language-php code-embed-code\">// Ce code peut être placé dans un plugin ou dans le fichier functions.php de votre thème<br //><br //>// Affiche la date courante dans le footer des pages du site.<br //>function show_current_date() {<br //>    // Nous sommes le Vendredi 20 Juin 2025<br //>    echo &#039;&lt;p&gt;Nous sommes le &#039;. esc_html( date_i18n( &#039;l j F Y&#039; ) ).&#039;&lt;/p&gt;&#039;;<br //>}<br //>add_action( &#039;wp_footer&#039;, &#039;show_current_date&#039; );</code></pre> <div class=\"code-embed-infos\"> </div> </div></div>\n\n\n\n<h2 class=\"wp-block-heading\">Bonnes pratiques pour l’utilisation des hooks</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Où placer votre code de hooks WordPress ?</h3>\n\n\n\n<p>Les hooks WordPress sont donc la base sur lesquels s&rsquo;appuient les développeurs pour réaliser des modifications ou ajouter de nouvelles fonctionnalités.</p>\n\n\n\n<p>Lorsque vous travaillez avec les hooks WordPress, le choix de l&#8217;emplacement de votre code personnalisé est important pour assurer la maintenabilité et la robustesse de votre site. Deux options principales s&rsquo;offrent à vous : les plugins ou votre thème.</p>\n\n\n\n<p>Il est préférable de placer votre code personnalisé dans un plugin si sa fonctionnalité doit persister même si l&rsquo;utilisateur change de thème. C&rsquo;est le cas pour des éléments comme les types de contenu personnalisés, des fonctionnalités complexes, ou toute logique métier qui ne dépend pas directement de l&rsquo;apparence visuelle. Un plugin garantit que ces fonctionnalités restent actives quel que soit le thème choisi.</p>\n\n\n\n<p>À l&rsquo;inverse, si votre code concerne spécifiquement l&rsquo;apparence ou le comportement de votre site lié à un thème précis, il est plus judicieux de l&rsquo;intégrer directement dans le thème (avec le fichier functions.php notamment). Cela inclut des tâches telles que la déclaration de menus, le chargement d&rsquo;assets spécifiques au thème (feuilles de style, scripts JavaScript), ou la configuration des blocs Gutenberg disponibles.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Où trouver des informations sur les hooks WordPress ?</h3>\n\n\n\n<p>Nous avons vu que les hooks peuvent avoir différents nombres d’arguments.</p>\n\n\n\n<p>La documentation officielle de WordPress (le Developer Handbook) est une mine d&rsquo;informations. Il propose <a href=\"https://developer.wordpress.org/reference/hooks/\">une liste complète des hooks</a>, avec des détails sur leurs arguments et leur utilisation.</p>\n\n\n\n<p>Il ne faut pas non plus hésiter à examiner directement le code sources des fonctions WordPress pour voir les hooks qu&rsquo;elles proposent (s’appliquent aussi dans le cas du code sources des plugins).</p>\n\n\n\n<p></p>\n<p>The post <a href=\"https://beapi.fr/blog/les-hooks-dans-wordpress/\">Les hooks dans WordPress</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Clément Boirie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Comprendre les hooks de WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:63:\"https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-21T09:19:35.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-10-21T09:19:35.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:707:\"WordPress est un CMS qui est infiniment extensible et personnalisable. Il existe des milliers d’extensions qui permettent d’ajouter des fonctionnalités à votre site ou de modifier le comportement normal de WordPress. Tout cela est rendu possible par l’existence d’une API relativement simple contenue dans le cœur de WordPress depuis très longtemps : la plugin API. Dans cet article, on va redécouvrir et étudier la plugin API (les fameux hooks de WordPress) pour en comprendre le fonctionnement plus en détail. La plugin API : définition La plugin API ou (API des extensions) est simplement un ensemble de fonctions PHP qui permettent […]Lire la suite : Comprendre les hooks de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:840:\"\n        WordPress est un CMS qui est infiniment extensible et personnalisable. Il existe des milliers d&#8217;extensions qui permettent d&#8217;ajouter des fonctionnalités à votre site ou de modifier le comportement normal de WordPress. Tout cela est rendu possible par l&#8217;existence d&#8217;une API relativement simple contenue dans le cœur de WordPress depuis très longtemps : la plugin API. Dans cet article, on va redécouvrir et étudier la plugin API (les fameux hooks de WordPress) pour en comprendre le fonctionnement plus en détail. La plugin API : définition La plugin API ou (API des extensions) est simplement un ensemble de fonctions PHP qui permettent [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://vincentdubroeucq.com/comprendre-les-hooks-de-wordpress/\">Comprendre les hooks de WordPress</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Vincent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://vincentdubroeucq.com/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vincent Dubroeucq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:4:\"date\";s:29:\"Mon, 08 Dec 2025 10:18:34 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:4:\"link\";s:64:\"<https://fluxplanet.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:13:\"last-modified\";s:29:\"Tue, 22 Jul 2025 21:51:07 GMT\";s:4:\"etag\";s:36:\"W/\"072268436a8b47633210153ceb845bac\"\";s:6:\"server\";s:22:\"o2switch-PowerBoost-v3\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1765232315;s:23:\"__cache_expiration_time\";i:1765232315;}", "off");
INSERT INTO `wp_options` VALUES("855", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1765232315", "off");
INSERT INTO `wp_options` VALUES("856", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2025/12/02/wordpress-6-9-gene/\'>WordPress 6.9 « Gene »</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\'>Guide des changements techniques de WordPress 6.9</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wpfr.net/wpfr-lance-ses-permanences-associatives-mensuelles/\'>WPFR lance ses permanences associatives mensuelles</a></li><li><a class=\'rsswidget\' href=\'https://wpmarmite.com/briefly-unavailable-for-scheduled-maintenance-wordpress/\'>Comment corriger l’erreur WordPress « Briefly unavailable for scheduled maintenance. Check back in a minute. »</a></li><li><a class=\'rsswidget\' href=\'https://blog.o2switch.fr/sortie-wordpress-6-9-nouveautes/\'>Sortie de WordPress 6.9 : les nouveautés à connaître avant la mise à jour</a></li></ul></div>", "off");
INSERT INTO `wp_options` VALUES("863", "wp_notes_notify", "1", "on");
INSERT INTO `wp_options` VALUES("873", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("875", "_site_transient_timeout_wp_theme_files_patterns-b504a84fe5d0ddd52a6f591a4ad3b089", "1765191269", "off");
INSERT INTO `wp_options` VALUES("876", "_site_transient_wp_theme_files_patterns-b504a84fe5d0ddd52a6f591a4ad3b089", "a:2:{s:7:\"version\";s:3:\"4.4\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("877", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.9.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1765189650;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("878", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1765189651;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"gutenberg/gutenberg.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:6:\"plugin\";s:23:\"gutenberg/gutenberg.php\";s:11:\"new_version\";s:6:\"22.2.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/gutenberg/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/gutenberg.22.2.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/gutenberg/assets/icon-256x256.jpg?rev=1776042\";s:2:\"1x\";s:62:\"https://ps.w.org/gutenberg/assets/icon-128x128.jpg?rev=1776042\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/gutenberg/assets/banner-1544x500.jpg?rev=1718710\";s:2:\"1x\";s:64:\"https://ps.w.org/gutenberg/assets/banner-772x250.jpg?rev=1718710\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}}s:7:\"checked\";a:2:{s:25:\"duplicator/duplicator.php\";s:6:\"1.5.14\";s:23:\"gutenberg/gutenberg.php\";s:6:\"22.2.0\";}}", "off");
INSERT INTO `wp_options` VALUES("879", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1765189651;s:7:\"checked\";a:3:{s:20:\"creative-blog-writer\";s:3:\"1.9\";s:9:\"riverbank\";s:6:\"1.0.15\";s:14:\"twentythirteen\";s:3:\"4.4\";}s:8:\"response\";a:2:{s:20:\"creative-blog-writer\";a:6:{s:5:\"theme\";s:20:\"creative-blog-writer\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:50:\"https://wordpress.org/themes/creative-blog-writer/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/theme/creative-blog-writer.2.0.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:3:\"7.2\";}s:14:\"twentythirteen\";a:6:{s:5:\"theme\";s:14:\"twentythirteen\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentythirteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentythirteen.4.5.zip\";s:8:\"requires\";s:3:\"3.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}}s:9:\"no_update\";a:1:{s:9:\"riverbank\";a:6:{s:5:\"theme\";s:9:\"riverbank\";s:11:\"new_version\";s:6:\"1.0.15\";s:3:\"url\";s:39:\"https://wordpress.org/themes/riverbank/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/riverbank.1.0.15.zip\";s:8:\"requires\";s:3:\"5.5\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("880", "duplicator_version_plugin", "1.5.14", "auto");
INSERT INTO `wp_options` VALUES("882", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.14\";s:4:\"time\";i:1765189652;s:10:\"updateTime\";i:1765189652;}", "off");
INSERT INTO `wp_options` VALUES("883", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("884", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("885", "duplicator_settings", "a:20:{s:7:\"version\";s:6:\"1.5.14\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:1;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("886", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"SOYl_V4Z3GfWfO8jcBZaLfNZVCv&kfnd.OleAk_SXSQ.\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 189.05000000000001,\n    \"siteNumFiles\": 6756,\n    \"siteDbSizeMB\": 1.8600000000000001,\n    \"siteDbNumTables\": 13\n}", "auto");
INSERT INTO `wp_options` VALUES("887", "duplicator_notifications", "a:4:{s:6:\"update\";i:1765189652;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("888", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-08 10:31:51\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"court_circuit_admin\";s:4:\"Hash\";s:35:\"02c24c6bec387df75099_20251208103151\";s:8:\"NameHash\";s:55:\"court_circuit_admin_02c24c6bec387df75099_20251208103151\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:65:\"court_circuit_admin_02c24c6bec387df75099_20251208103151_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:51:\"C:/Users/Aline/Local Sites/court-circuit/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:995;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5761;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-08 10:31:51\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:19:\"court_circuit_admin\";s:4:\"Hash\";s:35:\"02c24c6bec387df75099_20251208103151\";s:8:\"NameHash\";s:55:\"court_circuit_admin_02c24c6bec387df75099_20251208103151\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:65:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:60:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-admin\";i:1;s:63:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-includes\";i:2;s:72:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:51:\"C:/Users/Aline/Local Sites/court-circuit/app/public\";i:1;s:51:\"C:/Users/Aline/Local Sites/court-circuit/app/public\";i:2;s:62:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content\";i:3;s:70:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/uploads\";i:4;s:70:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/plugins\";i:5;s:73:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/mu-plugins\";i:6;s:69:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:83:\"C:/Users/Aline/Local Sites/court-circuit/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("4", "8", "_wp_attached_file", "2025/06/logo_CCC-rose-e1762962632778.jpg");
INSERT INTO `wp_postmeta` VALUES("5", "8", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:400;s:6:\"height\";i:206;s:4:\"file\";s:40:\"2025/06/logo_CCC-rose-e1762962632778.jpg\";s:8:\"filesize\";i:31478;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"logo_CCC-rose-300x154.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25557;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"logo_CCC-rose-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20445;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"logo_CCC-rose-768x395.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52153;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:25:\"logo_CCC-rose-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41684;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("6", "9", "_wp_attached_file", "2025/06/bandeau5.jpg");
INSERT INTO `wp_postmeta` VALUES("7", "9", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1333;s:6:\"height\";i:254;s:4:\"file\";s:20:\"2025/06/bandeau5.jpg\";s:8:\"filesize\";i:42917;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"bandeau5-300x57.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:57;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15667;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"bandeau5-1024x195.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34258;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"bandeau5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16096;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"bandeau5-768x146.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26569;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:20:\"bandeau5-604x254.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:254;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31403;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:19:\"FlyerCCC_23.05.indd\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("13", "11", "_wp_attached_file", "2025/06/bandeau2.jpg");
INSERT INTO `wp_postmeta` VALUES("14", "11", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:876;s:6:\"height\";i:254;s:4:\"file\";s:20:\"2025/06/bandeau2.jpg\";s:8:\"filesize\";i:30942;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"bandeau2-300x87.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:87;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14627;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"bandeau2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16688;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"bandeau2-768x223.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24699;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:20:\"bandeau2-604x254.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:254;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27281;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:19:\"FlyerCCC_23.05.indd\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("15", "12", "_wp_attached_file", "2025/06/cropped-bandeau2-1.jpg");
INSERT INTO `wp_postmeta` VALUES("16", "12", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("17", "12", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1600;s:6:\"height\";i:230;s:4:\"file\";s:30:\"2025/06/cropped-bandeau2-1.jpg\";s:8:\"filesize\";i:32074;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"cropped-bandeau2-1-300x43.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13480;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"cropped-bandeau2-1-1024x147.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22316;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"cropped-bandeau2-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14768;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"cropped-bandeau2-1-768x110.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18654;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"cropped-bandeau2-1-1536x221.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30614;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:30:\"cropped-bandeau2-1-604x230.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28084;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:19:\"FlyerCCC_23.05.indd\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:11;}");
INSERT INTO `wp_postmeta` VALUES("18", "12", "_wp_attachment_custom_header_last_used_twentythirteen", "1750695583");
INSERT INTO `wp_postmeta` VALUES("19", "12", "_wp_attachment_is_custom_header", "twentythirteen");
INSERT INTO `wp_postmeta` VALUES("20", "13", "_wp_attached_file", "2025/06/banniere4-e1750695532888.jpg");
INSERT INTO `wp_postmeta` VALUES("21", "13", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:372;s:6:\"height\";i:183;s:4:\"file\";s:36:\"2025/06/banniere4-e1750695532888.jpg\";s:8:\"filesize\";i:25089;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"banniere4-300x148.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:148;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22205;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"banniere4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19736;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:19:\"FlyerCCC_23.05.indd\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("22", "14", "_wp_attached_file", "2025/06/cropped-banniere4.jpg");
INSERT INTO `wp_postmeta` VALUES("23", "14", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("24", "14", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1600;s:6:\"height\";i:230;s:4:\"file\";s:29:\"2025/06/cropped-banniere4.jpg\";s:8:\"filesize\";i:39057;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"cropped-banniere4-300x43.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16699;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"cropped-banniere4-1024x147.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27678;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"cropped-banniere4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15848;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"cropped-banniere4-768x110.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23113;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:30:\"cropped-banniere4-1536x221.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37802;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:29:\"cropped-banniere4-604x230.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26896;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:19:\"FlyerCCC_23.05.indd\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:13;}");
INSERT INTO `wp_postmeta` VALUES("25", "14", "_wp_attachment_custom_header_last_used_twentythirteen", "1750695358");
INSERT INTO `wp_postmeta` VALUES("26", "14", "_wp_attachment_is_custom_header", "twentythirteen");
INSERT INTO `wp_postmeta` VALUES("27", "13", "_edit_lock", "1750695401:1");
INSERT INTO `wp_postmeta` VALUES("28", "13", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:435;s:6:\"height\";i:214;s:8:\"filesize\";i:34532;s:4:\"file\";s:13:\"banniere4.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("29", "13", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("30", "15", "_wp_attached_file", "2025/06/silhouette.jpg");
INSERT INTO `wp_postmeta` VALUES("31", "15", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1139;s:6:\"height\";i:738;s:4:\"file\";s:22:\"2025/06/silhouette.jpg\";s:8:\"filesize\";i:272058;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"silhouette-300x194.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:194;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19571;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"silhouette-1024x663.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:663;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61576;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"silhouette-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15685;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"silhouette-768x498.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:498;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:44101;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:22:\"silhouette-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31554;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("32", "16", "_wp_attached_file", "2025/06/cropped-silhouette.jpg");
INSERT INTO `wp_postmeta` VALUES("33", "16", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("34", "16", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1600;s:6:\"height\";i:230;s:4:\"file\";s:30:\"2025/06/cropped-silhouette.jpg\";s:8:\"filesize\";i:40445;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"cropped-silhouette-300x43.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13844;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"cropped-silhouette-1024x147.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26096;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"cropped-silhouette-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14883;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"cropped-silhouette-768x110.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20891;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:31:\"cropped-silhouette-1536x221.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38068;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:30:\"cropped-silhouette-604x230.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27646;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:15;}");
INSERT INTO `wp_postmeta` VALUES("35", "16", "_wp_attachment_custom_header_last_used_twentythirteen", "1763374392");
INSERT INTO `wp_postmeta` VALUES("36", "16", "_wp_attachment_is_custom_header", "twentythirteen");
INSERT INTO `wp_postmeta` VALUES("40", "18", "_wp_attached_file", "2025/06/banniere-new.jpg");
INSERT INTO `wp_postmeta` VALUES("41", "18", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1786;s:6:\"height\";i:1158;s:4:\"file\";s:24:\"2025/06/banniere-new.jpg\";s:8:\"filesize\";i:439042;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"banniere-new-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20936;}s:5:\"large\";a:5:{s:4:\"file\";s:25:\"banniere-new-1024x664.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:664;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61489;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"banniere-new-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17261;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:24:\"banniere-new-768x498.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:498;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45318;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:25:\"banniere-new-1536x996.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:996;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:99101;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:24:\"banniere-new-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34234;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("42", "19", "_wp_attached_file", "2025/06/banniere-new-1.jpg");
INSERT INTO `wp_postmeta` VALUES("43", "19", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2362;s:6:\"height\";i:1169;s:4:\"file\";s:26:\"2025/06/banniere-new-1.jpg\";s:8:\"filesize\";i:482386;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"banniere-new-1-300x148.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:148;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16827;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"banniere-new-1-1024x507.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:507;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45797;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"banniere-new-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15756;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"banniere-new-1-768x380.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:380;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34025;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:27:\"banniere-new-1-1536x760.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:760;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73510;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:28:\"banniere-new-1-2048x1014.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1014;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:105975;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:26:\"banniere-new-1-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26997;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("44", "20", "_wp_attached_file", "2025/06/cropped-banniere-new-1.jpg");
INSERT INTO `wp_postmeta` VALUES("45", "20", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("46", "20", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1600;s:6:\"height\";i:230;s:4:\"file\";s:34:\"2025/06/cropped-banniere-new-1.jpg\";s:8:\"filesize\";i:30958;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"cropped-banniere-new-1-300x43.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12958;}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"cropped-banniere-new-1-1024x147.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:147;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21768;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"cropped-banniere-new-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13180;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"cropped-banniere-new-1-768x110.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:110;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18181;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:35:\"cropped-banniere-new-1-1536x221.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:221;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29812;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:34:\"cropped-banniere-new-1-604x230.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:230;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24797;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:19;}");
INSERT INTO `wp_postmeta` VALUES("47", "20", "_wp_attachment_custom_header_last_used_twentythirteen", "1750696627");
INSERT INTO `wp_postmeta` VALUES("48", "20", "_wp_attachment_is_custom_header", "twentythirteen");
INSERT INTO `wp_postmeta` VALUES("58", "25", "wp_pattern_sync_status", "unsynced");
INSERT INTO `wp_postmeta` VALUES("68", "31", "_wp_attached_file", "2025/06/cropped-logo_CCC-rose.jpg");
INSERT INTO `wp_postmeta` VALUES("69", "31", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("70", "31", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:33:\"2025/06/cropped-logo_CCC-rose.jpg\";s:8:\"filesize\";i:43366;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"cropped-logo_CCC-rose-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30004;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"cropped-logo_CCC-rose-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20372;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:33:\"cropped-logo_CCC-rose-512x270.jpg\";s:5:\"width\";i:512;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29484;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:33:\"cropped-logo_CCC-rose-270x270.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28437;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:33:\"cropped-logo_CCC-rose-192x192.jpg\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23273;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:33:\"cropped-logo_CCC-rose-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22431;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:31:\"cropped-logo_CCC-rose-32x32.jpg\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14119;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("78", "37", "_edit_lock", "1763375318:1");
INSERT INTO `wp_postmeta` VALUES("89", "43", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("90", "43", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("91", "43", "_menu_item_object_id", "20");
INSERT INTO `wp_postmeta` VALUES("92", "43", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("93", "43", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("94", "43", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("95", "43", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("96", "43", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("97", "43", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("110", "46", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("111", "46", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("112", "46", "_menu_item_object_id", "30");
INSERT INTO `wp_postmeta` VALUES("113", "46", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("114", "46", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("115", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("116", "46", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("117", "46", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("119", "46", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("120", "47", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("121", "47", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("122", "47", "_menu_item_object_id", "32");
INSERT INTO `wp_postmeta` VALUES("123", "47", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("124", "47", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("125", "47", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("126", "47", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("127", "47", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("129", "47", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("130", "48", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("131", "48", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("132", "48", "_menu_item_object_id", "31");
INSERT INTO `wp_postmeta` VALUES("133", "48", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("134", "48", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("135", "48", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("136", "48", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("137", "48", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("139", "48", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("140", "49", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("141", "49", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("142", "49", "_menu_item_object_id", "20");
INSERT INTO `wp_postmeta` VALUES("143", "49", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("144", "49", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("145", "49", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("146", "49", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("147", "49", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("149", "49", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("150", "50", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("151", "50", "_menu_item_menu_item_parent", "49");
INSERT INTO `wp_postmeta` VALUES("152", "50", "_menu_item_object_id", "23");
INSERT INTO `wp_postmeta` VALUES("153", "50", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("154", "50", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("155", "50", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("156", "50", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("157", "50", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("159", "50", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("160", "51", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("161", "51", "_menu_item_menu_item_parent", "49");
INSERT INTO `wp_postmeta` VALUES("162", "51", "_menu_item_object_id", "21");
INSERT INTO `wp_postmeta` VALUES("163", "51", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("164", "51", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("165", "51", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("166", "51", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("167", "51", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("169", "51", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("170", "52", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("171", "52", "_menu_item_menu_item_parent", "49");
INSERT INTO `wp_postmeta` VALUES("172", "52", "_menu_item_object_id", "22");
INSERT INTO `wp_postmeta` VALUES("173", "52", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("174", "52", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("175", "52", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("176", "52", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("177", "52", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("179", "52", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("180", "53", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("181", "53", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("182", "53", "_menu_item_object_id", "14");
INSERT INTO `wp_postmeta` VALUES("183", "53", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("184", "53", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("185", "53", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("186", "53", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("187", "53", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("189", "53", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("190", "54", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("191", "54", "_menu_item_menu_item_parent", "53");
INSERT INTO `wp_postmeta` VALUES("192", "54", "_menu_item_object_id", "15");
INSERT INTO `wp_postmeta` VALUES("193", "54", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("194", "54", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("195", "54", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("196", "54", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("197", "54", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("199", "54", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("200", "55", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("201", "55", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("202", "55", "_menu_item_object_id", "10");
INSERT INTO `wp_postmeta` VALUES("203", "55", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("204", "55", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("205", "55", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("206", "55", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("207", "55", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("209", "55", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("210", "56", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("211", "56", "_menu_item_menu_item_parent", "55");
INSERT INTO `wp_postmeta` VALUES("212", "56", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("213", "56", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("214", "56", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("215", "56", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("216", "56", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("217", "56", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("219", "56", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("220", "57", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("221", "57", "_menu_item_menu_item_parent", "55");
INSERT INTO `wp_postmeta` VALUES("222", "57", "_menu_item_object_id", "11");
INSERT INTO `wp_postmeta` VALUES("223", "57", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("224", "57", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("225", "57", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("226", "57", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("227", "57", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("229", "57", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("230", "58", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("231", "58", "_menu_item_menu_item_parent", "55");
INSERT INTO `wp_postmeta` VALUES("232", "58", "_menu_item_object_id", "13");
INSERT INTO `wp_postmeta` VALUES("233", "58", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("234", "58", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("235", "58", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("236", "58", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("237", "58", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("239", "58", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("240", "59", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("241", "59", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("242", "59", "_menu_item_object_id", "16");
INSERT INTO `wp_postmeta` VALUES("243", "59", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("244", "59", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("245", "59", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("246", "59", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("247", "59", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("249", "59", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("260", "61", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("261", "61", "_menu_item_menu_item_parent", "59");
INSERT INTO `wp_postmeta` VALUES("262", "61", "_menu_item_object_id", "18");
INSERT INTO `wp_postmeta` VALUES("263", "61", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("264", "61", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("265", "61", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("266", "61", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("267", "61", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("269", "61", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("270", "62", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("271", "62", "_menu_item_menu_item_parent", "59");
INSERT INTO `wp_postmeta` VALUES("272", "62", "_menu_item_object_id", "19");
INSERT INTO `wp_postmeta` VALUES("273", "62", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("274", "62", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("275", "62", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("276", "62", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("277", "62", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("279", "62", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("290", "64", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("291", "64", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("292", "64", "_menu_item_object_id", "24");
INSERT INTO `wp_postmeta` VALUES("293", "64", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("294", "64", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("295", "64", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("296", "64", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("297", "64", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("299", "64", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("300", "65", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("301", "65", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("302", "65", "_menu_item_object_id", "27");
INSERT INTO `wp_postmeta` VALUES("303", "65", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("304", "65", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("305", "65", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("306", "65", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("307", "65", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("309", "65", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("310", "66", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("311", "66", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("312", "66", "_menu_item_object_id", "29");
INSERT INTO `wp_postmeta` VALUES("313", "66", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("314", "66", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("315", "66", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("316", "66", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("317", "66", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("319", "66", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("320", "67", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("321", "67", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("322", "67", "_menu_item_object_id", "26");
INSERT INTO `wp_postmeta` VALUES("323", "67", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("324", "67", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("325", "67", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("326", "67", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("327", "67", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("329", "67", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("330", "68", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("331", "68", "_menu_item_menu_item_parent", "46");
INSERT INTO `wp_postmeta` VALUES("332", "68", "_menu_item_object_id", "28");
INSERT INTO `wp_postmeta` VALUES("333", "68", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("334", "68", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("335", "68", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("336", "68", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("337", "68", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("339", "68", "_menu_item_content", "");
INSERT INTO `wp_postmeta` VALUES("373", "2", "_edit_lock", "1763374785:1");
INSERT INTO `wp_postmeta` VALUES("378", "97", "_wp_attached_file", "2025/11/FlyerCCC-recto-verso.pdf");
INSERT INTO `wp_postmeta` VALUES("379", "97", "_wp_attachment_metadata", "a:2:{s:5:\"sizes\";a:4:{s:4:\"full\";a:5:{s:4:\"file\";s:28:\"FlyerCCC-recto-verso-pdf.jpg\";s:5:\"width\";i:499;s:6:\"height\";i:1058;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49347;}s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"FlyerCCC-recto-verso-pdf-141x300.jpg\";s:5:\"width\";i:141;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10718;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"FlyerCCC-recto-verso-pdf-483x1024.jpg\";s:5:\"width\";i:483;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43453;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"FlyerCCC-recto-verso-pdf-71x150.jpg\";s:5:\"width\";i:71;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6597;}}s:8:\"filesize\";i:1022027;}");
INSERT INTO `wp_postmeta` VALUES("384", "100", "_edit_lock", "1763374562:1");
INSERT INTO `wp_postmeta` VALUES("387", "102", "_edit_lock", "1763374514:1");
INSERT INTO `wp_postmeta` VALUES("388", "103", "_edit_lock", "1762965882:1");
INSERT INTO `wp_postmeta` VALUES("391", "105", "_edit_lock", "1762964248:1");
INSERT INTO `wp_postmeta` VALUES("396", "108", "_edit_lock", "1762964015:1");
INSERT INTO `wp_postmeta` VALUES("402", "112", "_edit_lock", "1762963310:1");
INSERT INTO `wp_postmeta` VALUES("403", "113", "_wp_attached_file", "2025/06/cropped-cropped-silhouette.jpg");
INSERT INTO `wp_postmeta` VALUES("404", "113", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("405", "113", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1599;s:6:\"height\";i:159;s:4:\"file\";s:38:\"2025/06/cropped-cropped-silhouette.jpg\";s:8:\"filesize\";i:31026;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-silhouette-300x30.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:30;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12948;}s:5:\"large\";a:5:{s:4:\"file\";s:39:\"cropped-cropped-silhouette-1024x102.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:102;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21178;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"cropped-cropped-silhouette-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14739;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:37:\"cropped-cropped-silhouette-768x76.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:76;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17803;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:39:\"cropped-cropped-silhouette-1536x153.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:153;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29763;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:16;}");
INSERT INTO `wp_postmeta` VALUES("406", "113", "_wp_attachment_custom_header_last_used_creative-blog-writer", "1762962348");
INSERT INTO `wp_postmeta` VALUES("407", "113", "_wp_attachment_is_custom_header", "creative-blog-writer");
INSERT INTO `wp_postmeta` VALUES("408", "114", "_wp_attached_file", "2025/06/cropped-bandeau5.jpg");
INSERT INTO `wp_postmeta` VALUES("409", "114", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("410", "114", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:1045;s:6:\"height\";i:236;s:4:\"file\";s:28:\"2025/06/cropped-bandeau5.jpg\";s:8:\"filesize\";i:45716;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"cropped-bandeau5-300x68.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:68;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17110;}s:5:\"large\";a:5:{s:4:\"file\";s:29:\"cropped-bandeau5-1024x231.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43173;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"cropped-bandeau5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17270;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"cropped-bandeau5-768x173.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:173;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31945;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:19:\"FlyerCCC_23.05.indd\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:9;}");
INSERT INTO `wp_postmeta` VALUES("411", "114", "_wp_attachment_custom_header_last_used_creative-blog-writer", "1762965116");
INSERT INTO `wp_postmeta` VALUES("412", "114", "_wp_attachment_is_custom_header", "creative-blog-writer");
INSERT INTO `wp_postmeta` VALUES("413", "115", "_wp_attached_file", "2025/06/cropped-logo_CCC-rose-1.jpg");
INSERT INTO `wp_postmeta` VALUES("414", "115", "_wp_attachment_context", "custom-logo");
INSERT INTO `wp_postmeta` VALUES("415", "115", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:816;s:6:\"height\";i:420;s:4:\"file\";s:35:\"2025/06/cropped-logo_CCC-rose-1.jpg\";s:8:\"filesize\";i:56655;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"cropped-logo_CCC-rose-1-300x154.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25562;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"cropped-logo_CCC-rose-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20460;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:35:\"cropped-logo_CCC-rose-1-768x395.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53451;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:35:\"cropped-logo_CCC-rose-1-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42081;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("416", "8", "_edit_lock", "1762962502:1");
INSERT INTO `wp_postmeta` VALUES("417", "8", "_wp_attachment_backup_sizes", "a:1:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:816;s:6:\"height\";i:420;s:8:\"filesize\";i:80611;s:4:\"file\";s:17:\"logo_CCC-rose.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("418", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("419", "116", "_wp_attached_file", "2025/06/cropped-logo_CCC-rose-e1762962632778.jpg");
INSERT INTO `wp_postmeta` VALUES("420", "116", "_wp_attachment_context", "custom-logo");
INSERT INTO `wp_postmeta` VALUES("421", "116", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:816;s:6:\"height\";i:420;s:4:\"file\";s:48:\"2025/06/cropped-logo_CCC-rose-e1762962632778.jpg\";s:8:\"filesize\";i:56496;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:48:\"cropped-logo_CCC-rose-e1762962632778-300x154.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:154;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24745;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:48:\"cropped-logo_CCC-rose-e1762962632778-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20023;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:48:\"cropped-logo_CCC-rose-e1762962632778-768x395.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:395;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52530;}s:14:\"post-thumbnail\";a:5:{s:4:\"file\";s:48:\"cropped-logo_CCC-rose-e1762962632778-604x270.jpg\";s:5:\"width\";i:604;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:40330;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("422", "18", "_wp_attachment_is_custom_background", "creative-blog-writer");
INSERT INTO `wp_postmeta` VALUES("423", "112", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("424", "112", "_wp_trash_meta_time", "1762963329");
INSERT INTO `wp_postmeta` VALUES("425", "117", "_wp_attached_file", "2025/11/chevre.jpg");
INSERT INTO `wp_postmeta` VALUES("426", "117", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:499;s:6:\"height\";i:333;s:4:\"file\";s:18:\"2025/11/chevre.jpg\";s:8:\"filesize\";i:66776;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"chevre-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20061;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"chevre-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8829;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("427", "118", "_wp_attached_file", "2025/11/ci.jpg");
INSERT INTO `wp_postmeta` VALUES("428", "118", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:250;s:6:\"height\";i:143;s:4:\"file\";s:14:\"2025/11/ci.jpg\";s:8:\"filesize\";i:26335;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:14:\"ci-150x143.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:143;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6454;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("429", "119", "_wp_attached_file", "2025/11/couple.png");
INSERT INTO `wp_postmeta` VALUES("430", "119", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:333;s:4:\"file\";s:18:\"2025/11/couple.png\";s:8:\"filesize\";i:329905;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"couple-300x200.png\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54940;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"couple-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:49346;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("433", "108", "_thumbnail_id", "117");
INSERT INTO `wp_postmeta` VALUES("436", "121", "_wp_attached_file", "2025/11/champi.jpg");
INSERT INTO `wp_postmeta` VALUES("437", "121", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:279;s:6:\"height\";i:186;s:4:\"file\";s:18:\"2025/11/champi.jpg\";s:8:\"filesize\";i:14597;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"champi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7371;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("438", "122", "_wp_attached_file", "2025/11/champi2.jpg");
INSERT INTO `wp_postmeta` VALUES("439", "122", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:19:\"2025/11/champi2.jpg\";s:8:\"filesize\";i:33711;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"champi2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16345;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"champi2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7310;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("440", "123", "_wp_attached_file", "2025/11/champi3.jpg");
INSERT INTO `wp_postmeta` VALUES("441", "123", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:666;s:4:\"file\";s:19:\"2025/11/champi3.jpg\";s:8:\"filesize\";i:71193;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"champi3-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19849;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"champi3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7493;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("442", "124", "_wp_attached_file", "2025/11/champi4.jpg");
INSERT INTO `wp_postmeta` VALUES("443", "124", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:19:\"2025/11/champi4.jpg\";s:8:\"filesize\";i:26831;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"champi4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13314;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"champi4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5871;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("444", "125", "_wp_attached_file", "2025/11/champi5.jpg");
INSERT INTO `wp_postmeta` VALUES("445", "125", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:336;s:4:\"file\";s:19:\"2025/11/champi5.jpg\";s:8:\"filesize\";i:23308;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"champi5-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12752;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"champi5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6013;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("446", "126", "_wp_attached_file", "2025/11/serre.jpg");
INSERT INTO `wp_postmeta` VALUES("447", "126", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:531;s:6:\"height\";i:398;s:4:\"file\";s:17:\"2025/11/serre.jpg\";s:8:\"filesize\";i:51676;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"serre-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18237;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"serre-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6742;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("448", "127", "_wp_attached_file", "2025/11/stand.jpg");
INSERT INTO `wp_postmeta` VALUES("449", "127", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:250;s:6:\"height\";i:187;s:4:\"file\";s:17:\"2025/11/stand.jpg\";s:8:\"filesize\";i:13000;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"stand-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7213;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("452", "105", "_thumbnail_id", "124");
INSERT INTO `wp_postmeta` VALUES("453", "128", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("454", "128", "_wp_trash_meta_time", "1762964428");
INSERT INTO `wp_postmeta` VALUES("455", "129", "_edit_lock", "1762964694:1");
INSERT INTO `wp_postmeta` VALUES("456", "129", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("457", "129", "_wp_trash_meta_time", "1762964728");
INSERT INTO `wp_postmeta` VALUES("458", "130", "_edit_lock", "1762964814:1");
INSERT INTO `wp_postmeta` VALUES("459", "130", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("460", "130", "_wp_trash_meta_time", "1762964846");
INSERT INTO `wp_postmeta` VALUES("463", "132", "_edit_lock", "1762965114:1");
INSERT INTO `wp_postmeta` VALUES("464", "132", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("465", "132", "_wp_trash_meta_time", "1762965116");
INSERT INTO `wp_postmeta` VALUES("466", "116", "_oembed_47f7096601e0283dbe8d92ff330c3903", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("476", "133", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("477", "134", "_wp_attached_file", "2025/11/cafe-epicerie.jpg");
INSERT INTO `wp_postmeta` VALUES("478", "134", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:895;s:6:\"height\";i:292;s:4:\"file\";s:25:\"2025/11/cafe-epicerie.jpg\";s:8:\"filesize\";i:219828;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"cafe-epicerie-300x98.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:98;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10420;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"cafe-epicerie-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6111;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"cafe-epicerie-768x251.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:251;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49372;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("481", "103", "_thumbnail_id", "134");
INSERT INTO `wp_postmeta` VALUES("482", "136", "_wp_attached_file", "2025/11/cropped-champi5.jpg");
INSERT INTO `wp_postmeta` VALUES("483", "136", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_postmeta` VALUES("484", "136", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:500;s:6:\"height\";i:336;s:4:\"file\";s:27:\"2025/11/cropped-champi5.jpg\";s:8:\"filesize\";i:24939;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"cropped-champi5-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12661;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"cropped-champi5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6002;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:17:\"attachment_parent\";i:125;}");
INSERT INTO `wp_postmeta` VALUES("485", "136", "_wp_attachment_custom_header_last_used_creative-blog-writer", "1762965633");
INSERT INTO `wp_postmeta` VALUES("486", "136", "_wp_attachment_is_custom_header", "creative-blog-writer");
INSERT INTO `wp_postmeta` VALUES("487", "9", "_edit_lock", "1762965662:1");
INSERT INTO `wp_postmeta` VALUES("495", "141", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("496", "141", "_wp_trash_meta_time", "1763374392");
INSERT INTO `wp_postmeta` VALUES("498", "116", "_oembed_a6538e12cbb1deeccade495cf043a483", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("503", "142", "_edit_lock", "1763374836:1");
INSERT INTO `wp_postmeta` VALUES("504", "142", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("505", "142", "_wp_trash_meta_time", "1763374857");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("2", "1", "2025-06-23 17:23:05", "2025-06-23 15:23:05", "<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"http://court-circuit.local/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->", "Page d’exemple", "", "publish", "closed", "open", "", "page-d-exemple", "", "", "2025-06-23 17:23:05", "2025-06-23 15:23:05", "", "0", "http://court-circuit.local/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2025-06-23 17:23:05", "2025-06-23 15:23:05", "<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://court-circuit.local.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Commentaires</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Médias</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n", "Politique de confidentialité", "", "draft", "closed", "open", "", "politique-de-confidentialite", "", "", "2025-06-23 17:23:05", "2025-06-23 15:23:05", "", "0", "http://court-circuit.local/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("4", "0", "2025-06-23 17:24:32", "2025-06-23 15:24:32", "<!-- wp:page-list /-->", "Navigation", "", "publish", "closed", "closed", "", "navigation", "", "", "2025-06-23 17:24:32", "2025-06-23 15:24:32", "", "0", "http://court-circuit.local/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2025-06-23 17:58:34", "2025-06-23 15:58:34", "{\"version\": 3, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-twentytwentyfive", "", "", "2025-06-23 17:58:34", "2025-06-23 15:58:34", "", "0", "http://court-circuit.local/wp-global-styles-twentytwentyfive/", "0", "wp_global_styles", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2025-06-23 18:09:48", "2025-06-23 16:09:48", "", "Logo Court-Circuit", "", "inherit", "open", "closed", "", "logo_ccc-rose", "", "", "2025-11-12 16:50:38", "2025-11-12 15:50:38", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/logo_CCC-rose.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2025-06-23 18:12:16", "2025-06-23 16:12:16", "", "FlyerCCC_23.05.indd", "", "inherit", "open", "closed", "", "flyerccc_23-05-indd", "", "", "2025-06-23 18:12:16", "2025-06-23 16:12:16", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/bandeau5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2025-06-23 18:14:38", "2025-06-23 16:14:38", "", "banniere large", "", "inherit", "open", "closed", "", "flyerccc_23-05-indd-3", "", "", "2025-06-23 18:19:32", "2025-06-23 16:19:32", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/bandeau2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2025-06-23 18:19:43", "2025-06-23 16:19:43", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau2-1.jpg", "banniere large", "", "inherit", "closed", "closed", "", "flyerccc_23-05-indd-4", "", "", "2025-06-23 18:19:43", "2025-06-23 16:19:43", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2025-06-23 18:15:40", "2025-06-23 16:15:40", "", "Banniere", "", "inherit", "open", "closed", "", "flyerccc_23-05-indd-5", "", "", "2025-06-23 18:19:01", "2025-06-23 16:19:01", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/banniere4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2025-06-23 18:15:58", "2025-06-23 16:15:58", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-banniere4.jpg", "Banniere", "", "inherit", "open", "closed", "", "banniere", "", "", "2025-06-23 18:15:58", "2025-06-23 16:15:58", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-banniere4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2025-06-23 18:21:03", "2025-06-23 16:21:03", "", "silhouette", "", "inherit", "open", "closed", "", "silhouette", "", "", "2025-06-23 18:21:03", "2025-06-23 16:21:03", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/silhouette.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2025-06-23 18:21:28", "2025-06-23 16:21:28", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg", "cropped-silhouette.jpg", "", "inherit", "open", "closed", "", "cropped-silhouette-jpg", "", "", "2025-06-23 18:21:28", "2025-06-23 16:21:28", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2025-06-23 18:25:49", "2025-06-23 16:25:49", "", "banniere new", "", "inherit", "open", "closed", "", "banniere-new", "", "", "2025-06-23 18:25:49", "2025-06-23 16:25:49", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/banniere-new.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2025-06-23 18:31:34", "2025-06-23 16:31:34", "", "banniere new", "", "inherit", "open", "closed", "", "banniere-new-2", "", "", "2025-06-23 18:31:34", "2025-06-23 16:31:34", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/banniere-new-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2025-06-23 18:31:46", "2025-06-23 16:31:46", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-banniere-new-1.jpg", "banniere new", "", "inherit", "open", "closed", "", "banniere-new-3", "", "", "2025-06-23 18:31:46", "2025-06-23 16:31:46", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-banniere-new-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2025-07-09 11:45:24", "2025-07-09 09:45:24", "<!-- wp:media-text {\"mediaLink\":\"http://court-circuit.local/wp-content/themes/twentythirteen/images/block-patterns/toroidal-colony.jpg\",\"mediaType\":\"image\",\"imageFill\":false,\"backgroundColor\":\"off-white\"} -->\n			<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-off-white-background-color has-background\"><figure class=\"wp-block-media-text__media\"><img src=\"http://court-circuit.local/wp-content/themes/twentythirteen/images/block-patterns/toroidal-colony.jpg\" alt=\"\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading -->\n			<h2>Exploration de l‘espace</h2>\n			<!-- /wp:heading -->\n\n			<!-- wp:paragraph -->\n			<p>Dans les années 1970, le centre de recherche Ames de la NASA a illustré certaines explorations sur ce à quoi pourraient ressembler les futures colonies spatiales. Cette pièce, illustrée par Rick Guidice, montre l‘intérieur d‘une colonie de forme toroïdale.</p>\n			<!-- /wp:paragraph -->\n\n			<!-- wp:buttons -->\n			<div class=\"wp-block-buttons\"><!-- wp:button -->\n			<div class=\"wp-block-button\"><a class=\"wp-block-button__link\">Découvrez en plus</a></div>\n			<!-- /wp:button --></div>\n			<!-- /wp:buttons --></div></div>\n			<!-- /wp:media-text -->", "Section d’information (copie)", "", "publish", "closed", "closed", "", "section-dinformation-copie", "", "", "2025-07-09 11:45:24", "2025-07-09 09:45:24", "", "0", "http://court-circuit.local/section-dinformation-copie/", "0", "wp_block", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2025-07-09 12:14:26", "2025-07-09 10:14:26", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose.jpg", "Logo Court-Circuit", "", "inherit", "open", "closed", "", "logo-court-circuit", "", "", "2025-07-09 12:14:26", "2025-07-09 10:14:26", "", "8", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2025-07-10 17:09:04", "2025-07-10 15:09:04", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,&nbsp; aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Robert Nagel (champignons) ou le télécharger <a href=\"http://court-circuit.local/wp-content/uploads/2025/11/FlyerCCC-recto-verso.pdf\" data-type=\"page\" data-id=\"2\" target=\"_blank\" rel=\"noreferrer noopener\">ici</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "publish", "open", "open", "", "faisons-connaitre-notre-marche", "", "", "2025-11-17 11:22:33", "2025-11-17 10:22:33", "", "0", "http://court-circuit.local/?p=37", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2025-07-10 17:09:04", "2025-07-10 15:09:04", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,  aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Sylvie Rivalan et de Marie-Agnès Sarda (stand de bières) .</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-07-10 17:09:04", "2025-07-10 15:09:04", "", "37", "http://court-circuit.local/?p=38", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2025-07-10 17:39:27", "2025-07-10 15:25:51", " ", "", "", "publish", "closed", "closed", "", "43", "", "", "2025-07-10 17:39:27", "2025-07-10 15:39:27", "", "0", "http://court-circuit.local/43/", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "46", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "0", "http://court-circuit.local/?p=46", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", "", "ASSOCIATIONS AMIES", "", "publish", "closed", "closed", "", "47", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "30", "http://court-circuit.local/?p=47", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "48", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "30", "http://court-circuit.local/?p=48", "17", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "49", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "0", "http://court-circuit.local/?p=49", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "50", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "20", "http://court-circuit.local/?p=50", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", "", "PRODUCTEURS", "", "publish", "closed", "closed", "", "51", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "20", "http://court-circuit.local/?p=51", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", "", "REVENDEURS", "", "publish", "closed", "closed", "", "52", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "20", "http://court-circuit.local/?p=52", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "53", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "0", "http://court-circuit.local/?p=53", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "54", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "14", "http://court-circuit.local/?p=54", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:42", " ", "", "", "publish", "closed", "closed", "", "55", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "0", "http://court-circuit.local/?p=55", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "56", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "10", "http://court-circuit.local/?p=56", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "57", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "10", "http://court-circuit.local/?p=57", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "58", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "10", "http://court-circuit.local/?p=58", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "59", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "0", "http://court-circuit.local/?p=59", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("61", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", "", "LISTE DES PRODUITS VENDUS", "", "publish", "closed", "closed", "", "61", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "16", "http://court-circuit.local/?p=61", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "62", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "16", "http://court-circuit.local/?p=62", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "64", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "0", "http://court-circuit.local/?p=64", "18", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "65", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "24", "http://court-circuit.local/?p=65", "19", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "66", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "24", "http://court-circuit.local/?p=66", "20", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "67", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "24", "http://court-circuit.local/?p=67", "15", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2025-07-23 14:47:18", "2025-07-23 12:36:43", " ", "", "", "publish", "closed", "closed", "", "68", "", "", "2025-07-23 14:47:18", "2025-07-23 12:47:18", "", "24", "http://court-circuit.local/?p=68", "21", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2025-08-27 11:20:41", "2025-08-27 09:20:41", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,&nbsp; aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Marie-Agnès Sarda (stand de bières) .</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-08-27 11:20:41", "2025-08-27 09:20:41", "", "37", "http://court-circuit.local/?p=71", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("72", "1", "2025-08-27 11:20:56", "2025-08-27 09:20:56", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,&nbsp; aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Marie-Agnès Sarda (stand de bières) et de Robert Nagel (champignons).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-08-27 11:20:56", "2025-08-27 09:20:56", "", "37", "http://court-circuit.local/?p=72", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2025-08-27 11:21:47", "2025-08-27 09:21:47", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,  aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Marie-Agnès Sarda (stand de bières) et de Robert Nagel (champignons).</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-08-27 11:21:47", "2025-08-27 09:21:47", "", "37", "http://court-circuit.local/?p=74", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2025-10-15 17:39:11", "2025-10-15 15:39:11", "@font-face {font-family: ‘Basalte sans-serif‘;\n src: url( “fonts/Basalte-Fond\") format(‘woff’); /* sans-serif */\n font-weight: sans-serif;\n font-style: sans-serif;\n}\n\nbody {\n font-family: \'Basalte, \'sans-serif\';\'\n src: url(( “fonts/Basalte-Fond\") format(‘woff’); /* sans-serif */\n font-weight: sans-serif;\n font-style: sans-serif\n}\n\nh1, h2, h3 {\n font-family: \'Basalte\',\'sans-serif\';\n src: url( ( “fonts/Basalte-Fond\") format(‘woff’); /* sans-serif */\n font-weight: sans-serif;\n font-style: sans-serif;align-content)\n}", "twentythirteen", "", "publish", "closed", "closed", "", "twentythirteen", "", "", "2025-11-17 11:20:57", "2025-11-17 10:20:57", "", "0", "http://court-circuit.local/twentythirteen/", "0", "custom_css", "", "0");
INSERT INTO `wp_posts` VALUES("89", "1", "2025-10-15 17:39:11", "2025-10-15 15:39:11", "@font-face {\n font-family: ‘Basalte\';\n src: url( “fonts/Basalte-Fond.otf”) format(‘woff’); /* medium */\n font-weight: normal;\n font-style: normal;\n}", "twentythirteen", "", "inherit", "closed", "closed", "", "88-revision-v1", "", "", "2025-10-15 17:39:11", "2025-10-15 15:39:11", "", "88", "http://court-circuit.local/?p=89", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2025-10-15 17:48:23", "2025-10-15 15:48:23", "@font-face {\n font-family: ‘Basalte\', sans-serif;\n src: url( “fonts/Basalte-Fond”) format(‘woff’); /* medium */\n font-weight: normal;\n font-style: normal;\n}\n\nbody {\n font-family: \'Basalte, \'sans-serif\';\n src: url( “/fonts/Basalte-Fond.otf” );\n}\n\nh1, h2, h3 {\n font-family: \'Basalte\',\'sans-serif\';\n src: url( “/fonts/Basalte-Fond.otf” )\n}", "twentythirteen", "", "inherit", "closed", "closed", "", "88-revision-v1", "", "", "2025-10-15 17:48:23", "2025-10-15 15:48:23", "", "88", "http://court-circuit.local/?p=91", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2025-11-10 16:30:20", "2025-11-10 15:30:20", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,&nbsp; aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Robert Nagel (champignons) ou le télécharger <a href=\"http://court-circuit.local/page-d-exemple/\" data-type=\"page\" data-id=\"2\">ici</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-11-10 16:30:20", "2025-11-10 15:30:20", "", "37", "http://court-circuit.local/?p=95", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("97", "1", "2025-11-10 16:31:49", "2025-11-10 15:31:49", "", "FlyerCCC-recto-verso", "", "inherit", "open", "closed", "", "flyerccc-recto-verso", "", "", "2025-11-10 16:31:49", "2025-11-10 15:31:49", "", "0", "http://court-circuit.local/wp-content/uploads/2025/11/FlyerCCC-recto-verso.pdf", "0", "attachment", "application/pdf", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2025-11-10 16:34:34", "2025-11-10 15:34:34", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,&nbsp; aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Robert Nagel (champignons) ou le télécharger <a href=\"http://court-circuit.local/wp-content/uploads/2025/11/FlyerCCC-recto-verso.pdf\" data-type=\"page\" data-id=\"2\">ici</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-11-10 16:34:34", "2025-11-10 15:34:34", "", "37", "http://court-circuit.local/?p=98", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("99", "1", "2025-11-10 16:36:42", "2025-11-10 15:36:42", "<!-- wp:paragraph -->\n<p>FAISONS CONNAITRE NOTRE MARCHE</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Il a besoin de nous tous pour continuer à nous donner satisfaction, que nous soyons producteurs ou consommateurs . Alors parlez-en à vos voisins, à vos amis, aux habitants,&nbsp; aux hébergeurs et aux vacanciers de votre village !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>CCC met à votre disposition un flyer à distribuer. Vous pouvez vous en procurer auprès de Robert Nagel (champignons) ou le télécharger <a href=\"http://court-circuit.local/wp-content/uploads/2025/11/FlyerCCC-recto-verso.pdf\" data-type=\"page\" data-id=\"2\" target=\"_blank\" rel=\"noreferrer noopener\">ici</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Merci de votre participation !</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "FAISONS CONNAÎTRE NOTRE MARCHÉ", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2025-11-10 16:36:42", "2025-11-10 15:36:42", "", "37", "http://court-circuit.local/?p=99", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2025-11-10 16:43:23", "2025-11-10 15:43:23", "<!-- wp:paragraph -->\n<p>Par court-circuit</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong><em>Pour nous écrire :</em>&nbsp;</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>&nbsp;<em><strong>info@court-circuitencorbieres.fr</strong></em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>C</strong><strong>onseil d\'Administration</strong>               </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol class=\"wp-block-list\"><!-- wp:list-item -->\n<li>Catherine Patissou</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Brigitte Frank</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Jacques Bernal</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Marie-Agnès Sarda</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Martine Allais</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Martine Bolo</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Matthieu Vaslin</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Monique Montenair</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Olivier Fouquet</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}}} -->\n<li style=\"font-style:normal;font-weight:400\">Robert Nagel</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}}} -->\n<li style=\"font-style:normal;font-weight:400\">Sylvie Baulu</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Sylvie Séguy</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><em>Voici la nouvelle composition du Bureau :</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>-Martine Allais, Secrétaire</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>-Monique Montenair, Trésorière</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>-Sylvie Baulu, Présidente</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Groupe de régulation:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>1. Catherine Patissou</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>2. Etienne Ouvrard</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>3. Jacques Bernal</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>4. Martine Bolo</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>5. Robert Nagel</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>6. Sylvie Séguy</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Responsable du groupement d\'achats</strong>&nbsp;:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Robert avec&nbsp;<strong><a href=\"https://ccc.avanthi.fr/\">CCC.AVANTHI</a></strong></p>\n<!-- /wp:paragraph -->", "Equipe 2024", "", "publish", "open", "open", "", "equipe-2024", "", "", "2025-11-17 11:15:57", "2025-11-17 10:15:57", "", "0", "http://court-circuit.local/?p=100", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2025-11-10 16:43:23", "2025-11-10 15:43:23", "<!-- wp:paragraph -->\n<p>Par court-circuit</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong><em>Pour nous écrire :</em>&nbsp;</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>&nbsp;<em><strong>info@court-circuitencorbieres.fr</strong></em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>C</strong><strong>onseil d\'Administration</strong>               </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"ordered\":true} -->\n<ol class=\"wp-block-list\"><!-- wp:list-item -->\n<li>Catherine Patissou</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Brigitte Frank</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Jacques Bernal</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Marie-Agnès Sarda</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Martine Allais</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Martine Bolo</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Matthieu Vaslin</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Monique Montenair</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Olivier Fouquet</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}}} -->\n<li style=\"font-style:normal;font-weight:400\">Robert Nagel</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"}}} -->\n<li style=\"font-style:normal;font-weight:400\">Sylvie Baulu</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>Sylvie Séguy</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p><em>Voici la nouvelle composition du Bureau :</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>-Martine Allais, Secrétaire</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>-Monique Montenair, Trésorière</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><em>-Sylvie Baulu, Présidente</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Groupe de régulation:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>1. Catherine Patissou</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>2. Etienne Ouvrard</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>3. Jacques Bernal</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>4. Martine Bolo</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>5. Robert Nagel</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>6. Sylvie Séguy</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Responsable du groupement d\'achats</strong>&nbsp;:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Robert avec&nbsp;<strong><a href=\"https://ccc.avanthi.fr/\">CCC.AVANTHI</a></strong></p>\n<!-- /wp:paragraph -->", "Equipe 2024", "", "inherit", "closed", "closed", "", "100-revision-v1", "", "", "2025-11-10 16:43:23", "2025-11-10 15:43:23", "", "100", "http://court-circuit.local/?p=101", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2025-11-10 17:01:30", "2025-11-10 16:01:30", "<!-- wp:paragraph -->\n<p><strong>Produits:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Bières artisanales</strong> <a href=\"http://court-circuit.local/cafe-de-pays-a-auriac/\" target=\"_blank\" rel=\"noreferrer noopener\">revendeuse</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Bijoux</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> <strong>Champignons</strong> <a href=\"http://court-circuit.local/105-2/\" target=\"_blank\" rel=\"noreferrer noopener\">producteur</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Conserves de légumes</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fromages  de chèvre</strong> <a href=\"http://court-circuit.local/la-rove-de-fa/\" target=\"_blank\" rel=\"noreferrer noopener\">producteurs</a>  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fromages et yaourts de brebis et de chèvre</strong>&nbsp;<a href=\"http://court-circuitencorbieres.eklablog.com/ferme-de-la-gigude-a125035026\">productrice</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fromages de vache</strong> &nbsp;&nbsp;&nbsp;<a href=\"http://court-circuitencorbieres.eklablog.com/ferme-des-8-vaches-a122949314\">productrice</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fruits</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Gâteaux</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Huile d’olive</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Jus de pommes</strong>&nbsp;<a href=\"http://court-circuitencorbieres.eklablog.com/melanie-et-michel-de-fourtou-a127645472\">producteurs</a>&nbsp;&nbsp;&nbsp;&nbsp; et&nbsp; <a href=\"http://court-circuitencorbieres.eklablog.com/domi-et-frank-eugster-a121224074\">producteurs</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Lait</strong> <a href=\"http://court-circuitencorbieres.eklablog.com/ferme-des-8-vaches-a122949314\">productrice</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Légumes</strong>&nbsp;&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Miels</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Oeufs</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Pains</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Pain d\'épices</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Peintures</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plantes aromatiques</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plantes vivaces</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plants</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Poteries</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Poulets</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Rillettes de lapin ou de volaille</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Savons</strong> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Soupes</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Terrine de lapin, de volaille, de gésiers</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Tisanes</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Vêtements</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Viandes d’agneau, de brebis </strong><a href=\"http://court-circuitencorbieres.eklablog.com/ferme-de-capcinier-a122146586\">ici</a><strong>, de veau, de chevreau bio</strong> <a href=\"http://court-circuitencorbieres.eklablog.com/larove-de-fa-a125035118\">ici</a>, <strong>de bœuf bio </strong><a href=\"http://court-circuitencorbieres.eklablog.com/melanie-et-michel-de-fourtou-a127645472\">ici</a><strong>, de porc, de taurillon, de lapin et de volaille </strong><a href=\"http://court-circuitencorbieres.eklablog.com/conserves-et-autres-a126688270\">ici</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Vinaigre&nbsp; Bio</strong> <a href=\"http://court-circuitencorbieres.eklablog.com/domaine-des-pierres-bleues-a122985096\">producteur</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Vins Bio rouges, blancs, rosés&nbsp;</strong><a href=\"http://court-circuitencorbieres.eklablog.com/domaine-des-pierres-bleues-a122985096\">producteur</a></p>\n<!-- /wp:paragraph -->", "Liste des produits vendus", "", "publish", "open", "open", "", "liste-des-produits-vendus", "", "", "2025-11-17 11:15:16", "2025-11-17 10:15:16", "", "0", "http://court-circuit.local/?p=102", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2025-11-10 16:50:32", "2025-11-10 15:50:32", "<!-- wp:paragraph -->\n<p>Située à 540m d’altitude entre les sites pôles du Pays Cathare, l \'association Coeur de Village vous accueille dans une ambiance familiale. Le temps d’une pause routière, laissez-vous tenter part une dégustation de plus de 8 variétés de miels, découvrez une gamme de produits locaux dans un cadre atypique offrant une vue exceptionnelle sur des vestiges attrayant&nbsp;: Le château et le village castral forment l’un des ensembles les plus importants de l’époque féodale avec le château de Termes.<br>S’arrêter à la Buvette d’Auriac est un moment à part&nbsp;!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI.jpg\"><img src=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI@150x150.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc.jpg\"><img src=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8.jpg\"><img src=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Un lien vers Corbières Minervois &nbsp; &nbsp; &nbsp; &nbsp; https://www.tourisme-corbieres-minervois.com/la-buvette-d-auriac-1089.html</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/BgWpriUuT6u2tW8dVCYGGip90RA@895x292.jpg\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Café de pays à Auriac", "", "publish", "open", "open", "", "cafe-de-pays-a-auriac", "", "", "2025-11-12 17:38:33", "2025-11-12 16:38:33", "", "0", "http://court-circuit.local/?p=103", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2025-11-10 16:50:32", "2025-11-10 15:50:32", "<!-- wp:paragraph -->\n<p>Située à 540m d’altitude entre les sites pôles du Pays Cathare, l \'association Coeur de Village vous accueille dans une ambiance familiale. Le temps d’une pause routière, laissez-vous tenter part une dégustation de plus de 8 variétés de miels, découvrez une gamme de produits locaux dans un cadre atypique offrant une vue exceptionnelle sur des vestiges attrayant&nbsp;: Le château et le village castral forment l’un des ensembles les plus importants de l’époque féodale avec le château de Termes.<br>S’arrêter à la Buvette d’Auriac est un moment à part&nbsp;!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI.jpg\"><img src=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI@150x150.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc.jpg\"><img src=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8.jpg\"><img src=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Un lien vers Corbières Minervois &nbsp; &nbsp; &nbsp; &nbsp; https://www.tourisme-corbieres-minervois.com/la-buvette-d-auriac-1089.html</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/BgWpriUuT6u2tW8dVCYGGip90RA@895x292.jpg\" alt=\"\"/></figure>\n<!-- /wp:image -->", "Café de pays à Auriac", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2025-11-10 16:50:32", "2025-11-10 15:50:32", "", "103", "http://court-circuit.local/?p=104", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2025-11-10 16:55:32", "2025-11-10 15:55:32", "<!-- wp:paragraph -->\n<p><strong>Robert Nagel à Laroque de Fa</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> <strong>Depuis 2013 je suis producteur des champignons certifié Bio:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Des Shiitaké et Pleurotes sur substrat, paille et bois naturel, chêne et peuplier à Laroque de Fa.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Tel.: 0667693803 / 0468461808 , courriel: Robert(arobase)avanthi.fr<br><br>Les produits en vente sont :<br>Principalement des Shiitakés et deux/trois variétés des Pleurotes en frais et séchés, entier ou en poudre.<br>Ensuite des produits dérivés comme des pâtés végétaux au Shiitaké/Pleurote, des petits quiches au Shiitaké<br>et autres gourmandises à base des mes champignons.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/eht_tzFl90r17nkhQuxbLwrB_Nc.jpg\"><img src=\"https://ekladata.com/eht_tzFl90r17nkhQuxbLwrB_Nc@531x398.jpg\" alt=\"Les Lentins des Corbières\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>&nbsp;ouvert aux visiteurs sur RDV 0667693803</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/egywbwWd3MflerDJmTmxBpAKZK4.jpg\"><img src=\"https://ekladata.com/egywbwWd3MflerDJmTmxBpAKZK4@250x188.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/2klbWMEHl-keHVurEdQP85Pi5aM.jpg\"><img src=\"https://ekladata.com/2klbWMEHl-keHVurEdQP85Pi5aM@279x186.jpg\" alt=\"Les Lentins des Corbières\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/cl53771IPNTdtGYgn7p4_JE2Iwc.jpg\"><img src=\"https://ekladata.com/cl53771IPNTdtGYgn7p4_JE2Iwc@500x375.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/qPZArvaB3cKzAfnmA560lwJr4sM.jpg\"><img src=\"https://ekladata.com/qPZArvaB3cKzAfnmA560lwJr4sM@500x667.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ViaJXAewLzvGXGxZnfWjJv2wBrE.jpg\"><img src=\"https://ekladata.com/ViaJXAewLzvGXGxZnfWjJv2wBrE@500x375.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/7Nybq2Pges2LDT_-olTGClNMZrI.jpg\"><img src=\"https://ekladata.com/7Nybq2Pges2LDT_-olTGClNMZrI@500x336.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->", "Les Lentins des Corbières", "", "publish", "open", "open", "", "105-2", "", "", "2025-11-12 17:17:10", "2025-11-12 16:17:10", "", "0", "http://court-circuit.local/?p=105", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2025-11-10 16:55:32", "2025-11-10 15:55:32", "<!-- wp:paragraph -->\n<p><strong>Robert Nagel à Laroque de Fa</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> <strong>Depuis 2013 je suis producteur des champignons certifié Bio:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Des Shiitaké et Pleurotes sur substrat, paille et bois naturel, chêne et peuplier à Laroque de Fa.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Tel.: 0667693803 / 0468461808 , courriel: Robert(arobase)avanthi.fr<br><br>Les produits en vente sont :<br>Principalement des Shiitakés et deux/trois variétés des Pleurotes en frais et séchés, entier ou en poudre.<br>Ensuite des produits dérivés comme des pâtés végétaux au Shiitaké/Pleurote, des petits quiches au Shiitaké<br>et autres gourmandises à base des mes champignons.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/eht_tzFl90r17nkhQuxbLwrB_Nc.jpg\"><img src=\"https://ekladata.com/eht_tzFl90r17nkhQuxbLwrB_Nc@531x398.jpg\" alt=\"Les Lentins des Corbières\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>&nbsp;ouvert aux visiteurs sur RDV 0667693803</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/egywbwWd3MflerDJmTmxBpAKZK4.jpg\"><img src=\"https://ekladata.com/egywbwWd3MflerDJmTmxBpAKZK4@250x188.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/2klbWMEHl-keHVurEdQP85Pi5aM.jpg\"><img src=\"https://ekladata.com/2klbWMEHl-keHVurEdQP85Pi5aM@279x186.jpg\" alt=\"Les Lentins des Corbières\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/cl53771IPNTdtGYgn7p4_JE2Iwc.jpg\"><img src=\"https://ekladata.com/cl53771IPNTdtGYgn7p4_JE2Iwc@500x375.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/qPZArvaB3cKzAfnmA560lwJr4sM.jpg\"><img src=\"https://ekladata.com/qPZArvaB3cKzAfnmA560lwJr4sM@500x667.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ViaJXAewLzvGXGxZnfWjJv2wBrE.jpg\"><img src=\"https://ekladata.com/ViaJXAewLzvGXGxZnfWjJv2wBrE@500x375.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/7Nybq2Pges2LDT_-olTGClNMZrI.jpg\"><img src=\"https://ekladata.com/7Nybq2Pges2LDT_-olTGClNMZrI@500x336.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->", "", "", "inherit", "closed", "closed", "", "105-revision-v1", "", "", "2025-11-10 16:55:32", "2025-11-10 15:55:32", "", "105", "http://court-circuit.local/?p=106", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2025-11-10 16:57:42", "2025-11-10 15:57:42", "<!-- wp:paragraph -->\n<p><strong>Robert Nagel à Laroque de Fa</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> <strong>Depuis 2013 je suis producteur des champignons certifié Bio:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Des Shiitaké et Pleurotes sur substrat, paille et bois naturel, chêne et peuplier à Laroque de Fa.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Tel.: 0667693803 / 0468461808 , courriel: Robert(arobase)avanthi.fr<br><br>Les produits en vente sont :<br>Principalement des Shiitakés et deux/trois variétés des Pleurotes en frais et séchés, entier ou en poudre.<br>Ensuite des produits dérivés comme des pâtés végétaux au Shiitaké/Pleurote, des petits quiches au Shiitaké<br>et autres gourmandises à base des mes champignons.</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/eht_tzFl90r17nkhQuxbLwrB_Nc.jpg\"><img src=\"https://ekladata.com/eht_tzFl90r17nkhQuxbLwrB_Nc@531x398.jpg\" alt=\"Les Lentins des Corbières\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>&nbsp;ouvert aux visiteurs sur RDV 0667693803</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/egywbwWd3MflerDJmTmxBpAKZK4.jpg\"><img src=\"https://ekladata.com/egywbwWd3MflerDJmTmxBpAKZK4@250x188.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/2klbWMEHl-keHVurEdQP85Pi5aM.jpg\"><img src=\"https://ekladata.com/2klbWMEHl-keHVurEdQP85Pi5aM@279x186.jpg\" alt=\"Les Lentins des Corbières\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/cl53771IPNTdtGYgn7p4_JE2Iwc.jpg\"><img src=\"https://ekladata.com/cl53771IPNTdtGYgn7p4_JE2Iwc@500x375.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/qPZArvaB3cKzAfnmA560lwJr4sM.jpg\"><img src=\"https://ekladata.com/qPZArvaB3cKzAfnmA560lwJr4sM@500x667.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ViaJXAewLzvGXGxZnfWjJv2wBrE.jpg\"><img src=\"https://ekladata.com/ViaJXAewLzvGXGxZnfWjJv2wBrE@500x375.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/7Nybq2Pges2LDT_-olTGClNMZrI.jpg\"><img src=\"https://ekladata.com/7Nybq2Pges2LDT_-olTGClNMZrI@500x336.jpg\" alt=\"LES LENTINS DES CORBIERES\"/></a></figure>\n<!-- /wp:image -->", "Les Lentins des Corbières", "", "inherit", "closed", "closed", "", "105-revision-v1", "", "", "2025-11-10 16:57:42", "2025-11-10 15:57:42", "", "105", "http://court-circuit.local/?p=107", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2025-11-10 16:59:07", "2025-11-10 15:59:07", "<!-- wp:paragraph -->\n<p><strong>LA ROVE DE FA Annaïg SERVAIN et Matthieu VASLIN</strong><br>Elevage de chèvres du Rove. Fromages fermiers. Viande de chevreaux élevés sous la mère.<br>Ferme de Borde Grande<br>11330 Laroque de Fa<br>Tel : 04 68 40 20 16<br>Port : 06 87 11 74 19<br>Email : larovedefa @ gmail.com</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/P_RHZdmdIPk8BgG6uINugVV_SC8@297x170.jpg\" alt=\"Ferme de LAROVE\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/il0sZQm7qS7oHihFwFNj2Yyf1w0.png\"><img src=\"https://ekladata.com/il0sZQm7qS7oHihFwFNj2Yyf1w0@500x333.png\" alt=\"LAROVE DE FA\"/></a></figure>\n<!-- /wp:image -->", "LA ROVE DE FA", "", "publish", "open", "open", "", "la-rove-de-fa", "", "", "2025-11-12 17:12:36", "2025-11-12 16:12:36", "", "0", "http://court-circuit.local/?p=108", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2025-11-10 16:59:07", "2025-11-10 15:59:07", "<!-- wp:paragraph -->\n<p><strong>LA ROVE DE FA Annaïg SERVAIN et Matthieu VASLIN</strong><br>Elevage de chèvres du Rove. Fromages fermiers. Viande de chevreaux élevés sous la mère.<br>Ferme de Borde Grande<br>11330 Laroque de Fa<br>Tel : 04 68 40 20 16<br>Port : 06 87 11 74 19<br>Email : larovedefa @ gmail.com</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/P_RHZdmdIPk8BgG6uINugVV_SC8@297x170.jpg\" alt=\"Ferme de LAROVE\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/P_RHZdmdIPk8BgG6uINugVV_SC8.jpg\"><img src=\"https://ekladata.com/6BaesKrBSCne_blk7mBcGCIpIZM@500x333.jpg\" alt=\"Rove-1.jpg\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/il0sZQm7qS7oHihFwFNj2Yyf1w0.png\"><img src=\"https://ekladata.com/il0sZQm7qS7oHihFwFNj2Yyf1w0@500x333.png\" alt=\"LAROVE DE FA\"/></a></figure>\n<!-- /wp:image -->", "LA ROVE DE FA", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2025-11-10 16:59:07", "2025-11-10 15:59:07", "", "108", "http://court-circuit.local/?p=109", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("111", "1", "2025-11-10 17:01:30", "2025-11-10 16:01:30", "<!-- wp:paragraph -->\n<p><strong>Produits:</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Bières artisanales</strong> <a href=\"http://court-circuit.local/cafe-de-pays-a-auriac/\" target=\"_blank\" rel=\"noreferrer noopener\">revendeuse</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Bijoux</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p> <strong>Champignons</strong> <a href=\"http://court-circuit.local/105-2/\" target=\"_blank\" rel=\"noreferrer noopener\">producteur</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Conserves de légumes</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fromages  de chèvre</strong> <a href=\"http://court-circuit.local/la-rove-de-fa/\" target=\"_blank\" rel=\"noreferrer noopener\">producteurs</a>  </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fromages et yaourts de brebis et de chèvre</strong>&nbsp;<a href=\"http://court-circuitencorbieres.eklablog.com/ferme-de-la-gigude-a125035026\">productrice</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fromages de vache</strong> &nbsp;&nbsp;&nbsp;<a href=\"http://court-circuitencorbieres.eklablog.com/ferme-des-8-vaches-a122949314\">productrice</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Fruits</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Gâteaux</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Huile d’olive</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Jus de pommes</strong>&nbsp;<a href=\"http://court-circuitencorbieres.eklablog.com/melanie-et-michel-de-fourtou-a127645472\">producteurs</a>&nbsp;&nbsp;&nbsp;&nbsp; et&nbsp; <a href=\"http://court-circuitencorbieres.eklablog.com/domi-et-frank-eugster-a121224074\">producteurs</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Lait</strong> <a href=\"http://court-circuitencorbieres.eklablog.com/ferme-des-8-vaches-a122949314\">productrice</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Légumes</strong>&nbsp;&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Miels</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Oeufs</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Pains</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Pain d\'épices</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Peintures</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plantes aromatiques</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plantes vivaces</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Plants</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Poteries</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Poulets</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Rillettes de lapin ou de volaille</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Savons</strong> </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Soupes</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Terrine de lapin, de volaille, de gésiers</strong>&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Tisanes</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Vêtements</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Viandes d’agneau, de brebis </strong><a href=\"http://court-circuitencorbieres.eklablog.com/ferme-de-capcinier-a122146586\">ici</a><strong>, de veau, de chevreau bio</strong> <a href=\"http://court-circuitencorbieres.eklablog.com/larove-de-fa-a125035118\">ici</a>, <strong>de bœuf bio </strong><a href=\"http://court-circuitencorbieres.eklablog.com/melanie-et-michel-de-fourtou-a127645472\">ici</a><strong>, de porc, de taurillon, de lapin et de volaille </strong><a href=\"http://court-circuitencorbieres.eklablog.com/conserves-et-autres-a126688270\">ici</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Vinaigre&nbsp; Bio</strong> <a href=\"http://court-circuitencorbieres.eklablog.com/domaine-des-pierres-bleues-a122985096\">producteur</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><strong>Vins Bio rouges, blancs, rosés&nbsp;</strong><a href=\"http://court-circuitencorbieres.eklablog.com/domaine-des-pierres-bleues-a122985096\">producteur</a></p>\n<!-- /wp:paragraph -->", "Liste des produits vendus", "", "inherit", "closed", "closed", "", "102-revision-v1", "", "", "2025-11-10 17:01:30", "2025-11-10 16:01:30", "", "102", "http://court-circuit.local/?p=111", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2025-11-12 17:02:09", "2025-11-12 16:02:09", "{\n    \"twentythirteen::header_image\": {\n        \"value\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:37:13\"\n    },\n    \"twentythirteen::header_image_data\": {\n        \"value\": {\n            \"attachment_id\": 16,\n            \"url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\",\n            \"thumbnail_url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\",\n            \"alt_text\": \"\",\n            \"attachment_parent\": 15,\n            \"width\": 1600,\n            \"height\": 230,\n            \"timestamp\": [\n                \"1750696657\"\n            ]\n        },\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:37:13\"\n    },\n    \"creative-blog-writer::header_image\": {\n        \"value\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:46:48\"\n    },\n    \"creative-blog-writer::header_image_data\": {\n        \"value\": {\n            \"url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\",\n            \"thumbnail_url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\",\n            \"timestamp\": 1762962386929,\n            \"attachment_id\": 114,\n            \"width\": 1045,\n            \"height\": 236\n        },\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:46:48\"\n    },\n    \"creative-blog-writer::nav_menu_locations[primary]\": {\n        \"value\": 8,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:46:48\"\n    },\n    \"blogname\": {\n        \"value\": \"\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:48:48\"\n    },\n    \"blogdescription\": {\n        \"value\": \"Le blog de l\'association et du march\\u00e9 du vendredi \\u00e0 Laroque de Fa\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:48:48\"\n    },\n    \"creative-blog-writer::creative_blog_writer_logo_width\": {\n        \"value\": \"50\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:47:48\"\n    },\n    \"site_icon\": {\n        \"value\": \"\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:48:48\"\n    },\n    \"creative-blog-writer::creative_blog_writer_site_title_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:48:48\"\n    },\n    \"creative-blog-writer::creative_blog_writer_tagline_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:48:48\"\n    },\n    \"creative-blog-writer::custom_logo\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:52:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_slider\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:52:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_slider_section_category\": {\n        \"value\": \"lassociation\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:53:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_reviewer_name\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:53:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_our_products_show_hide_section\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:53:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_archive_sidebar_setting\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_index_sidebar_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_paged_sidebar_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_search_result_sidebar_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_single_post_sidebar_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_single_page_sidebar_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_sidebar_position\": {\n        \"value\": \"left\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_hs_breadcrumb\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:54:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_preloader_bg_color\": {\n        \"value\": \"#bf6f74\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 15:59:16\"\n    },\n    \"creative-blog-writer::creative_blog_writer_body_text\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:01:16\"\n    },\n    \"old_sidebars_widgets_data\": {\n        \"value\": {\n            \"wp_inactive_widgets\": [\n                \"block-6\"\n            ],\n            \"sidebar-1\": [\n                \"block-2\",\n                \"block-9\",\n                \"block-10\",\n                \"nav_menu-2\",\n                \"block-3\",\n                \"block-4\",\n                \"block-8\"\n            ],\n            \"sidebar-2\": []\n        },\n        \"type\": \"global_variable\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:02:09\"\n    },\n    \"creative-blog-writer::background_image\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:02:09\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_heading_settings\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:02:09\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_content_settings\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:02:09\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_featured_image_settings\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:02:09\"\n    }\n}", "", "", "trash", "closed", "closed", "", "6ba237db-5745-47d9-b65f-3b5a2a577e99", "", "", "2025-11-12 17:02:09", "2025-11-12 16:02:09", "", "0", "http://court-circuit.local/?p=112", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("113", "1", "2025-11-12 16:45:48", "2025-11-12 15:45:48", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg", "cropped-cropped-silhouette.jpg", "", "inherit", "open", "closed", "", "cropped-cropped-silhouette-jpg", "", "", "2025-11-12 16:45:48", "2025-11-12 15:45:48", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-cropped-silhouette.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2025-11-12 16:46:26", "2025-11-12 15:46:26", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg", "FlyerCCC_23.05.indd", "", "inherit", "open", "closed", "", "flyerccc_23-05-indd-2", "", "", "2025-11-12 16:46:26", "2025-11-12 15:46:26", "", "0", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2025-11-12 16:49:49", "2025-11-12 15:49:49", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose-1.jpg", "Logo Court-Circuit", "", "inherit", "open", "closed", "", "logo-court-circuit-2", "", "", "2025-11-12 16:49:49", "2025-11-12 15:49:49", "", "8", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("116", "1", "2025-11-12 16:51:07", "2025-11-12 15:51:07", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose-e1762962632778.jpg", "Logo Court-Circuit", "", "inherit", "open", "closed", "", "logo-court-circuit-3", "", "", "2025-11-12 16:51:07", "2025-11-12 15:51:07", "", "8", "http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose-e1762962632778.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2025-11-12 17:10:13", "2025-11-12 16:10:13", "", "chevre", "", "inherit", "open", "closed", "", "chevre", "", "", "2025-11-12 17:10:13", "2025-11-12 16:10:13", "", "108", "http://court-circuit.local/wp-content/uploads/2025/11/chevre.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2025-11-12 17:10:14", "2025-11-12 16:10:14", "", "ci", "", "inherit", "open", "closed", "", "ci", "", "", "2025-11-12 17:10:14", "2025-11-12 16:10:14", "", "108", "http://court-circuit.local/wp-content/uploads/2025/11/ci.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2025-11-12 17:10:14", "2025-11-12 16:10:14", "", "couple", "", "inherit", "open", "closed", "", "couple", "", "", "2025-11-12 17:10:14", "2025-11-12 16:10:14", "", "108", "http://court-circuit.local/wp-content/uploads/2025/11/couple.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2025-11-12 17:12:36", "2025-11-12 16:12:36", "<!-- wp:paragraph -->\n<p><strong>LA ROVE DE FA Annaïg SERVAIN et Matthieu VASLIN</strong><br>Elevage de chèvres du Rove. Fromages fermiers. Viande de chevreaux élevés sous la mère.<br>Ferme de Borde Grande<br>11330 Laroque de Fa<br>Tel : 04 68 40 20 16<br>Port : 06 87 11 74 19<br>Email : larovedefa @ gmail.com</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/P_RHZdmdIPk8BgG6uINugVV_SC8@297x170.jpg\" alt=\"Ferme de LAROVE\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/il0sZQm7qS7oHihFwFNj2Yyf1w0.png\"><img src=\"https://ekladata.com/il0sZQm7qS7oHihFwFNj2Yyf1w0@500x333.png\" alt=\"LAROVE DE FA\"/></a></figure>\n<!-- /wp:image -->", "LA ROVE DE FA", "", "inherit", "closed", "closed", "", "108-revision-v1", "", "", "2025-11-12 17:12:36", "2025-11-12 16:12:36", "", "108", "http://court-circuit.local/?p=120", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2025-11-12 17:16:42", "2025-11-12 16:16:42", "", "champi", "", "inherit", "open", "closed", "", "champi", "", "", "2025-11-12 17:16:42", "2025-11-12 16:16:42", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/champi.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("122", "1", "2025-11-12 17:16:42", "2025-11-12 16:16:42", "", "champi2", "", "inherit", "open", "closed", "", "champi2", "", "", "2025-11-12 17:16:42", "2025-11-12 16:16:42", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/champi2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "champi3", "", "inherit", "open", "closed", "", "champi3", "", "", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/champi3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "champi4", "", "inherit", "open", "closed", "", "champi4", "", "", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/champi4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "champi5", "", "inherit", "open", "closed", "", "champi5", "", "", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/champi5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "serre", "", "inherit", "open", "closed", "", "serre", "", "", "2025-11-12 17:16:43", "2025-11-12 16:16:43", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/serre.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("127", "1", "2025-11-12 17:16:44", "2025-11-12 16:16:44", "", "stand", "", "inherit", "open", "closed", "", "stand", "", "", "2025-11-12 17:16:44", "2025-11-12 16:16:44", "", "105", "http://court-circuit.local/wp-content/uploads/2025/11/stand.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2025-11-12 17:20:28", "2025-11-12 16:20:28", "{\n    \"creative-blog-writer::creative_blog_writer_post_date_settings\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:20:28\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_comments_settings\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:20:28\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_author_settings\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:20:28\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_timing_settings\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:20:28\"\n    }\n}", "", "", "trash", "closed", "closed", "", "7666927e-7e6d-4f37-a11a-d9a522475b91", "", "", "2025-11-12 17:20:28", "2025-11-12 16:20:28", "", "0", "http://court-circuit.local/7666927e-7e6d-4f37-a11a-d9a522475b91/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("129", "1", "2025-11-12 17:25:28", "2025-11-12 16:25:28", "{\n    \"creative-blog-writer::creative_blog_writer_single_post_featured_image_settings\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:20:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_site_title_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:22:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_tagline_setting\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:22:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_logo_width\": {\n        \"value\": \"5\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:25:28\"\n    },\n    \"creative-blog-writer::creative_blog_writer_slider_section_category\": {\n        \"value\": \"select\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:22:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_slider\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:23:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_our_products_show_hide_section\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:23:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_body_text\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:24:54\"\n    },\n    \"blogdescription\": {\n        \"value\": \"Le blog de l\'association et du march\\u00e9 du vendredi \\u00e0 Laroque de Fa\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:24:54\"\n    }\n}", "", "", "trash", "closed", "closed", "", "ed0a41f0-c6a2-4be4-96d9-7e71f08f33e3", "", "", "2025-11-12 17:25:28", "2025-11-12 16:25:28", "", "0", "http://court-circuit.local/?p=129", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2025-11-12 17:27:26", "2025-11-12 16:27:26", "{\n    \"creative-blog-writer::creative_blog_writer_customer_img\": {\n        \"value\": \"\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:26:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_index_sidebar_setting\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:26:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_paged_sidebar_setting\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:26:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_sidebar_position\": {\n        \"value\": \"left\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:26:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_sticky_header\": {\n        \"value\": false,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:27:26\"\n    }\n}", "", "", "trash", "closed", "closed", "", "74c644b2-459f-4b51-ad60-0815ae7da367", "", "", "2025-11-12 17:27:26", "2025-11-12 16:27:26", "", "0", "http://court-circuit.local/?p=130", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("132", "1", "2025-11-12 17:31:56", "2025-11-12 16:31:56", "{\n    \"creative-blog-writer::creative_blog_writer_customer_img\": {\n        \"value\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-logo_CCC-rose-e1762962632778.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:29:54\"\n    },\n    \"creative-blog-writer::creative_blog_writer_post_featured_image_settings\": {\n        \"value\": true,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:29:54\"\n    },\n    \"creative-blog-writer::background_color\": {\n        \"value\": \"#f7ebd6\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:31:54\"\n    },\n    \"creative-blog-writer::header_image\": {\n        \"value\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:31:54\"\n    },\n    \"creative-blog-writer::header_image_data\": {\n        \"value\": {\n            \"attachment_id\": 114,\n            \"url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\",\n            \"thumbnail_url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-bandeau5.jpg\",\n            \"alt_text\": \"\",\n            \"attachment_parent\": 9,\n            \"width\": 1045,\n            \"height\": 236,\n            \"timestamp\": [\n                \"1762963329\"\n            ]\n        },\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-12 16:31:54\"\n    }\n}", "", "", "trash", "closed", "closed", "", "25cf6e01-62ef-4acc-b84a-cdf6edda0dfb", "", "", "2025-11-12 17:31:56", "2025-11-12 16:31:56", "", "0", "http://court-circuit.local/?p=132", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2025-11-12 17:37:34", "2025-11-12 16:37:34", "<!-- wp:paragraph -->\n<p>Située à 540m d’altitude entre les sites pôles du Pays Cathare, l \'association Coeur de Village vous accueille dans une ambiance familiale. Le temps d’une pause routière, laissez-vous tenter part une dégustation de plus de 8 variétés de miels, découvrez une gamme de produits locaux dans un cadre atypique offrant une vue exceptionnelle sur des vestiges attrayant&nbsp;: Le château et le village castral forment l’un des ensembles les plus importants de l’époque féodale avec le château de Termes.<br>S’arrêter à la Buvette d’Auriac est un moment à part&nbsp;!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI.jpg\"><img src=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI@150x150.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc.jpg\"><img src=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8.jpg\"><img src=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Un lien vers Corbières Minervois &nbsp; &nbsp; &nbsp; &nbsp; https://www.tourisme-corbieres-minervois.com/la-buvette-d-auriac-1089.html</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/BgWpriUuT6u2tW8dVCYGGip90RA@895x292.jpg\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Café de pays à Auriac", "", "inherit", "closed", "closed", "", "103-autosave-v1", "", "", "2025-11-12 17:37:34", "2025-11-12 16:37:34", "", "103", "http://court-circuit.local/?p=133", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2025-11-12 17:38:26", "2025-11-12 16:38:26", "", "cafe epicerie", "", "inherit", "open", "closed", "", "cafe-epicerie", "", "", "2025-11-12 17:38:26", "2025-11-12 16:38:26", "", "103", "http://court-circuit.local/wp-content/uploads/2025/11/cafe-epicerie.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("135", "1", "2025-11-12 17:38:33", "2025-11-12 16:38:33", "<!-- wp:paragraph -->\n<p>Située à 540m d’altitude entre les sites pôles du Pays Cathare, l \'association Coeur de Village vous accueille dans une ambiance familiale. Le temps d’une pause routière, laissez-vous tenter part une dégustation de plus de 8 variétés de miels, découvrez une gamme de produits locaux dans un cadre atypique offrant une vue exceptionnelle sur des vestiges attrayant&nbsp;: Le château et le village castral forment l’un des ensembles les plus importants de l’époque féodale avec le château de Termes.<br>S’arrêter à la Buvette d’Auriac est un moment à part&nbsp;!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI.jpg\"><img src=\"https://ekladata.com/ynjl7aOB2sK0JF1HqiWUXlrW1GI@150x150.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc.jpg\"><img src=\"https://ekladata.com/BmkeUXS1d2EZWDl9CN9Pdds4Ntc@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"linkDestination\":\"custom\"} -->\n<figure class=\"wp-block-image\"><a href=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8.jpg\"><img src=\"https://ekladata.com/X0VkMs0eYeAUoY6m7Wmai4Xutw8@250x141.jpg\" alt=\"Café de pays à Auriac\"/></a></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Un lien vers Corbières Minervois &nbsp; &nbsp; &nbsp; &nbsp; https://www.tourisme-corbieres-minervois.com/la-buvette-d-auriac-1089.html</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"https://ekladata.com/BgWpriUuT6u2tW8dVCYGGip90RA@895x292.jpg\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Café de pays à Auriac", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2025-11-12 17:38:33", "2025-11-12 16:38:33", "", "103", "http://court-circuit.local/?p=135", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2025-11-12 17:40:33", "2025-11-12 16:40:33", "http://court-circuit.local/wp-content/uploads/2025/11/cropped-champi5.jpg", "cropped-champi5.jpg", "", "inherit", "open", "closed", "", "cropped-champi5-jpg", "", "", "2025-11-12 17:40:33", "2025-11-12 16:40:33", "", "0", "http://court-circuit.local/wp-content/uploads/2025/11/cropped-champi5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("141", "1", "2025-11-17 11:13:12", "2025-11-17 10:13:12", "{\n    \"twentythirteen::header_image\": {\n        \"value\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-17 10:13:12\"\n    },\n    \"twentythirteen::header_image_data\": {\n        \"value\": {\n            \"attachment_id\": 16,\n            \"url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\",\n            \"thumbnail_url\": \"http://court-circuit.local/wp-content/uploads/2025/06/cropped-silhouette.jpg\",\n            \"alt_text\": \"\",\n            \"attachment_parent\": 15,\n            \"width\": 1600,\n            \"height\": 230,\n            \"timestamp\": [\n                \"1750696657\"\n            ]\n        },\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-17 10:13:12\"\n    },\n    \"old_sidebars_widgets_data\": {\n        \"value\": {\n            \"wp_inactive_widgets\": [\n                \"block-6\"\n            ],\n            \"sidebar-1\": [\n                \"block-2\",\n                \"block-9\",\n                \"block-10\",\n                \"nav_menu-2\",\n                \"block-3\",\n                \"block-4\",\n                \"block-8\"\n            ],\n            \"sidebar-2\": []\n        },\n        \"type\": \"global_variable\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-17 10:13:12\"\n    },\n    \"twentythirteen::nav_menu_locations[primary]\": {\n        \"value\": 8,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-17 10:13:12\"\n    }\n}", "", "", "trash", "closed", "closed", "", "909a0af5-bbc6-4903-8884-700f962eb137", "", "", "2025-11-17 11:13:12", "2025-11-17 10:13:12", "", "0", "http://court-circuit.local/909a0af5-bbc6-4903-8884-700f962eb137/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("142", "1", "2025-11-17 11:20:57", "2025-11-17 10:20:57", "{\n    \"custom_css[twentythirteen]\": {\n        \"value\": \"@font-face {font-family: \\u2018Basalte sans-serif\\u2018;\\n src: url( \\u201cfonts/Basalte-Fond\\\") format(\\u2018woff\\u2019); /* sans-serif */\\n font-weight: sans-serif;\\n font-style: sans-serif;\\n}\\n\\nbody {\\n font-family: \'Basalte, \'sans-serif\';\'\\n src: url(( \\u201cfonts/Basalte-Fond\\\") format(\\u2018woff\\u2019); /* sans-serif */\\n font-weight: sans-serif;\\n font-style: sans-serif\\n}\\n\\nh1, h2, h3 {\\n font-family: \'Basalte\',\'sans-serif\';\\n src: url( ( \\u201cfonts/Basalte-Fond\\\") format(\\u2018woff\\u2019); /* sans-serif */\\n font-weight: sans-serif;\\n font-style: sans-serif;align-content)\\n}\",\n        \"type\": \"custom_css\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2025-11-17 10:20:57\"\n    }\n}", "", "", "trash", "closed", "closed", "", "dbfbb10d-fa11-443b-a00b-ec08e70e4ba8", "", "", "2025-11-17 11:20:57", "2025-11-17 10:20:57", "", "0", "http://court-circuit.local/?p=142", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("143", "1", "2025-11-17 11:20:57", "2025-11-17 10:20:57", "@font-face {font-family: ‘Basalte sans-serif‘;\n src: url( “fonts/Basalte-Fond\") format(‘woff’); /* sans-serif */\n font-weight: sans-serif;\n font-style: sans-serif;\n}\n\nbody {\n font-family: \'Basalte, \'sans-serif\';\'\n src: url(( “fonts/Basalte-Fond\") format(‘woff’); /* sans-serif */\n font-weight: sans-serif;\n font-style: sans-serif\n}\n\nh1, h2, h3 {\n font-family: \'Basalte\',\'sans-serif\';\n src: url( ( “fonts/Basalte-Fond\") format(‘woff’); /* sans-serif */\n font-weight: sans-serif;\n font-style: sans-serif;align-content)\n}", "twentythirteen", "", "inherit", "closed", "closed", "", "88-revision-v1", "", "", "2025-11-17 11:20:57", "2025-11-17 10:20:57", "", "88", "http://court-circuit.local/?p=143", "0", "revision", "", "0");

/* INSERT TABLE DATA: wp_term_relationships */
INSERT INTO `wp_term_relationships` VALUES("6", "2", "0");
INSERT INTO `wp_term_relationships` VALUES("25", "9", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "10", "0");
INSERT INTO `wp_term_relationships` VALUES("37", "11", "0");
INSERT INTO `wp_term_relationships` VALUES("43", "6", "0");
INSERT INTO `wp_term_relationships` VALUES("46", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("47", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("48", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("49", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("50", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("51", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("52", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("53", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("54", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("55", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("56", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("57", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("58", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("59", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("61", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("62", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("64", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("65", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("66", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("67", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("68", "8", "0");
INSERT INTO `wp_term_relationships` VALUES("100", "12", "0");
INSERT INTO `wp_term_relationships` VALUES("102", "18", "0");
INSERT INTO `wp_term_relationships` VALUES("103", "22", "0");
INSERT INTO `wp_term_relationships` VALUES("105", "21", "0");
INSERT INTO `wp_term_relationships` VALUES("108", "21", "0");

/* INSERT TABLE DATA: wp_term_taxonomy */
INSERT INTO `wp_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("2", "2", "wp_theme", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("4", "4", "nav_menu", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("5", "5", "nav_menu", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("6", "6", "nav_menu", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("7", "7", "nav_menu", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("8", "8", "nav_menu", "", "0", "21");
INSERT INTO `wp_term_taxonomy` VALUES("9", "9", "wp_pattern_category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("10", "10", "category", "", "0", "1");
INSERT INTO `wp_term_taxonomy` VALUES("11", "11", "category", "", "10", "1");
INSERT INTO `wp_term_taxonomy` VALUES("12", "12", "category", "", "10", "1");
INSERT INTO `wp_term_taxonomy` VALUES("13", "13", "category", "", "10", "0");
INSERT INTO `wp_term_taxonomy` VALUES("14", "14", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("15", "15", "category", "", "14", "0");
INSERT INTO `wp_term_taxonomy` VALUES("16", "16", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("17", "17", "category", "", "16", "0");
INSERT INTO `wp_term_taxonomy` VALUES("18", "18", "category", "", "16", "1");
INSERT INTO `wp_term_taxonomy` VALUES("19", "19", "category", "", "16", "0");
INSERT INTO `wp_term_taxonomy` VALUES("20", "20", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("21", "21", "category", "", "20", "2");
INSERT INTO `wp_term_taxonomy` VALUES("22", "22", "category", "", "20", "1");
INSERT INTO `wp_term_taxonomy` VALUES("23", "23", "category", "", "20", "0");
INSERT INTO `wp_term_taxonomy` VALUES("24", "24", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("26", "26", "category", "", "24", "0");
INSERT INTO `wp_term_taxonomy` VALUES("27", "27", "category", "", "24", "0");
INSERT INTO `wp_term_taxonomy` VALUES("28", "28", "category", "", "24", "0");
INSERT INTO `wp_term_taxonomy` VALUES("29", "29", "category", "", "24", "0");
INSERT INTO `wp_term_taxonomy` VALUES("30", "30", "category", "", "0", "0");
INSERT INTO `wp_term_taxonomy` VALUES("31", "31", "category", "", "30", "0");
INSERT INTO `wp_term_taxonomy` VALUES("32", "32", "category", "", "30", "0");

/* INSERT TABLE DATA: wp_terms */
INSERT INTO `wp_terms` VALUES("1", "Non classé", "non-classe", "0");
INSERT INTO `wp_terms` VALUES("2", "twentytwentyfive", "twentytwentyfive", "0");
INSERT INTO `wp_terms` VALUES("4", "LE MARCHÉ", "le-marche", "0");
INSERT INTO `wp_terms` VALUES("5", "GROUPEMENT D ACHAT", "groupement-d-achat", "0");
INSERT INTO `wp_terms` VALUES("6", "EXPOSANTS", "exposants", "0");
INSERT INTO `wp_terms` VALUES("7", "PETITES ANNONCES", "petites-annonces", "0");
INSERT INTO `wp_terms` VALUES("8", "L&#039;ASSOCIATION", "lassociation", "0");
INSERT INTO `wp_terms` VALUES("9", "Twenty Thirteen", "twentythirteen", "0");
INSERT INTO `wp_terms` VALUES("10", "L\'ASSOCIATION", "lassociation", "0");
INSERT INTO `wp_terms` VALUES("11", "NOS OBJECTIFS", "nos-objectifs", "0");
INSERT INTO `wp_terms` VALUES("12", "LES MEMBRES", "les-membres", "0");
INSERT INTO `wp_terms` VALUES("13", "SOUTIENS AUX PORTEURS DE PROJET", "soutiens-aux-porteurs-de-projet", "0");
INSERT INTO `wp_terms` VALUES("14", "GROUPEMENT D\'ACHAT", "groupement-dachat", "0");
INSERT INTO `wp_terms` VALUES("15", "COMMENT ÇA MARCHE ?", "comment-ca-marche", "0");
INSERT INTO `wp_terms` VALUES("16", "LE MARCHÉ", "le-marche", "0");
INSERT INTO `wp_terms` VALUES("17", "LES RENDEZ-VOUS", "les-rendez-vous", "0");
INSERT INTO `wp_terms` VALUES("18", "LISTE DE SPRODUITS VENDUS", "liste-de-sproduits-vendus", "0");
INSERT INTO `wp_terms` VALUES("19", "NOUVEAUX PRODUITS", "nouveaux-produits", "0");
INSERT INTO `wp_terms` VALUES("20", "EXPOSANTS", "exposants", "0");
INSERT INTO `wp_terms` VALUES("21", "LES PRODUCTEURS", "les-producteurs", "0");
INSERT INTO `wp_terms` VALUES("22", "LES REVENDEURS", "les-revendeurs", "0");
INSERT INTO `wp_terms` VALUES("23", "ARTISANS", "artisans", "0");
INSERT INTO `wp_terms` VALUES("24", "PETITES ANNONCES", "petites-annonces", "0");
INSERT INTO `wp_terms` VALUES("26", "MANIFESTATIONS ET ÉVENEMENTS", "manifestations-et-evenements", "0");
INSERT INTO `wp_terms` VALUES("27", "CHERCHE", "cherche", "0");
INSERT INTO `wp_terms` VALUES("28", "VEND / LOUE", "vend-loue", "0");
INSERT INTO `wp_terms` VALUES("29", "DONNE", "donne", "0");
INSERT INTO `wp_terms` VALUES("30", "EN LIEN", "en-lien", "0");
INSERT INTO `wp_terms` VALUES("31", "LIBRAIRIE", "librairie", "0");
INSERT INTO `wp_terms` VALUES("32", "AUTRES ASSOCIATIONS", "autres-associations", "0");

/* INSERT TABLE DATA: wp_usermeta */
INSERT INTO `wp_usermeta` VALUES("1", "1", "nickname", "courtcircuit");
INSERT INTO `wp_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `wp_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `wp_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `wp_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `wp_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `wp_usermeta` VALUES("12", "1", "wp_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_usermeta` VALUES("13", "1", "wp_user_level", "10");
INSERT INTO `wp_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "theme_editor_notice,plugin_editor_notice");
INSERT INTO `wp_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `wp_usermeta` VALUES("16", "1", "session_tokens", "a:1:{s:64:\"de5944037e37398bb44950f128db67a8ac6c04abc6c65d66fee28ec32bdeaf69\";a:4:{s:10:\"expiration\";i:1765361903;s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:145.0) Gecko/20100101 Firefox/145.0\";s:5:\"login\";i:1765189103;}}");
INSERT INTO `wp_usermeta` VALUES("17", "1", "wp_dashboard_quick_press_last_post_id", "93");
INSERT INTO `wp_usermeta` VALUES("18", "1", "wp_persisted_preferences", "a:7:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:4:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";i:2;s:23:\"taxonomy-panel-post_tag\";i:3;s:34:\"taxonomy-panel-wp_pattern_category\";}}s:9:\"_modified\";s:24:\"2025-11-10T15:36:36.622Z\";s:14:\"core/edit-site\";a:1:{s:12:\"welcomeGuide\";b:0;}s:22:\"core/customize-widgets\";a:1:{s:12:\"welcomeGuide\";b:0;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:17:\"core/edit-widgets\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:1;}}");
INSERT INTO `wp_usermeta` VALUES("19", "1", "wp_user-settings", "libraryContent=browse");
INSERT INTO `wp_usermeta` VALUES("20", "1", "wp_user-settings-time", "1750695509");
INSERT INTO `wp_usermeta` VALUES("21", "1", "nav_menu_recently_edited", "8");
INSERT INTO `wp_usermeta` VALUES("22", "1", "managenav-menuscolumnshidden", "a:4:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}");
INSERT INTO `wp_usermeta` VALUES("23", "1", "metaboxhidden_nav-menus", "a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}");
INSERT INTO `wp_usermeta` VALUES("24", "1", "closedpostboxes_dashboard", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("25", "1", "metaboxhidden_dashboard", "a:0:{}");
INSERT INTO `wp_usermeta` VALUES("26", "1", "community-events-location", "a:1:{s:2:\"ip\";s:9:\"127.0.0.0\";}");
INSERT INTO `wp_usermeta` VALUES("27", "1", "duplicator_email_subscribed", "1");

/* INSERT TABLE DATA: wp_users */
INSERT INTO `wp_users` VALUES("1", "courtcircuit", "$wp$2y$10$LZDLnXBMnZOeSFWz.Ex7FetIkQH5PKXJNtinnpJ2fJ3ZfsxBi6fo2", "courtcircuit", "dev-email@wpengine.local", "http://court-circuit.local", "2025-06-23 15:23:04", "", "0", "courtcircuit");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2025-12-08 10:33:03*/
/* DUPLICATOR_MYSQLDUMP_EOF */
