<?php
/**
 * Routes registration - Auto-generated by build process.
 * Registers all routes on their respective page init hooks.
 * Do not edit this file manually.
 *
 * @package gutenberg
 */

// Load routes registry
$routes_file = __DIR__ . '/routes/index.php';
if ( ! file_exists( $routes_file ) ) {
	return;
}

$routes = require $routes_file;

// Group routes by page
$routes_by_page = array();
foreach ( $routes as $route ) {
	$page_slug = $route['page'];
	if ( ! isset( $routes_by_page[ $page_slug ] ) ) {
		$routes_by_page[ $page_slug ] = array();
	}
	$routes_by_page[ $page_slug ][] = $route;
}

// Helper function to register routes for a page
$register_routes_callback = function ( $page_routes, $page_slug_underscore, $register_function_name ) {
	return function () use ( $page_routes, $page_slug_underscore, $register_function_name ) {
		foreach ( $page_routes as $route ) {
			$content_handle = null;
			$route_handle = null;

			// Register content module if exists
			if ( $route['has_content'] ) {
				$content_asset_path = __DIR__ . "/routes/{$route['name']}/content.min.asset.php";
				if ( file_exists( $content_asset_path ) ) {
					$content_asset = require $content_asset_path;
					$content_handle = 'wp/routes/' . $route['name'] . '/content';
					$extension = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '.js' : '.min.js';
					wp_register_script_module(
						$content_handle,
						plugins_url( 'build/routes/' . $route['name'] . '/content' . $extension, dirname( __FILE__ ) ),
						$content_asset['module_dependencies'] ?? array(),
						$content_asset['version'] ?? false
					);
				}
			}

			// Register route module if exists
			if ( $route['has_route'] ) {
				$route_asset_path = __DIR__ . "/routes/{$route['name']}/route.min.asset.php";
				if ( file_exists( $route_asset_path ) ) {
					$route_asset = require $route_asset_path;
					$route_handle = 'wp/routes/' . $route['name'] . '/route';
					$extension = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '.js' : '.min.js';
					wp_register_script_module(
						$route_handle,
						plugins_url( 'build/routes/' . $route['name'] . '/route' . $extension, dirname( __FILE__ ) ),
						$route_asset['module_dependencies'] ?? array(),
						$route_asset['version'] ?? false
					);
				}
			}

			// Register route with page
			if ( function_exists( $register_function_name ) ) {
				call_user_func( $register_function_name, $route['path'], $content_handle, $route_handle );
			}
		}
	};
};

// Register hooks for both full-page and wp-admin modes
foreach ( $routes_by_page as $page_slug => $page_routes ) {
	$page_slug_underscore = str_replace( '-', '_', $page_slug );

	// Register all routes for full-page mode (page.php)
	add_action(
		"{$page_slug}_init",
		$register_routes_callback( $page_routes, $page_slug_underscore, "register_{$page_slug_underscore}_route" )
	);

	// Register all routes for wp-admin mode (page-wp-admin.php)
	add_action(
		"{$page_slug}-wp-admin_init",
		$register_routes_callback( $page_routes, $page_slug_underscore, "register_{$page_slug_underscore}_wp_admin_route" )
	);
}
