<?php
if ( ! function_exists( 'creative_blog_writer_setup' ) ) :
function creative_blog_writer_setup() {

// Root path/URI.
define( 'CREATIVE_BLOG_WRITER_PARENT_DIR', get_template_directory() );
define( 'CREATIVE_BLOG_WRITER_PARENT_URI', get_template_directory_uri() );

// Root path/URI.
define( 'CREATIVE_BLOG_WRITER_PARENT_INC_DIR', CREATIVE_BLOG_WRITER_PARENT_DIR . '/inc');
define( 'CREATIVE_BLOG_WRITER_PARENT_INC_URI', CREATIVE_BLOG_WRITER_PARENT_URI . '/inc');

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-slider' );

	/*
	 * Let WordPress manage the document title.
	 */
	add_theme_support( 'title-tag' );

	add_theme_support( 'responsive-embeds' );
	
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );
	
	//Add selective refresh for sidebar widget
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	/*
	 * Make theme available for translation.
	 */
	load_theme_textdomain( 'creative-blog-writer', get_stylesheet_directory() . '/languages' );
		
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary'  => esc_html__( 'Primary Menu', 'creative-blog-writer' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
		
	add_theme_support('custom-logo');

	/*
	 * WooCommerce Plugin Support
	 */
	add_theme_support( 'woocommerce' );
	
	// Gutenberg wide images.
	add_theme_support( 'align-wide' );
	
	
	//Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'creative_blog_writer_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'assets/css/editor-style.css', creative_blog_writer_google_font_url() ) );

	add_theme_support( 'custom-header', apply_filters( 'creative_blog_writer_custom_header_args', array(
		'default-image'          => get_template_directory_uri() . '/assets/images/slider1.png',
		'default-text-color'     => 'ffffff',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-width'    		 => true,
		'flex-height'    		 => true,
        'uploads'            => true,
	)));


    /*
    * Enable support for Post Formats.
    *
    * See: https://codex.wordpress.org/Post_Formats
    */
    add_theme_support( 'post-formats', array('image','video','gallery','audio',) );


    //  --------------------------------------------- ENQUEUE ----------------------------------------------------- //
		
	/**
	 * Implement the Custom Header feature.
	 */
	require_once get_template_directory() . '/inc/custom-header.php';

	/**
	 * Demo Import
	 */
	require get_parent_theme_file_path( '/demo-import/demo-import-settings.php' );

	if ( ! defined( 'CREATIVE_BLOG_WRITER_FREE_THEME_URL' ) ) {
	define( 'CREATIVE_BLOG_WRITER_FREE_THEME_URL', 'https://www.seothemesexpert.com/products/free-blog-writer-wordpress-theme' );
	}
	if ( ! defined( 'CREATIVE_BLOG_WRITER_PRO_THEME_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_PRO_THEME_URL', 'https://www.seothemesexpert.com/products/writer-website-template' );
	}
	if ( ! defined( 'CREATIVE_BLOG_WRITER_FREE_DOCS_THEME_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_FREE_DOCS_THEME_URL', 'https://demo.seothemesexpert.com/documentation/creative-blog-writer/' );
	}
	if ( ! defined( 'CREATIVE_BLOG_WRITER_DEMO_THEME_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_DEMO_THEME_URL', 'https://demo.seothemesexpert.com/creative-blog-writer/' );
	}
	if ( ! defined( 'CREATIVE_BLOG_WRITER_RATE_THEME_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_RATE_THEME_URL', 'https://wordpress.org/support/theme/creative-blog-writer/reviews/#new-post' );
	}
	if ( ! defined( 'CREATIVE_BLOG_WRITER_SUPPORT_THEME_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_SUPPORT_THEME_URL', 'https://wordpress.org/support/theme/creative-blog-writer/' );
	}
	if ( ! defined( 'CREATIVE_BLOG_WRITER_THEME_BUNDLE_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_THEME_BUNDLE_URL', 'https://www.seothemesexpert.com/products/wordpress-theme-bundle' );
	}
		if ( ! defined( 'CREATIVE_BLOG_WRITER_DEMO_IMPORT_URL' ) ) {
		define( 'CREATIVE_BLOG_WRITER_DEMO_IMPORT_URL', esc_url( admin_url( 'themes.php?page=creativeblogwriter-wizard' ) ) );
    }

}
endif;
add_action( 'after_setup_theme', 'creative_blog_writer_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function creative_blog_writer_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'creative_blog_writer_content_width', 1170 );
}
add_action( 'after_setup_theme', 'creative_blog_writer_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

function creative_blog_writer_widgets_init() {
	
	register_sidebar( array(
		'name' => __( 'Sidebar Widget Area', 'creative-blog-writer' ),
		'id' => 'creative-blog-writer-sidebar-primary',
		'description' => __( 'The Primary Widget Area', 'creative-blog-writer' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4><div class="title"><span class="shap"></span></div>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Widget Area', 'creative-blog-writer' ),
		'id' => 'creative-blog-writer-footer-widget-area',
		'description' => __( 'The Footer Widget Area', 'creative-blog-writer' ),
		'before_widget' => '<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.2s"><aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside></div>',
		'before_title' => '<h5 class="widget-title w-title">',
		'after_title' => '</h5><span class="shap"></span>',
	) );
}
add_action( 'widgets_init', 'creative_blog_writer_widgets_init' );

/**
 * All Styles & Scripts.
 */

require_once get_template_directory() . '/inc/enqueue.php';

/**
 * Nav Walker fo Bootstrap Dropdown Menu.
 */

require_once get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php';

/**
 * Custom template tags for this theme.
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require_once get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require_once get_template_directory() . '/inc/customizer.php';

require_once get_template_directory() . '/inc/fonts.php';

require_once get_template_directory() . '/wptt-webfont-loader.php';


add_filter( 'nav_menu_link_attributes', 'creative_blog_writer_dropdown_data_attribute', 20, 3 );
/**
 * Use namespaced data attribute for Bootstrap's dropdown toggles.
 *
 * @param array    $atts HTML attributes applied to the item's `<a>` element.
 * @param WP_Post  $item The current menu item.
 * @param stdClass $args An object of wp_nav_menu() arguments.
 * @return array
 */
function creative_blog_writer_dropdown_data_attribute( $atts, $item, $args ) {
    if ( is_a( $args->walker, 'WP_Bootstrap_Navwalker' ) ) {
        if ( array_key_exists( 'data-toggle', $atts ) ) {
            unset( $atts['data-toggle'] );
            $atts['data-bs-toggle'] = 'dropdown';
        }
    }
    return $atts;
}

function creative_blog_writer_remove_theme_customizer_setting($wp_customize) {
    // Remove the setting
    $wp_customize->remove_setting('display_header_text');
    // Remove the control
    $wp_customize->remove_control('display_header_text');
}
add_action('customize_register', 'creative_blog_writer_remove_theme_customizer_setting', 20); 
// Use a priority greater than the one used for adding the setting


// Set the number of products per row to 3 on the shop page
add_filter('loop_shop_columns', 'creative_blog_writer_custom_shop_loop_columns');

if (!function_exists('creative_blog_writer_custom_shop_loop_columns')) {
    function creative_blog_writer_custom_shop_loop_columns() {
        // Retrieve the number of columns from theme customizer setting (default: 3)
        $creative_blog_writer_columns = get_theme_mod('creative_blog_writer_custom_shop_per_columns', 3);
        return $creative_blog_writer_columns;
    }
}

function creative_blog_writer_custom_controls() {
	
	load_template( trailingslashit( get_template_directory() ) . '/inc/customizer/customizer-custom-controls.php' );
}
add_action( 'customize_register', 'creative_blog_writer_custom_controls' );

// Set the number of products per page on the shop page
add_filter('loop_shop_per_page', 'creative_blog_writer_custom_shop_per_page', 20);

if (!function_exists('creative_blog_writer_custom_shop_per_page')) {
    function creative_blog_writer_custom_shop_per_page($creative_blog_writer_products_per_page) {
        // Retrieve the number of products per page from theme customizer setting (default: 9)
        $creative_blog_writer_products_per_page = get_theme_mod('creative_blog_writer_custom_shop_product_per_page', 9);
        return $creative_blog_writer_products_per_page;
    }
}

/**
 * Generate Google Fonts URL.
 */
function creative_blog_writer_google_font_url() {
    // Corrected Google Fonts URL format
    $creative_blog_writer_google_fonts_url = 'https://fonts.googleapis.com/css2?family=Figtree:wght@300;400;500;600;700;800;900&family=Lobster&display=swap';
    return $creative_blog_writer_google_fonts_url; 
}

/**
 * Enqueue theme styles and scripts.
 */

 function creative_blog_writer_scripts_styles() {
	$creative_blog_writer_headings_font = esc_html(get_theme_mod('creative_blog_writer_headings_text'));
	$creative_blog_writer_body_font = esc_html(get_theme_mod('creative_blog_writer_body_text'));

	if( $creative_blog_writer_headings_font ) {
		wp_enqueue_style( 'creative-blog-writer-headings-fonts', '//fonts.googleapis.com/css?family='. $creative_blog_writer_headings_font );
	} else {
		// Enqueue Google Fonts
        wp_enqueue_style('creative-blog-writer-google-fonts', creative_blog_writer_google_font_url(), array(), null);
	}
	if( $creative_blog_writer_body_font ) {
		wp_enqueue_style( 'creative-blog-writer-body-fonts', '//fonts.googleapis.com/css?family='. $creative_blog_writer_body_font );
	} else {
		// Enqueue main stylesheet
        wp_enqueue_style('creative-blog-writer-main-style', get_stylesheet_uri(), array(), '1.0.0');
	}
}
add_action( 'wp_enqueue_scripts', 'creative_blog_writer_scripts_styles' );

/**
 * Enqueue theme copyright alignment style.
 */
function creative_blog_writer_copyright_alignment_option() {
    // Get the alignment setting from the theme customizer.
    $creative_blog_writer_copyright_alignment = get_theme_mod('creative_blog_writer_copyright_alignment', 'center');

    // Start building the CSS string for the alignment.
    $creative_blog_writer_copyright_alignment_css = '
        .copyright-text, .footer-copyright, .footer-copyright a, p.copyright-text {
            text-align: ' . esc_attr($creative_blog_writer_copyright_alignment) . ';
        }
    ';

    // Add the inline style to the theme's main stylesheet.
    wp_add_inline_style('creative-blog-writer-style', $creative_blog_writer_copyright_alignment_css);
}

add_action('wp_enqueue_scripts', 'creative_blog_writer_copyright_alignment_option');

function creative_blog_writer_customize_css() {
    $creative_blog_writer_dynamic_color = get_theme_mod( 'creative_blog_writer_dynamic_color_one', '#B81B47' );
    $creative_blog_writer_custom_css = ":root { --color-primary1: {$creative_blog_writer_dynamic_color}; }";
    wp_add_inline_style( 'creative-blog-writer-style', $creative_blog_writer_custom_css );
}
add_action( 'wp_enqueue_scripts', 'creative_blog_writer_customize_css' );

// Show Admin Notice
function creative_blog_writer_promo_notice() {
    if (get_option('creative_blog_writer_notice_dismissed')) {
        return;
    }

    if (isset($_GET['page']) && in_array($_GET['page'], ['creativeblogwriter-wizard', 'greengrocer-wizard'])) {
        return;
    }
    

    $creative_blog_writer_theme = wp_get_theme();
    $creative_blog_writer_theme_title = $creative_blog_writer_theme->get( 'Name' );
    $creative_blog_writer_theme_version = $creative_blog_writer_theme->get( 'Version' );

    ?>
    <div class="notice creative-blog-writer-notice is-dismissible">
        <div>
            <h3>
                <span><?php echo esc_html( '(Version: ' . $creative_blog_writer_theme_version . ')' ); ?></span><br>
                <?php esc_html_e( 'Thank you for choosing,', 'creative-blog-writer'); ?>
                <?php echo esc_html( $creative_blog_writer_theme_title ); ?> <?php esc_html_e( '!!!', 'creative-blog-writer'); ?>
            </h3>
            <p><?php esc_html_e( 'Welcome! You can now easily start building your website using our beautiful and user-friendly themes. No need to worry about setup — with our one-click demo importer, your site can look just like the demo in minutes. All the tools and information you need to get started are right here!', 'creative-blog-writer'); ?></p>
            <a class="button button-primary creative-blog-writer-buy-now" href="<?php echo esc_url( CREATIVE_BLOG_WRITER_DEMO_IMPORT_URL ); ?>" target="_blank">
                <?php esc_html_e( 'One Click Demo Import', 'creative-blog-writer') ?>
            </a>
            <a class="button button-primary creative-blog-writer-bundle-button" target="_blank" href="<?php echo esc_url( CREATIVE_BLOG_WRITER_THEME_BUNDLE_URL ); ?>">
                <?php echo esc_html__( 'Get All 50+ Themes @ $79', 'creative-blog-writer' ); ?>
            </a>
        </div>
        <div class="creative-blog-writer-image-wrap">
            <img src="<?php echo esc_url(get_stylesheet_directory_uri() . '/screenshot.png'); ?>">
        </div>
        <canvas id="creative-blog-writer-notice-confetti"></canvas>
    </div>
    <?php
}
add_action('admin_notices', 'creative_blog_writer_promo_notice');

add_action('wp_ajax_creative_blog_writer_dismiss_notice', 'creative_blog_writer_dismiss_notice');
function creative_blog_writer_dismiss_notice() {
    update_option('creative_blog_writer_notice_dismissed', true);
    wp_send_json_success();
}

add_action('after_switch_theme', 'creative_blog_writer_reset_notice_on_activation');
function creative_blog_writer_reset_notice_on_activation() {
    delete_option('creative_blog_writer_notice_dismissed');
}

function creative_blog_writer_enqueue_admin_assets() {
    wp_enqueue_script(
        'creative-blog-writer-confetti',
        get_template_directory_uri() . '/demo-import/assets/js/confetti/confetti.min.js',
        ['jquery'],
        null,
        true
    );

    wp_enqueue_script(
        'creative-blog-writer-notice-confetti-js',
        get_template_directory_uri() . '/demo-import/assets/js/plugin-update-notice.js',
        ['creative-blog-writer-confetti'],
        null,
        true
    );

    wp_enqueue_script(
        'creative-blog-writer-notice-dismiss',
        get_template_directory_uri() . '/demo-import/assets/js/notice-dismiss.js',
        ['jquery'],
        null,
        true
    );
}
add_action('admin_enqueue_scripts', 'creative_blog_writer_enqueue_admin_assets');