<?php
/**
 * Creative Blog Writer Theme Customizer.
 *
 * @package Creative Blog Writer
 */

 if ( ! class_exists( 'Creative_Blog_Writer_Customizer' ) ) {

	/**
	 * Customizer Loader
	 *
	 * @since 1.0.0
	 */
	class Creative_Blog_Writer_Customizer {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object
		 */
		private static $creative_blog_writer_instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$creative_blog_writer_instance ) ) {
				self::$creative_blog_writer_instance = new self;
			}
			return self::$creative_blog_writer_instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			/**
			 * Customizer
			 */
			add_action( 'customize_preview_init',                  array( $this, 'creative_blog_writer_customizer_preview_js' ) );
			add_action( 'customize_controls_enqueue_scripts', 	   array( $this, 'creative_blog_writer_customizer_script' ) );
			add_action( 'customize_register',                      array( $this, 'creative_blog_writer_customizer_register' ) );
			add_action( 'after_setup_theme',                       array( $this, 'creative_blog_writer_customizer_settings' ) );
		}
		
		/**
		 * Add postMessage support for site title and description for the Theme Customizer.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 */
		function creative_blog_writer_customizer_register( $wp_customize ) {
			
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
			$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
			$wp_customize->get_setting('custom_logo')->transport = 'refresh';			
			
			/**
			 * Helper files
			 */
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/sanitization.php';
		} 
		
		/**
		 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
		 */
		function creative_blog_writer_customizer_preview_js() {
			wp_enqueue_script( 'creative-blog-writer-customizer', CREATIVE_BLOG_WRITER_PARENT_INC_URI . '/customizer/assets/js/customizer-preview.js', array( 'customize-preview' ), '20151215', true );
		}		
		
		function creative_blog_writer_customizer_script() {
			 wp_enqueue_script( 'creative-blog-writer-customizer-section', CREATIVE_BLOG_WRITER_PARENT_INC_URI .'/customizer/assets/js/customizer-section.js', array("jquery"),'', true  );
		}

		// Include customizer customizer settings.
			
		function creative_blog_writer_customizer_settings() {
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/header.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/frontpage.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/footer.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/post.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/sidebar-option.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-pro/customizer-upgrade-class.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/typography.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-options/general.php';
			require CREATIVE_BLOG_WRITER_PARENT_INC_DIR . '/customizer/customizer-pro/class-customize.php';
		}

	}
}

/**
 *  Kicking this off by calling 'get_instance()' method
 */
Creative_Blog_Writer_Customizer::get_instance();