<?php

function creative_blog_writer_footer( $wp_customize ) {
	$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	// Footer Panel // 
	$wp_customize->add_panel( 
		'creative_blog_writer_footer_section', 
		array(
			'priority'      => 34,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Footer Options', 'creative-blog-writer'),
		) 
	);

	// Footer Widgets // 
	$wp_customize->add_section(
        'creative_blog_writer_footer_top',
        array(
            'title' 		=> __('Footer Widgets','creative-blog-writer'),
			'panel'  		=> 'creative_blog_writer_footer_section',
			'priority'      => 3,
		)
    );

    // Footer Widgets Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_footer_widgets_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_footer_widgets_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Footer Widgets', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_footer_top',
			'settings'    => 'creative_blog_writer_footer_widgets_setting',
			'type'        => 'checkbox'
		) 
	);

	// Footer Background Image Setting
	$wp_customize->add_setting('creative_blog_writer_footer_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'creative_blog_writer_footer_bg_image',array(
	'label' => __('Footer Background Image','creative-blog-writer'),
	'section' => 'creative_blog_writer_footer_top'
	)));

	// Footer Background Image Opacity
	$wp_customize->add_setting('creative_blog_writer_footer_bg_image_opacity', array(
		'default'           => 50,
		'sanitize_callback' => 'absint',
		'capability'        => 'edit_theme_options',
	));

	$wp_customize->add_control('creative_blog_writer_footer_bg_image_opacity', array(
		'label'    => __('Footer Background Image Opacity (%)', 'creative-blog-writer'),
		'section'  => 'creative_blog_writer_footer_top',
		'type'     => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		),
	));

	// Footer Background Color Setting
    $wp_customize->add_setting('creative_blog_writer_footer_bg_color',array(
		'default' => '#151515',
		'sanitize_callback' => 'sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'creative_blog_writer_footer_bg_color',array(
		'label' => esc_html__('Footer Background Color', 'creative-blog-writer'),
		'section' => 'creative_blog_writer_footer_top', // Adjust section if needed
		'settings' => 'creative_blog_writer_footer_bg_color',
	)));

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_3',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_3',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_footer_top',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_3',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    ); 

	// Footer Bottom // 
	$wp_customize->add_section(
        'creative_blog_writer_footer_bottom',
        array(
            'title' 		=> __('Footer Bottom','creative-blog-writer'),
			'panel'  		=> 'creative_blog_writer_footer_section',
			'priority'      => 3,
		)
    );
	
	// Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_footer_copyright_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_footer_copyright_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Footer Copytight', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_footer_bottom',
			'settings'    => 'creative_blog_writer_footer_copyright_setting',
			'type'        => 'checkbox'
		) 
	);
	
	// Footer Copyright 
	$wp_customize->add_setting(
    	'creative_blog_writer_footer_copyright',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);

	$wp_customize->add_control( 
		'creative_blog_writer_footer_copyright',
		array(
		    'label'   		=> __('Edit Copyright Text','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_footer_bottom',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting( 'creative_blog_writer_copyright_alignment', array(
        'default'   => 'center',
        'sanitize_callback' => 'creative_blog_writer_sanitize_copyright_position',
    ));

    $wp_customize->add_control( 'creative_blog_writer_copyright_alignment', array(
        'label'    => __( 'Copyright Position', 'creative-blog-writer' ),
        'section'  => 'creative_blog_writer_footer_bottom',
        'settings' => 'creative_blog_writer_copyright_alignment',
        'type'     => 'radio',
        'choices'  => array(
            'right' => __( 'Right Align', 'creative-blog-writer' ),
            'left'  => __( 'Left Align', 'creative-blog-writer' ),
            'center'  => __( 'Center Align', 'creative-blog-writer' ),
        ),
    ));

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_4',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_4',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_footer_bottom',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_4',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    );
}
add_action( 'customize_register', 'creative_blog_writer_footer' );

// Footer selective refresh
function creative_blog_writer_footer_partials( $wp_customize ){
	// footer_copyright
	$wp_customize->selective_refresh->add_partial( 'footer_copyright', array(
		'selector'            => '.copy-right .copyright-text',
		'settings'            => 'footer_copyright',
		'render_callback'  => 'creative_blog_writer_footer_copyright_render_callback',
	) );
}
add_action( 'customize_register', 'creative_blog_writer_footer_partials' );

// copyright_content
function creative_blog_writer_footer_copyright_render_callback() {
	return get_theme_mod( 'footer_copyright' );
}