<?php
function creative_blog_writer_blog_setting( $wp_customize ) {

$wp_customize->register_control_type( 'Creative_Blog_Writer_Control_Upgrade' );

$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'creative_blog_writer_frontpage_sections', array(
			'priority' => 1,
			'title' => esc_html__( 'Frontpage Sections', 'creative-blog-writer' ),
		)
	);
	
	/*=========================================
	Slider Section
	=========================================*/
  	$wp_customize->add_section('creative_blog_writer_slider_section',array(
	    'title' => __('Slider Section','creative-blog-writer'),
	    'priority'  => 6,
	    'panel' => 'creative_blog_writer_frontpage_sections',
	));

	$wp_customize->add_setting('creative_blog_writer_slider',array(
		'default' => true,
		'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blog_writer_slider', array(
	   'settings' => 'creative_blog_writer_slider',
	   'section'   => 'creative_blog_writer_slider_section',
	   'label'     => __('Check To Enable This Section','creative-blog-writer'),
	   'type'      => 'checkbox'
	));

	$creative_blog_writer_categories = get_categories();
	$creative_blog_writer_cat_post = array();
	$creative_blog_writer_i = 0;
	$creative_blog_writer_cat_post['select'] = 'Select'; // Adding a default 'Select' option

	foreach ($creative_blog_writer_categories as $creative_blog_writer_category) {
	    if ($creative_blog_writer_i == 0) {
	        $creative_blog_writer_default = $creative_blog_writer_category->slug; // Set the first category slug as default
	        $creative_blog_writer_i++;
	    }
	    $creative_blog_writer_cat_post[$creative_blog_writer_category->slug] = $creative_blog_writer_category->name; // Store category slug and name in the array
	}

	// Add Customizer setting for selecting category
	$wp_customize->add_setting('creative_blog_writer_slider_section_category', array(
	    'default' => 'uncategorized', // Set default value to the first category slug
	    'sanitize_callback' => 'creative_blog_writer_sanitize_choices', // Sanitization function
	));
	$wp_customize->add_control('creative_blog_writer_slider_section_category', array(
	    'type'    => 'select',
	    'choices' => $creative_blog_writer_cat_post,
	    'label' => __('Select Slider Category', 'creative-blog-writer'),
	    'description' => __('Select a category for the slider. A maximum of 5 posts from the chosen category will be displayed.', 'creative-blog-writer'),
	    'section' => 'creative_blog_writer_slider_section',
	));

	$wp_customize->add_setting('creative_blog_writer_customer_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'creative_blog_writer_customer_img',array(
	    'label' => __('Add Writer Photo','creative-blog-writer'),
	     'section' => 'creative_blog_writer_slider_section'
	)));

	// name
	$wp_customize->add_setting(
	    'creative_blog_writer_reviewer_name',
	    array(
	        'default'           => 'John',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'creative_blog_writer_reviewer_name',
	    array(
	        'type'    => 'text',
	        'label'   => __('Add Writer Name', 'creative-blog-writer'),
	        'section' => 'creative_blog_writer_slider_section',
	    )
	);

	$wp_customize->add_setting(
	    'creative_blog_writer_total_rating',
	    array(
	        'default'           => '5',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control(
	    'creative_blog_writer_total_rating',
	    array(
	        'type'    => 'text',
	        'label'   => __('Add Rating', 'creative-blog-writer'),
	        'section' => 'creative_blog_writer_slider_section',
	    )
	);
	
	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_1',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_1',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_slider_section',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_1',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    );

	/*=========================================
	product Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_our_blog_section', array(
			'title' => esc_html__( 'Our Latest Blog Section', 'creative-blog-writer' ),
			'priority' => 7,
			'panel' => 'creative_blog_writer_frontpage_sections',
		)
	);

	// About Us Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_our_products_show_hide_section' , 
			array(
			'default' => true,
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	$wp_customize->add_control(
	'creative_blog_writer_our_products_show_hide_section', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_our_blog_section',
			'settings'    => 'creative_blog_writer_our_products_show_hide_section',
			'type'        => 'checkbox'
		) 
	);

	// About Heading
	$wp_customize->add_setting( 
    	'creative_blog_writer_our_products_heading_section',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'creative_blog_writer_our_products_heading_section',
		array(
		    'label'   		=> __('Add Latest Blog Heading','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_our_blog_section',
			'type' 			=> 'text',
		)
	);

	$wp_customize->add_setting('creative_blog_writer_serv_short_heading',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blog_writer_serv_short_heading',array(
		'label'	=> __('Add Latest Blog Content','creative-blog-writer'),
		'section'=> 'creative_blog_writer_our_blog_section',
		'type'=> 'text'
	));

	$creative_blog_writer_categories = get_categories();
	$cats = array();
	$creative_blog_writer_i = 0;
	$creative_blog_writer_offer_cat[] = 'select';
	foreach ($creative_blog_writer_categories as $creative_blog_writer_category) {
	  if ($creative_blog_writer_i == 0) {
	    $creative_blog_writer_default = $creative_blog_writer_category->slug;
	    $creative_blog_writer_i++;
	  }
	  $creative_blog_writer_offer_cat[$creative_blog_writer_category->slug] = $creative_blog_writer_category->name;
	}

	$wp_customize->add_setting('creative_blog_writer_featured_section_category', array(
	  'default' => 'Blogs',
	  'sanitize_callback' => 'creative_blog_writer_sanitize_choices',
	));
	$wp_customize->add_control('creative_blog_writer_featured_section_category', array(
	  'type' => 'select',
	  'choices' => $creative_blog_writer_offer_cat,
	  'label' => __('Select Category to show Latest Blogs', 'creative-blog-writer'),
	  'section' => 'creative_blog_writer_our_blog_section',
	));

	// YouTube URL
	$wp_customize->add_setting(
	    'creative_blog_writer_youtube_url',
	    array(
	        'default'           => '#',
	        'sanitize_callback' => 'esc_url_raw',
	    )
	);
	$wp_customize->add_control(
	    'creative_blog_writer_youtube_url',
	    array(
	        'type'    => 'url',
	        'label'   => __('Add Blog Video URL', 'creative-blog-writer'),
	        'section' => 'creative_blog_writer_our_blog_section',
	    )
	);

	$wp_customize->add_setting('creative_blog_writer_header_button',array(
		'default'=> 'View More',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blog_writer_header_button',array(
		'label'	=> __('Add View More Button Text','creative-blog-writer'),
		'section'=> 'creative_blog_writer_our_blog_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('creative_blog_writer_header_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('creative_blog_writer_header_link',array(
		'label'	=> __('Add View More Button Link','creative-blog-writer'),
		'section'=> 'creative_blog_writer_our_blog_section',
		'type'=> 'url'
	));

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_16',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_16',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_our_blog_section',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_16',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    ); 

}

add_action( 'customize_register', 'creative_blog_writer_blog_setting' );

// service selective refresh
function creative_blog_writer_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'creative_blog_writer_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'creative_blog_writer_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'creative_blog_writer_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'creative_blog_writer_blog_section_partials' );

// blog_title
function creative_blog_writer_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function creative_blog_writer_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function creative_blog_writer_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}