<?php
function creative_blog_writer_general_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'creative_blog_writer_general', array(
			'priority' => 2,
			'title' => esc_html__( 'General Options', 'creative-blog-writer' ),
		)
	);

	/*=========================================
	Breadcrumb  Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_breadcrumb_setting', array(
			'title' => esc_html__( 'Breadcrumb Options', 'creative-blog-writer' ),
			'priority' => 1,
			'panel' => 'creative_blog_writer_general',
		)
	);
	
	// Settings 
	$wp_customize->add_setting(
		'creative_blog_writer_breadcrumb_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'creative_blog_writer_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'creative_blog_writer_breadcrumb_settings',
		array(
			'type' => 'hidden',
			'label' => __('Settings','creative-blog-writer'),
			'section' => 'creative_blog_writer_breadcrumb_setting',
		)
	);
	
	// Breadcrumb Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_hs_breadcrumb' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_hs_breadcrumb', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_breadcrumb_setting',
			'settings'    => 'creative_blog_writer_hs_breadcrumb',
			'type'        => 'checkbox'
		) 
	);


	$wp_customize->add_setting(
    	'creative_blog_writer_breadcrumb_seprator',
    	array(
			'default' => '/',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'creative_blog_writer_breadcrumb_seprator',
		array(
		    'label'   		=> __('Breadcrumb separator','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_breadcrumb_setting',
			'type' 			=> 'text',
		)  
	);

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_5',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_5',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_breadcrumb_setting',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_5',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    ); 

	/*=========================================
	Preloader Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_preloader_section_setting', array(
			'title' => esc_html__( 'Preloader Options', 'creative-blog-writer' ),
			'priority' => 3,
			'panel' => 'creative_blog_writer_general',
		)
	);

	// Preloader Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_preloader_setting' , 
			array(
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_preloader_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Preloader', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_preloader_section_setting',
			'settings'    => 'creative_blog_writer_preloader_setting',
			'type'        => 'checkbox'
		) 
	);

	
	$wp_customize->add_setting(
    	'creative_blog_writer_preloader_text',
    	array(
			'default' => 'Loading',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'creative_blog_writer_preloader_text',
		array(
		    'label'   		=> __('Preloader Text','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_preloader_section_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	// Preloader Background Color Setting
    $wp_customize->add_setting(
        'creative_blog_writer_preloader_bg_color',
        array(
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_hex_color',
            'capability' => 'edit_theme_options',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'creative_blog_writer_preloader_bg_color',
            array(
                'label' => esc_html__('Preloader Background Color', 'creative-blog-writer'),
                'section' => 'creative_blog_writer_preloader_section_setting', // Adjust section if needed
                'settings' => 'creative_blog_writer_preloader_bg_color',
            )
        )
    );

    // Preloader Color Setting
    $wp_customize->add_setting(
        'creative_blog_writer_preloader_color',
        array(
            'default' => '#B81B47',
            'sanitize_callback' => 'sanitize_hex_color',
            'capability' => 'edit_theme_options',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'creative_blog_writer_preloader_color',
            array(
                'label' => esc_html__('Preloader Color', 'creative-blog-writer'),
                'section' => 'creative_blog_writer_preloader_section_setting', // Adjust section if needed
                'settings' => 'creative_blog_writer_preloader_color',
            )
        )
    );

    $wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_6',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_6',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_preloader_section_setting',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_6',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    ); 


	/*=========================================
	Scroll To Top Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_scroll_to_top_section_setting', array(
			'title' => esc_html__( 'Scroll To Top Options', 'creative-blog-writer' ),
			'priority' => 3,
			'panel' => 'creative_blog_writer_footer_section',
		)
	);

	// Scroll To Top Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_scroll_top_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_scroll_top_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Scroll To Top', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_scroll_to_top_section_setting',
			'settings'    => 'creative_blog_writer_scroll_top_setting',
			'type'        => 'checkbox'
		) 
	);

	// Scroll To Top Color Setting
	$wp_customize->add_setting(
		'creative_blog_writer_scroll_top_color',
		array(
			'default'           => '#fff',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'creative_blog_writer_scroll_top_color',
			array(
				'label'    => esc_html__( 'Scroll To Top Color', 'creative-blog-writer' ),
				'section'  => 'creative_blog_writer_scroll_to_top_section_setting',
				'settings' => 'creative_blog_writer_scroll_top_color',
			)
		)
	);

	// Scroll To Top Background Color Setting
	$wp_customize->add_setting(
		'creative_blog_writer_scroll_top_bg_color',
		array(
			'default'           => '#B81B47',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'creative_blog_writer_scroll_top_bg_color',
			array(
				'label'    => esc_html__( 'Scroll To Top Background Color', 'creative-blog-writer' ),
				'section'  => 'creative_blog_writer_scroll_to_top_section_setting',
				'settings' => 'creative_blog_writer_scroll_top_bg_color',
			)
		)
	);

	 $wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_7',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_7',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_scroll_to_top_section_setting',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_7',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    ); 

	/*=========================================
	Woocommerce Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_woocommerce_section_setting', array(
			'title' => esc_html__( 'Woocommerce Settings', 'creative-blog-writer' ),
			'priority' => 3,
			'panel' => 'woocommerce',
		)
	);

	$wp_customize->add_setting(
    	'creative_blog_writer_custom_shop_per_columns',
    	array(
			'default' => '3',
			'sanitize_callback' => 'absint',
		)
	);	
	$wp_customize->add_control( 
		'creative_blog_writer_custom_shop_per_columns',
		array(
		    'label'   		=> __('Product Per Columns','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'creative_blog_writer_custom_shop_product_per_page',
    	array(
			'default' => '9',
			'sanitize_callback' => 'absint',
		)
	);	
	$wp_customize->add_control( 
		'creative_blog_writer_custom_shop_product_per_page',
		array(
		    'label'   		=> __('Product Per Page','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	// Woocommerce Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_wocommerce_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_wocommerce_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Woocommerce Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_woocommerce_section_setting',
			'settings'    => 'creative_blog_writer_wocommerce_sidebar_setting',
			'type'        => 'checkbox'
		)
	);
	
	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_8',
		array(
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
		$wp_customize, 'creative_blog_writer_upgrade_page_settings_8',
			array(
				'priority'      => 200,
				'section'       => 'woocommerce_section_setting',
				'settings'      => 'creative_blog_writer_upgrade_page_settings_8',
				'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
			)
		)
	); 

	/*=========================================
	Sticky Header Section
	=========================================*/
	$wp_customize->add_section(
		'sticky_header_section_setting', array(
			'title' => esc_html__( 'Sticky Header Options', 'creative-blog-writer' ),
			'priority' => 3,
			'panel' => 'creative_blog_writer_general',
		)
	);

	// Sticky Header Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_sticky_header' , 
			array(
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);

	$wp_customize->add_control(
	'creative_blog_writer_sticky_header', 
		array(
			'label'	      => esc_html__( 'Hide / Show Sticky Header', 'creative-blog-writer' ),
			'section'     => 'sticky_header_section_setting',
			'settings'    => 'creative_blog_writer_sticky_header',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_9',
		array(
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
		$wp_customize, 'creative_blog_writer_upgrade_page_settings_9',
			array(
				'priority'      => 200,
				'section'       => 'sticky_header_section_setting',
				'settings'      => 'creative_blog_writer_upgrade_page_settings_9',
				'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
			)
		)
	); 

	/*=========================================
	404 Page Options
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_404_section', array(
			'title' => esc_html__( '404 Page Options', 'creative-blog-writer' ),
			'priority' => 1,
			'panel' => 'creative_blog_writer_general',
		)
	);

	$wp_customize->add_setting(
		'creative_blog_writer_404_title',
		array(
			'default' => '404',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'creative_blog_writer_404_title',
		array(
			'label'   		=> __('404 Heading','creative-blog-writer'),
			'section'		=> 'creative_blog_writer_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
		'creative_blog_writer_404_Text',
		array(
			'default' => 'Page Not Found',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'creative_blog_writer_404_Text',
		array(
			'label'   		=> __('404 Title','creative-blog-writer'),
			'section'		=> 'creative_blog_writer_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
		'creative_blog_writer_404_content',
		array(
			'default' => 'The page you were looking for could not be found.',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'creative_blog_writer_404_content',
		array(
			'label'   		=> __('404 Content','creative-blog-writer'),
			'section'		=> 'creative_blog_writer_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_10',
		array(
			'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
		$wp_customize, 'creative_blog_writer_upgrade_page_settings_10',
			array(
				'priority'      => 200,
				'section'       => 'creative_blog_writer_404_section',
				'settings'      => 'creative_blog_writer_upgrade_page_settings_10',
				'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
			)
		)
	);

}

add_action( 'customize_register', 'creative_blog_writer_general_setting' );