<?php
function creative_blog_writer_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';

    // Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_site_title_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_site_title_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Site Title', 'creative-blog-writer' ),
			'section'     => 'title_tagline',
			'settings'    => 'creative_blog_writer_site_title_setting',
			'type'        => 'checkbox'
		) 
	);

	// Tagline Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_tagline_setting' , 
			array(
			'default' => '',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_tagline_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Tagline', 'creative-blog-writer' ),
			'section'     => 'title_tagline',
			'settings'    => 'creative_blog_writer_tagline_setting',
			'type'        => 'checkbox'
		) 
	);

	// Add the setting for logo width
	$wp_customize->add_setting(
		'creative_blog_writer_logo_width',
		array(
			'default'           => '100',
			'sanitize_callback' => 'creative_blog_writer_sanitize_logo_width',
			'priority'          => 2,
		)
	);

	// Add control for logo width
	$wp_customize->add_control( 
		'creative_blog_writer_logo_width',
		array(
			'label'     => __('Logo Width', 'creative-blog-writer'),
			'section'   => 'title_tagline',
			'type'      => 'number',
			'input_attrs' => array(
				'min'   => 1,
				'max'   => 150,
				'step'  => 1,
			),
			'transport' => $selective_refresh,
		)  
	);
	
	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_583',
	array(
		'sanitize_callback' => 'sanitize_text_field'
	)
	);
	$wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
		$wp_customize, 'creative_blog_writer_upgrade_page_settings_583',
			array(
				'priority'      => 200,
				'section'       => 'title_tagline',
				'settings'      => 'creative_blog_writer_upgrade_page_settings_583',
				'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
			)
		)
	);

	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'creative_blog_writer_header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header Section', 'creative-blog-writer'),
		) 
	);

	/*=========================================
	Creative Blog Writer Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','creative-blog-writer'),
			'panel'  		=> 'creative_blog_writer_frontpage_sections',
		)
    );

	$wp_customize->register_panel_type( 'Creative_Blog_Writer_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'Creative_Blog_Writer_WP_Customize_Section' );

}
add_action( 'customize_register', 'creative_blog_writer_header_settings' );

if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class Creative_Blog_Writer_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'creative_blog_writer_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class Creative_Blog_Writer_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'creative_blog_writer_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}