<?php
function creative_blog_writer_post_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'creative_blog_writer_post', array(
			'priority' => 31,
			'title' => esc_html__( 'Post Options', 'creative-blog-writer' ),
		)
	);

	/*=========================================
	Archive Post  Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_archive_post_setting', array(
			'title' => esc_html__( 'Archive Post', 'creative-blog-writer' ),
			'priority' => 1,
			'panel' => 'creative_blog_writer_post',
		)
	);

	// Layouts Post
	$wp_customize->add_setting('creative_blog_writer_blog_layout_option_setting',array(
	  'default' => 'Default',
	  'sanitize_callback' => 'creative_blog_writer_sanitize_choices'
	));
	$wp_customize->add_control(new Creative_Blog_Writer_Image_Radio_Control($wp_customize, 'creative_blog_writer_blog_layout_option_setting', array(
	  'type' => 'select',
	  'label' => __('Blog Post Layouts','creative-blog-writer'),
	  'section' => 'creative_blog_writer_archive_post_setting',
	  'choices' => array(
		'Default' => esc_url(get_template_directory_uri()).'/assets/images/layout-1.png',
		'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout-2.png',
		'Right' => esc_url(get_template_directory_uri()).'/assets/images/layout-3.png',
	))));
		
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
		'creative_blog_writer_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Timing Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_timing_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_timing_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Timings', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_timing_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_archive_post_setting',
			'settings'    => 'creative_blog_writer_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting('creative_blog_writer_excerpt_limit', array(
        'default'           => 50,
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('creative_blog_writer_excerpt_limit', array(
        'label'   => __('Excerpt Word Limit', 'creative-blog-writer'),
        'section' => 'creative_blog_writer_archive_post_setting',
        'type'    => 'number',
    ));

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_133',
	array(
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
		$wp_customize, 'creative_blog_writer_upgrade_page_settings_133',
			array(
				'priority'      => 200,
				'section'       => 'creative_blog_writer_archive_post_setting',
				'settings'      => 'creative_blog_writer_upgrade_page_settings_133',
				'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
			)
		)
	); 

	/*=========================================
	Single Post  Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_single_post', array(
			'title' => esc_html__( 'Single Post', 'creative-blog-writer' ),
			'priority' => 3,
			'panel' => 'creative_blog_writer_post',
		)
	);
	
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_timing_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_timing_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Timings', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_timing_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_single_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);

	// Related Posts Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_show_hide_related_post' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_show_hide_related_post', 
		array(
			'label'	      => esc_html__( 'Hide / Show Related Posts', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_single_post',
			'settings'    => 'creative_blog_writer_show_hide_related_post',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 
    	'creative_blog_writer_related_posts_heading',
    	array(
			'default' => 'Related Posts',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'creative_blog_writer_related_posts_heading',
		array(
		    'label'   		=> __('Related Post Heading','creative-blog-writer'),
		    'section'		=> 'creative_blog_writer_single_post',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting('creative_blog_writer_related_post_counts', array(
        'default'           => 3,
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('creative_blog_writer_related_post_counts', array(
        'label'   => __('Number Of Related Posts To Show', 'creative-blog-writer'),
        'section' => 'creative_blog_writer_single_post',
        'type'    => 'number',
    ));

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_58',
	array(
		'sanitize_callback' => 'sanitize_text_field'
	)
	);
	$wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
		$wp_customize, 'creative_blog_writer_upgrade_page_settings_58',
			array(
				'priority'      => 200,
				'section'       => 'creative_blog_writer_single_post',
				'settings'      => 'creative_blog_writer_upgrade_page_settings_58',
				'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
			)
		)
	); 
}

add_action( 'customize_register', 'creative_blog_writer_post_setting' );