<?php
function creative_blog_writer_sidebar_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'creative_blog_writer_sidebar', array(
			'priority' => 31,
			'title' => esc_html__( 'Sidebar Options', 'creative-blog-writer' ),
		)
	);

	/*=========================================
	Sidebar Option  Section
	=========================================*/
	$wp_customize->add_section(
		'creative_blog_writer_sidebar_settings', array(
			'title' => esc_html__( 'Sidebar Options', 'creative-blog-writer' ),
			'priority' => 1,
			'panel' => 'creative_blog_writer_general',
		)
	);
	

	// Archive Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_archive_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_archive_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Archive Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_sidebar_settings',
			'settings'    => 'creative_blog_writer_archive_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Index Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_index_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_index_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Index Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_sidebar_settings',
			'settings'    => 'creative_blog_writer_index_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Pages Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_paged_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_paged_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Pages Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_sidebar_settings',
			'settings'    => 'creative_blog_writer_paged_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Search Result Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_search_result_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_search_result_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Search Result Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_sidebar_settings',
			'settings'    => 'creative_blog_writer_search_result_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Single Post Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_post_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_post_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Single Post Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_sidebar_settings',
			'settings'    => 'creative_blog_writer_single_post_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Sidebar Page Sidebar Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'creative_blog_writer_single_page_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'creative_blog_writer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'creative_blog_writer_single_page_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Page Width Sidebar', 'creative-blog-writer' ),
			'section'     => 'creative_blog_writer_sidebar_settings',
			'settings'    => 'creative_blog_writer_single_page_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 'creative_blog_writer_sidebar_position', array(
        'default'   => 'right',
        'sanitize_callback' => 'creative_blog_writer_sanitize_sidebar_position',
    ));

    $wp_customize->add_control( 'creative_blog_writer_sidebar_position', array(
        'label'    => __( 'Sidebar Position', 'creative-blog-writer' ),
        'section'  => 'creative_blog_writer_sidebar_settings',
        'settings' => 'creative_blog_writer_sidebar_position',
        'type'     => 'radio',
        'choices'  => array(
            'right' => __( 'Right Sidebar', 'creative-blog-writer' ),
            'left'  => __( 'Left Sidebar', 'creative-blog-writer' ),
        ),
    ));

	$wp_customize->add_setting( 'creative_blog_writer_upgrade_page_settings_15',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Creative_Blog_Writer_Control_Upgrade(
        $wp_customize, 'creative_blog_writer_upgrade_page_settings_15',
            array(
                'priority'      => 200,
                'section'       => 'creative_blog_writer_sidebar_settings',
                'settings'      => 'creative_blog_writer_upgrade_page_settings_15',
                'label'         => __( 'Creative Blog Writer Pro comes with additional features.', 'creative-blog-writer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'creative-blog-writer' ), __( 'One-Click Demo Import', 'creative-blog-writer' ), __( 'WooCommerce Integrated', 'creative-blog-writer' ), __( 'Drag & Drop Section Reordering', 'creative-blog-writer' ),__( 'Advanced Typography Control', 'creative-blog-writer' ),__( 'Intuitive Customization Options', 'creative-blog-writer' ),__( '24/7 Support', 'creative-blog-writer' ), )
            )
        )
    );

}

add_action( 'customize_register', 'creative_blog_writer_sidebar_setting' );