<?php

// In your theme's functions.php or equivalent
add_action('customize_controls_enqueue_scripts', function() {
    $version = wp_get_theme()->get('Version');
    
    // Define parameters
    $customizer_params = array(
        'some_key' => 'some_value', // Add your parameters here
    );
    
    wp_enqueue_script(
        'creative-blog-writer-customize-section-button',
        get_theme_file_uri('assets/js/customize-controls.js'),
        ['customize-controls'],
        $version,
        true
    );

    wp_enqueue_style(
        'creative-blog-writer-customize-section-button',
        get_theme_file_uri('assets/css/customize-controls.css'),
        ['customize-controls'],
        $version
    );

    wp_localize_script(
        'creative-blog-writer-customize-section-button',
        'creative_blog_writer_customizer_params',
        $customizer_params
    );
});


 /**
 * Enqueue scripts and styles.
 */
function creative_blog_writer_scripts() {
	// Styles	 

	wp_enqueue_style('bootstrap-min',get_template_directory_uri().'/assets/css/bootstrap.min.css');

	// owl
	wp_enqueue_style( 'owl-carousel-css', get_theme_file_uri( '/assets/css/owl.carousel.css' ) );
		
	wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/assets/css/fontawesome-all.css' );
	
	wp_enqueue_style('creative-blog-writer-editor-style',get_template_directory_uri().'/assets/css/editor-style.css');

	wp_enqueue_style('creative-blog-writer-main', get_template_directory_uri() . '/assets/css/main.css');

	wp_enqueue_style('creative-blog-writer-woo', get_template_directory_uri() . '/assets/css/woo.css');
	
	wp_enqueue_style( 'creative-blog-writer-style', get_stylesheet_uri() );


	wp_enqueue_style('creative-blog-writer-main', get_stylesheet_uri(), array() );
		wp_style_add_data('creative-blog-writer-main', 'rtl', 'replace');
	
	// Scripts

	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery'), false, true);

	wp_enqueue_script('creative-blog-writer-theme-js', get_template_directory_uri() . '/assets/js/theme.js', array('jquery'), false, true);

	wp_enqueue_script( 'owl-carousel-js', get_theme_file_uri( '/assets/js/owl.carousel.js' ), array( 'jquery' ), true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'creative_blog_writer_scripts' );

// Function to enqueue custom CSS
function creative_blog_writer_enqueue_custom_css() {
    // Define a unique handle for your inline stylesheet
    $handle = 'creative-blog-writer-style';
    
    // Get the generated custom CSS
    $creative_blog_writer_custom_css = "";

    $creative_blog_writer_blog_layouts = get_theme_mod('creative_blog_writer_blog_layout_option_setting', 'Default');
    if ($creative_blog_writer_blog_layouts == 'Default') {
        $creative_blog_writer_custom_css .= '.blog-item{';
        $creative_blog_writer_custom_css .= 'text-align:center;';
        $creative_blog_writer_custom_css .= '}';
    } elseif ($creative_blog_writer_blog_layouts == 'Left') {
        $creative_blog_writer_custom_css .= '.blog-item{';
        $creative_blog_writer_custom_css .= 'text-align:Left;';
        $creative_blog_writer_custom_css .= '}';
    } elseif ($creative_blog_writer_blog_layouts == 'Right') {
        $creative_blog_writer_custom_css .= '.blog-item{';
        $creative_blog_writer_custom_css .= 'text-align:Right;';
        $creative_blog_writer_custom_css .= '}';
    }
    // Enqueue the inline stylesheet
    wp_add_inline_style($handle, $creative_blog_writer_custom_css);

    // Add inline style for Scroll to Top
    $creative_blog_writer_scroll_top_bg_color = get_theme_mod('creative_blog_writer_scroll_top_bg_color', '#B81B47');
    $creative_blog_writer_scroll_top_color = get_theme_mod('creative_blog_writer_scroll_top_color', '#fff');

    // Use global if still default
    if ( $creative_blog_writer_scroll_top_bg_color === '#B81B47' ) {
        $creative_blog_writer_scroll_top_bg_color = get_theme_mod('creative_blog_writer_dynamic_color_one');
    }

    $creative_blog_writer_scroll_custom_css = "
        #scrolltop {
            background-color: {$creative_blog_writer_scroll_top_bg_color};
        }
        #scrolltop span {
            color: {$creative_blog_writer_scroll_top_color};
        }
    ";
    wp_add_inline_style('creative-blog-writer-style', $creative_blog_writer_scroll_custom_css);

    // Add inline style for Preloader
    $creative_blog_writer_preloader_bg_color = get_theme_mod('creative_blog_writer_preloader_bg_color', '#ffffff');
    $creative_blog_writer_preloader_color = get_theme_mod('creative_blog_writer_preloader_color', '#B81B47');

    // Use global if still default
    if ( $creative_blog_writer_preloader_color === '#B81B47' ) {
        $creative_blog_writer_preloader_color = get_theme_mod('creative_blog_writer_dynamic_color_one');
    }

    $creative_blog_writer_preloader_custom_css = "
        .loading {
            background-color: {$creative_blog_writer_preloader_bg_color};
        }
        .loader {
            border-color: {$creative_blog_writer_preloader_color};
            color: {$creative_blog_writer_preloader_color};
            text-shadow: 0 0 10px {$creative_blog_writer_preloader_color};
        }
        .loader::before {
            border-top-color: {$creative_blog_writer_preloader_color};
            border-right-color: {$creative_blog_writer_preloader_color};
        }
        .loader span::before {
            background: {$creative_blog_writer_preloader_color};
            box-shadow: 0 0 10px {$creative_blog_writer_preloader_color};
        }
    ";
    wp_add_inline_style('creative-blog-writer-style', $creative_blog_writer_preloader_custom_css);
}

// Hook the function to the 'wp_enqueue_scripts' action
add_action('wp_enqueue_scripts', 'creative_blog_writer_enqueue_custom_css');