<?php 
$creative_blog_writer_aboutus = get_theme_mod('creative_blog_writer_our_products_show_hide_section', true);
if ($creative_blog_writer_aboutus == '1') : ?>
  <section id="blog-section" class="py-5 mx-md-0 mx-3">
    <div class="container">
      <div class="text-center">
        <?php
        // Section Heading
        $creative_blog_writer_our_products_heading_section = get_theme_mod('creative_blog_writer_our_products_heading_section');
        if (!empty($creative_blog_writer_our_products_heading_section)) : ?>
          <h2 class="my-1 text-center product-heading">
            <?php echo esc_html($creative_blog_writer_our_products_heading_section); ?>
          </h2>
        <?php endif; ?>
        <?php if (get_theme_mod('creative_blog_writer_serv_short_heading', '')) : ?>
          <p class="serv-short mb-4">
            <?php echo esc_html(get_theme_mod('creative_blog_writer_serv_short_heading', '')); ?>
          </p>
        <?php endif; ?>
      </div>
      <?php
        // Initialize variables
        $creative_blog_writer_column_count = 4; // 4 columns
        $creative_blog_writer_columns_content = array_fill(0, $creative_blog_writer_column_count, []);
        $creative_blog_writer_post_category = get_theme_mod('creative_blog_writer_featured_section_category', 'Blogs');
        $creative_blog_writer_youtube_url = get_theme_mod('creative_blog_writer_youtube_url', '#');
        if ($creative_blog_writer_post_category) :
            // Query posts from the selected category
            $creative_blog_writer_page_query = new WP_Query(array(
                'category_name'  => sanitize_text_field($creative_blog_writer_post_category),
                'posts_per_page' => 6, // Limit to 6 posts
            ));
            if ($creative_blog_writer_page_query->have_posts()) :
                $creative_blog_writer_counter = 0;
                $creative_blog_writer_posts_distribution = [2, 1, 2, 1]; // 1st & 3rd => 2 posts, 2nd & 4th => 1 post
                $creative_blog_writer_column_index = 0;
                // Loop through posts and distribute into columns
                while ($creative_blog_writer_page_query->have_posts()) : $creative_blog_writer_page_query->the_post();
                    if (count($creative_blog_writer_columns_content[$creative_blog_writer_column_index]) >= $creative_blog_writer_posts_distribution[$creative_blog_writer_column_index]) {
                        $creative_blog_writer_column_index++; // Move to the next column when limit is reached
                    }
                    $creative_blog_writer_columns_content[$creative_blog_writer_column_index][] = [
                        'title'         => get_the_title(),
                        'permalink'     => get_permalink(),
                        'thumbnail_url' => has_post_thumbnail() ? get_the_post_thumbnail_url(null, 'full') : '',
                        'author_url'    => get_author_posts_url(get_the_author_meta('ID')),
                        'author_name'   => get_the_author(),
                        'post_date'     => get_the_date('j F Y'),
                        'date_url'      => get_day_link(get_the_date('Y'), get_the_date('m'), get_the_date('d')),
                        'tags'          => get_the_tags(), // Fetch tags
                        'unique_class'  => 'post-column-' . esc_attr($creative_blog_writer_column_index) . '-' . esc_attr($creative_blog_writer_counter)
                    ];
                    $creative_blog_writer_counter++;
                endwhile;
                wp_reset_postdata();
            endif;
        endif;
        ?>
        <div class="row">
          <?php for ($creative_blog_writer_i = 0; $creative_blog_writer_i < $creative_blog_writer_column_count; $creative_blog_writer_i++) : ?>
            <div class="col-lg-3 col-md-3 mb-md-4 serv-column-<?php echo esc_attr($creative_blog_writer_i + 1); ?>">
              <?php if (!empty($creative_blog_writer_columns_content[$creative_blog_writer_i])) : ?>
                <?php foreach ($creative_blog_writer_columns_content[$creative_blog_writer_i] as $post_index => $post) : ?>
                  <div class="cat-inner-box mb-md-3 mb-2 <?php echo esc_attr($post['unique_class']); ?>">
                      <?php if (!empty($post['thumbnail_url'])) : ?>
                        <div class="image-wrapper position-relative">
                          <img src="<?php echo esc_url($post['thumbnail_url']); ?>" alt="<?php echo esc_attr($post['title']); ?>" class="img-fluid" />
                          <?php if ($creative_blog_writer_i == 2 && $post_index == 0 && $creative_blog_writer_youtube_url) : ?>
                            <a href="<?php echo esc_url($creative_blog_writer_youtube_url); ?>" class="youtube-icon-overlay" target="_blank">
                              <i class="fas fa-play"></i>
                            </a>
                          <?php endif; ?>
                        </div>
                      <?php else : ?>
                        <div class="post-color position-relative">
                          <?php if ($creative_blog_writer_i == 2 && $post_index == 0 && $creative_blog_writer_youtube_url) : ?>
                            <a href="<?php echo esc_url($creative_blog_writer_youtube_url); ?>" class="youtube-icon-overlay" target="_blank">
                              <i class="fas fa-play"></i>
                            </a>
                          <?php endif; ?>
                        </div>
                      <?php endif; ?>
                      <div class="inner-content text-start py-2">
                        <div class="serv-tags">
                          <?php if ($post['tags']) : ?>
                            <?php $creative_blog_writer_first_tag = reset($post['tags']); ?>
                            <div class="post-tags">
                              <a href="<?php echo esc_url(get_tag_link($creative_blog_writer_first_tag->term_id)); ?>" class="tag-link"><i class="fa fa-tag"></i>
                                <?php echo esc_html($creative_blog_writer_first_tag->name); ?>
                              </a>
                            </div>
                          <?php endif; ?>
                        </div>
                        <div class="post-title">
                            <h3 class="my-1"><a href="<?php echo esc_url($post['permalink']); ?>"> <?php echo esc_html($post['title']); ?> </a></h3>
                        </div>
                        <div class="serv-metafield">
                          <a class="meta-admin" href="<?php echo esc_url($post['author_url']); ?>">
                            <?php echo esc_html($post['author_name']); ?>
                          </a> 
                          <span class="separator"> <?php echo esc_html__(' - ', 'creative-blog-writer'); ?> </span>
                          <a href="<?php echo esc_url($post['date_url']); ?>" class="entry-date">
                            <?php echo esc_html($post['post_date']); ?>
                          </a>
                        </div>
                      </div>
                  </div>
                <?php endforeach; ?>
              <?php endif; ?>
            </div>
          <?php endfor; ?>
        </div>
        <?php 
        $creative_blog_writer_header_button = get_theme_mod('creative_blog_writer_header_button', __('View More', 'creative-blog-writer'));
        $creative_blog_writer_header_link = get_theme_mod('creative_blog_writer_header_link', '');
        if (!empty($creative_blog_writer_header_button) && !empty($creative_blog_writer_header_link)) : ?>
        <span class="serv-btn text-center mt-3">
          <a target="_blank" href="<?php echo esc_url($creative_blog_writer_header_link); ?>" class="offer-text" rel="noopener noreferrer">
              <?php echo esc_html($creative_blog_writer_header_button); ?>
          </a>
        </span>
      <?php endif; ?>
    </div>
  </section>
<?php endif; ?>