<header class="main-header <?php if( get_theme_mod( 'creative_blog_writer_sticky_header', '0')) { ?>sticky-header<?php } else { ?>close-sticky<?php } ?>">
    <div class="headerbox">
        <div class="header-main container">
            <div class="row">
                <div class="col-lg-3 col-md-4 align-self-center">
                    <div class="logo text-center text-md-start mb-md-1 mb-3">
                        <?php
                        if (has_custom_logo()) {
                            the_custom_logo();
                        } else {
                            $creative_blog_writer_site_title = get_theme_mod('creative_blog_writer_site_title_setting', '1');
                            if ($creative_blog_writer_site_title == '1') {
                                if (is_front_page() && is_home()) { ?>
                                    <h1 class="site-title">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php bloginfo('name'); ?>
                                        </a>
                                    </h1>
                                <?php } else { ?>
                                    <p class="site-title">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php bloginfo('name'); ?>
                                        </a>
                                    </p>
                                <?php }
                            }
                            $creative_blog_writer_tagline = get_theme_mod('creative_blog_writer_tagline_setting');
                            if ($creative_blog_writer_tagline) {
                                $creative_blog_writer_site_desc = get_bloginfo('description'); ?>
                                <p class="site-description"><?php echo esc_html($creative_blog_writer_site_desc); ?></p>
                            <?php }
                        }
                        ?>
                    </div>
                </div>
                <div class="col-lg-8 col-md-4 col-6 align-self-center">
                    <div class="main-navhead">
                        <div class="menubox">
                            <div class="menu-content">
                                <!-- Main menu -->
                                <div class="navbar-menubar responsive-menu navigation_header">
                                    <div class="toggle-nav mobile-menu">
                                        <button onclick="creative_blog_writer_openNav()">
                                            <i class="fa-solid fa-bars"></i> <!-- Initial hamburger icon -->
                                        </button>
                                    </div>
                                    <div id="mySidenav" class="nav sidenav">
                                        <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'creative-blog-writer' ); ?>">
                                            <?php 
                                                wp_nav_menu(
                                                    array(
                                                        'theme_location' => 'primary',
                                                        'container_class' => 'main-menu clearfix',
                                                        'menu_class' => 'clearfix menu',
                                                        'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                                                        'fallback_cb' => 'wp_page_menu',
                                                    )
                                                );
                                            ?>
                                            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="creative_blog_writer_closeNav()">
                                                <i class="fa-solid fa-times"></i> <!-- Close icon for the menu -->
                                            </a>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-1 col-md-4 col-6 align-self-center text-lg-end text-center d-md-flex justify-content-lg-end align-items-md-center justify-content-center">
                    <span class="search-bar text-md-end text-center me-3 justify-content-center">
                        <button type="button" class="open-search"><i class="fas fa-search"></i></button>
                    </span>
                </div>
                <div class="search-outer">
                    <div class="inner_searchbox w-100 h-100">
                        <?php get_search_form(); ?>
                    <button type="button" class="search-close"><?php esc_html_e('CLOSE', 'creative-blog-writer'); ?></button>
                    </div>
                </div> 
            </div>
        </div>
    </div>
 <div class="clearfix"></div>
</header>