<?php
$creative_blog_writer_hidepageboxes = get_theme_mod('creative_blog_writer_slider', true);
$creative_blog_writer_catData = get_theme_mod('creative_blog_writer_slider_section_category','uncategorized');

if ($creative_blog_writer_hidepageboxes && $creative_blog_writer_catData) {
    $creative_blog_writer_slidepage_query = new WP_Query(array(
        'category_name' => esc_attr($creative_blog_writer_catData),
        'posts_per_page' => 5, // Limit to 5 posts
    ));
    if ($creative_blog_writer_slidepage_query->have_posts()) :
?>
    <section id="slider-cat">
        <div class="slideimg">
            <div class="owl-carousel sliderbox">
                <?php while ($creative_blog_writer_slidepage_query->have_posts()) : $creative_blog_writer_slidepage_query->the_post(); ?>
                    <div class="item">
                        <div class="imagebox slider-slide-content">
                            <div class="slide-thumbbx">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('full', array('class' => 'full-width-img')); ?>
                                <?php else : ?>
                                    <div class="slide-thumbbx-color full-width-img"></div>
                                <?php endif; ?>
                                <div class="text-content">
                                    <div class="text-inner-box">
                                        <div class="top-slider mb-2">
                                            <span class="service-category-name">
                                                <?php 
                                                $creative_blog_writer_tags = get_the_tags();
                                                if (!empty($creative_blog_writer_tags)) :
                                                    $creative_blog_writer_first_tag = reset($creative_blog_writer_tags); // Get the first tag
                                                ?>
                                                    <div class="post-tags">
                                                        <a href="<?php echo esc_url(get_tag_link($creative_blog_writer_first_tag->term_id)); ?>" class="tag-link me-4">
                                                            <i class="fa fa-tag pe-1"></i> <?php echo esc_html($creative_blog_writer_first_tag->name); ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </span>
                                            <span class="slider-time">
                                                <i class="fas fa-clock pe-1"></i><?php echo esc_html(get_the_time('h:i A')); ?>
                                            </span>
                                        </div>
                                        <h1 class="my-2">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php
                                                $creative_blog_writer_title = get_the_title();
                                                $creative_blog_writer_words = explode(' ', $creative_blog_writer_title);
                                                if (count($creative_blog_writer_words) >= 2) {
                                                    $creative_blog_writer_words[1] = '<span class="highlight">' . $creative_blog_writer_words[1] . '</span>';
                                                }
                                                $creative_blog_writer_styled_title = implode(' ', $creative_blog_writer_words);
                                                echo $creative_blog_writer_styled_title;
                                                ?>
                                            </a>
                                        </h1>
                                        <p class="mb-2 slider-content"><?php echo esc_html(wp_trim_words(get_the_content(), 20)); ?></p>
                                        <div class="review-box mt-3 text-start d-flex align-items-center">
                                            <?php
                                                $creative_blog_writer_customer_img = get_theme_mod('creative_blog_writer_customer_img');
                                                if (!empty($creative_blog_writer_customer_img)) {
                                                    echo '<img src="' . esc_url($creative_blog_writer_customer_img) . '" alt="Customer Image" />';
                                                } else {
                                                }
                                            ?>
                                            <?php if ($creative_blog_writer_reviewer_name = get_theme_mod('creative_blog_writer_reviewer_name','John')) : ?>
                                                <p class="mb-0 me-md-4 me-2 ms-2 text-capitalize customer-name"><?php echo esc_html($creative_blog_writer_reviewer_name); ?></p>
                                            <?php endif; ?>
                                            <?php if ($creative_blog_writer_total_rating = get_theme_mod('creative_blog_writer_total_rating','5')) : ?>
                                                <p class="mb-0 rating"><i class="fas fa-star me-2"></i><?php echo esc_html($creative_blog_writer_total_rating); ?></p>
                                            <?php endif; ?>
                                            <?php $creative_blog_writer_blog_archive_ordering = get_theme_mod('blog_meta_order', array('comment')); 
                                                foreach ($creative_blog_writer_blog_archive_ordering as $creative_blog_writer_blog_data_order) : 
                                                    if ('comment' === $creative_blog_writer_blog_data_order) : ?>
                                                        <div class="commentmain ms-3"><i class="fas fa-comments me-2"></i><span class="entry-comments"><?php echo esc_html(get_comments_number()); ?></span></div>
                                                    <?php endif;
                                            endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
        <div class="slide-cat">
            <div class="carousel-thumb-line">
                <div class="numbered-circles">
                    <?php for ($creative_blog_writer_i = 1; $creative_blog_writer_i <= 5; $creative_blog_writer_i++) : ?>
                        <span class="circle <?php echo esc_attr('circle-' . $creative_blog_writer_i); ?>" data-index="<?php echo esc_attr($creative_blog_writer_i); ?>">
                            <?php echo esc_html($creative_blog_writer_i); ?>
                        </span>
                    <?php endfor; ?>
                </div>
            </div>
            <div class="owl-carousel owl-theme">
                <?php rewind_posts(); // Reset the loop ?>
                <?php while ($creative_blog_writer_slidepage_query->have_posts()) : $creative_blog_writer_slidepage_query->the_post(); ?>
                    <div class="slider-imagebox owl-item">
                        <?php if (has_post_thumbnail()) : ?>
                            <a href="<?php the_permalink(); ?>" class="thumbnail-link">
                                <?php the_post_thumbnail('thumbnail-size', array('class' => 'thumbnail-img')); ?>
                            </a>
                        <?php else : ?>
                            <div class="slide-img-color"></div>
                        <?php endif; ?>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </section>
<?php
    endif; // end have_posts check
    wp_reset_postdata(); // Reset post data
}
?>